/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNExternalsHandler;
import org.tmatesoft.svn.core.ISVNStatusHandler;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.internal.SVNWorkspace;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.PathUtil;

class DefaultSVNExternalsHandler
implements ISVNExternalsHandler {
    DefaultSVNExternalsHandler() {
    }

    public void handleStatus(ISVNWorkspace parent, final String path, ISVNWorkspace external, final ISVNStatusHandler statusHandler, boolean remote, boolean descend, boolean includeUnmodified, boolean includeIgnored, boolean descendInUnversioned) throws SVNException {
        external.status("", remote, new ISVNStatusHandler(){

            public void handleStatus(String p, SVNStatus status) {
                p = PathUtil.append(path, p);
                status.setPath(p);
                statusHandler.handleStatus(p, status);
            }
        }, descend, includeUnmodified, includeIgnored);
    }

    public void handleCheckout(ISVNWorkspace parent, String path, ISVNWorkspace external, SVNRepositoryLocation location, long revision, boolean export, boolean recurse) throws SVNException {
        UpdateListener listener = new UpdateListener(path, (SVNWorkspace)parent);
        external.addWorkspaceListener(listener);
        external.checkout(location, revision, export);
        external.removeWorkspaceListener(listener);
    }

    public void handleUpdate(ISVNWorkspace parent, String path, ISVNWorkspace external, long revision) throws SVNException {
        UpdateListener listener = new UpdateListener(path, (SVNWorkspace)parent);
        external.addWorkspaceListener(listener);
        external.update("", revision, true);
        external.removeWorkspaceListener(listener);
    }

    private static final class UpdateListener
    extends SVNWorkspaceAdapter {
        private final String myPath;
        private final SVNWorkspace myParentWorkspace;

        private UpdateListener(String path, SVNWorkspace parent) {
            this.myPath = path;
            this.myParentWorkspace = parent;
        }

        public void updated(String externalPath, int contentsStatus, int propertiesStatus, long rev) {
            externalPath = PathUtil.append(this.myPath, externalPath);
            try {
                ISVNEntry entry = this.myParentWorkspace.locateEntry(externalPath);
                this.myParentWorkspace.fireEntryUpdated(entry, contentsStatus, propertiesStatus, rev);
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
    }
}

