/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff.delta;

import de.regnis.q.sequence.QSequenceDifference;
import de.regnis.q.sequence.QSequenceDifferenceBlockShifter;
import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceDummyCanceller;
import de.regnis.q.sequence.media.QSequenceCachableMedia;
import de.regnis.q.sequence.media.QSequenceCachingMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaNoConfusionDectector;
import de.regnis.q.sequence.media.QSequenceMediaComparer;
import java.util.List;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;

public class SVNSequenceMedia
implements QSequenceCachableMedia,
QSequenceMediaComparer {
    private final SVNSequenceLine[] myLeft;
    private final SVNSequenceLine[] myRight;

    public static List createBlocks(SVNSequenceLine[] baseLines, SVNSequenceLine[] lines) {
        try {
            SVNSequenceMedia media = new SVNSequenceMedia(baseLines, lines);
            QSequenceCachingMedia cachingMedia = new QSequenceCachingMedia(media, new QSequenceDummyCanceller());
            QSequenceDiscardingMedia discardingMedia = new QSequenceDiscardingMedia(cachingMedia, new QSequenceDiscardingMediaNoConfusionDectector(true), new QSequenceDummyCanceller());
            List blocks = new QSequenceDifference(discardingMedia, discardingMedia).getBlocks();
            new QSequenceDifferenceBlockShifter(cachingMedia, cachingMedia).shiftBlocks(blocks);
            return blocks;
        }
        catch (QSequenceCancelledException ex) {
            return null;
        }
    }

    public SVNSequenceMedia(SVNSequenceLine[] left, SVNSequenceLine[] right) {
        this.myLeft = left;
        this.myRight = right;
    }

    public int getLeftLength() {
        return this.myLeft.length;
    }

    public int getRightLength() {
        return this.myRight.length;
    }

    public Object getMediaLeftObject(int index) {
        return this.myLeft[index];
    }

    public Object getMediaRightObject(int index) {
        return this.myRight[index];
    }

    public boolean equals(int leftIndex, int rightIndex) {
        return this.myLeft[leftIndex].equals(this.myRight[rightIndex]);
    }

    public boolean equalsLeft(int left1, int left2) throws QSequenceCancelledException {
        return this.myLeft[left1].equals(this.myLeft[left2]);
    }

    public boolean equalsRight(int right1, int right2) throws QSequenceCancelledException {
        return this.myRight[right1].equals(this.myRight[right2]);
    }
}

