/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff.delta;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tmatesoft.svn.core.diff.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.diff.ISVNRAData;
import org.tmatesoft.svn.core.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.diff.delta.ISVNDeltaGenerator;
import org.tmatesoft.svn.core.diff.delta.SVNAllDeltaGenerator;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLineReader;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceMedia;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.FileTypeUtil;
import org.tmatesoft.svn.util.SVNAssert;

public class SVNSequenceDeltaGenerator
implements ISVNDeltaGenerator {
    private static final SVNAllDeltaGenerator ALL_DELTA_GENERATOR = new SVNAllDeltaGenerator();

    public void generateDiffWindow(ISVNDeltaConsumer consumer, ISVNRAData workFile, ISVNRAData baseFile) throws SVNException {
        try {
            if (!SVNSequenceDeltaGenerator.canProcess(workFile, baseFile)) {
                ALL_DELTA_GENERATOR.generateDiffWindow(consumer, workFile, baseFile);
                return;
            }
            SVNSequenceDeltaGenerator.doGenerateDiffWindow(workFile, baseFile, consumer);
        }
        catch (IOException ex) {
            throw new SVNException(ex);
        }
    }

    private static void doGenerateDiffWindow(ISVNRAData workFile, ISVNRAData baseFile, ISVNDeltaConsumer consumer) throws IOException, SVNException {
        SVNSequenceLine[] workLines = new SVNSequenceLineReader(null).read(workFile.read(0L, workFile.length()));
        SVNSequenceLine[] baseLines = new SVNSequenceLineReader(null).read(baseFile.read(0L, baseFile.length()));
        ArrayList instructions = new ArrayList();
        ArrayList newDatas = new ArrayList();
        SVNSequenceDeltaGenerator.createInstructions(baseLines, workLines, instructions, newDatas);
        long sourceLength = baseLines.length > 0 ? (long)(baseLines[baseLines.length - 1].getTo() + 1) : 0L;
        long targetLength = workLines.length > 0 ? (long)(workLines[workLines.length - 1].getTo() + 1) : 0L;
        long newDataLength = SVNSequenceDeltaGenerator.determineNewDataLength(newDatas);
        SVNDiffInstruction[] instructionsArray = instructions.toArray(new SVNDiffInstruction[instructions.size()]);
        OutputStream stream = consumer.textDeltaChunk(new SVNDiffWindow(0L, sourceLength, targetLength, instructionsArray, newDataLength));
        SVNSequenceDeltaGenerator.sendData(newDatas, stream);
        stream.close();
        consumer.textDeltaEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canProcess(ISVNRAData workFile, ISVNRAData baseFile) throws IOException {
        InputStreamReader workReader = new InputStreamReader(workFile.read(0L, workFile.length()));
        try {
            if (!FileTypeUtil.isTextFile(workReader, Integer.MAX_VALUE)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ((Reader)workReader).close();
        }
        InputStreamReader baseReader = new InputStreamReader(baseFile.read(0L, baseFile.length()));
        try {
            if (!FileTypeUtil.isTextFile(baseReader, Integer.MAX_VALUE)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ((Reader)baseReader).close();
        }
        return true;
    }

    private static void createInstructions(SVNSequenceLine[] baseLines, SVNSequenceLine[] workLines, List instructions, List bytesToSend) {
        List blocks = SVNSequenceMedia.createBlocks(baseLines, workLines);
        int lastBase = 0;
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            long charTo;
            long charFrom;
            QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)it.next();
            int baseFrom = block.getLeftFrom();
            int baseTo = block.getLeftTo();
            int workFrom = block.getRightFrom();
            int workTo = block.getRightTo();
            if (lastBase < baseFrom) {
                charFrom = baseLines[lastBase].getFrom();
                SVNAssert.assertTrue(charFrom <= (charTo = (long)baseLines[baseFrom - 1].getTo()));
                instructions.add(new SVNDiffInstruction(0, charTo - charFrom + 1L, charFrom));
            }
            if (workTo >= workFrom) {
                charFrom = workLines[workFrom].getFrom();
                SVNAssert.assertTrue(charFrom <= (charTo = (long)workLines[workTo].getTo()));
                instructions.add(new SVNDiffInstruction(2, charTo - charFrom + 1L, 0L));
                for (int lineIndex = workFrom; lineIndex <= workTo; ++lineIndex) {
                    bytesToSend.add(workLines[lineIndex].getBytes());
                }
            }
            lastBase = baseTo + 1;
        }
        if (lastBase <= baseLines.length - 1) {
            long baseTo;
            long baseFrom = baseLines[lastBase].getFrom();
            SVNAssert.assertTrue(baseFrom <= (baseTo = (long)baseLines[baseLines.length - 1].getTo()));
            instructions.add(new SVNDiffInstruction(0, baseTo - baseFrom + 1L, baseFrom));
        }
    }

    private static long determineNewDataLength(List datas) {
        long length = 0L;
        Iterator it = datas.iterator();
        while (it.hasNext()) {
            byte[] data = (byte[])it.next();
            length += (long)data.length;
        }
        return length;
    }

    private static void sendData(List datas, OutputStream stream) throws IOException {
        Iterator it = datas.iterator();
        while (it.hasNext()) {
            byte[] bytes = (byte[])it.next();
            stream.write(bytes);
        }
    }
}

