/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.diff;

import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.core.diff.ISVNRAData;
import org.tmatesoft.svn.core.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;

public class SVNDiffWindow {
    private final long mySourceViewOffset;
    private final long mySourceViewLength;
    private final long myTargetViewLength;
    private final SVNDiffInstruction[] myInstructions;
    private final long myNewDataLength;

    public SVNDiffWindow(long sourceViewOffset, long sourceViewLength, long targetViewLength, SVNDiffInstruction[] instructions, long newDataLength) {
        this.mySourceViewOffset = sourceViewOffset;
        this.mySourceViewLength = sourceViewLength;
        this.myTargetViewLength = targetViewLength;
        this.myInstructions = instructions;
        this.myNewDataLength = newDataLength;
    }

    public long getSourceViewOffset() {
        return this.mySourceViewOffset;
    }

    public long getSourceViewLength() {
        return this.mySourceViewLength;
    }

    public long getTargetViewLength() {
        return this.myTargetViewLength;
    }

    public int getInstructionsCount() {
        return this.myInstructions.length;
    }

    public SVNDiffInstruction getInstructionAt(int index) {
        return this.myInstructions[index];
    }

    public long getNewDataLength() {
        return this.myNewDataLength;
    }

    /*
     * Loose catch block
     */
    public void apply(ISVNRAData source, ISVNRAData target, InputStream newData, long offset) throws SVNException {
        block17: {
            if (target == null) {
                throw new SVNException("target shouldn't be null");
            }
            InputStream src = null;
            for (int i = 0; i < this.myInstructions.length; ++i) {
                this.myInstructions[i].offset += offset;
                switch (this.myInstructions[i].type) {
                    case 2: {
                        src = newData;
                        break;
                    }
                    case 1: {
                        src = target.read(this.myInstructions[i].offset, this.myInstructions[i].length);
                        break;
                    }
                    default: {
                        src = source.read(this.myInstructions[i].offset, this.myInstructions[i].length);
                    }
                }
                target.append(src, this.myInstructions[i].length);
            }
            Object var9_8 = null;
            try {
                source.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            try {
                target.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            break block17;
            {
                catch (IOException e) {
                    DebugLog.error(e);
                    throw new SVNException(e);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    source.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                try {
                    target.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSourceViewOffset());
        sb.append(":");
        sb.append(this.getSourceViewOffset());
        sb.append(":");
        sb.append(this.getTargetViewLength());
        sb.append(":");
        sb.append(this.getInstructionsCount());
        sb.append(":");
        sb.append(this.getNewDataLength());
        sb.append("::");
        for (int i = 0; i < this.getInstructionsCount(); ++i) {
            sb.append(this.getInstructionAt(i).toString());
        }
        sb.append(":");
        return sb.toString();
    }
}

