/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

public class SVNStatus {
    public static final int NOT_MODIFIED = 0;
    public static final int ADDED = 1;
    public static final int CONFLICTED = 2;
    public static final int DELETED = 3;
    public static final int MERGED = 4;
    public static final int IGNORED = 5;
    public static final int MODIFIED = 6;
    public static final int REPLACED = 7;
    public static final int UNVERSIONED = 8;
    public static final int MISSING = 9;
    public static final int OBSTRUCTED = 10;
    public static final int REVERTED = 11;
    public static final int RESOLVED = 12;
    public static final int COPIED = 13;
    public static final int MOVED = 14;
    public static final int RESTORED = 15;
    public static final int UPDATED = 16;
    public static final int EXTERNAL = 18;
    public static final int CORRUPTED = 19;
    public static final int NOT_REVERTED = 20;
    private boolean myIsSwitched;
    private boolean myIsAddedWithHistory;
    private long myRemoteRevision;
    private long myWCRevision;
    private long myRevision;
    private int myContentsStatus;
    private int myPropertiesStatus;
    private int myRemoteContentsStatus;
    private int myRemotePropertiesStatus;
    private String myPath;
    private boolean myIsDirectory;
    private String myAuthor;

    public SVNStatus(String path, int propStatus, int contentsStatus, long revision, long wcRevision, boolean addedWithHistory, boolean switched, boolean isDirectory, String author) {
        this(path, propStatus, contentsStatus, revision, wcRevision, -1L, 0, 0, addedWithHistory, switched, isDirectory, author);
    }

    public SVNStatus(String path, int propStatus, int contentsStatus, long revision, long wcRevision, long remoteRevision, int remoteContentsStatus, int remotePropsStatus, boolean addedWithHistory, boolean switched, boolean isDirectory, String author) {
        this.myPath = path;
        this.myPropertiesStatus = propStatus;
        this.myContentsStatus = contentsStatus;
        this.myRevision = revision;
        this.myWCRevision = wcRevision;
        this.myRemoteRevision = remoteRevision;
        this.myIsAddedWithHistory = addedWithHistory;
        this.myIsSwitched = switched;
        this.myRemotePropertiesStatus = remotePropsStatus;
        this.myRemoteContentsStatus = remoteContentsStatus;
        this.myIsDirectory = isDirectory;
        this.myAuthor = author;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public String getPath() {
        return this.myPath;
    }

    public int getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public int getContentsStatus() {
        return this.myContentsStatus;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getWorkingCopyRevision() {
        return this.myWCRevision;
    }

    public long getRepositoryRevision() {
        return this.myRemoteRevision;
    }

    public int getRepositoryContentsStatus() {
        return this.myRemoteContentsStatus;
    }

    public int getRepositoryPropertiesStatus() {
        return this.myRemotePropertiesStatus;
    }

    public boolean isAddedWithHistory() {
        return this.myIsAddedWithHistory;
    }

    public boolean isSwitched() {
        return this.myIsSwitched;
    }

    public boolean isManaged() {
        return this.getContentsStatus() != 8 && this.getContentsStatus() != 5;
    }

    public void setRemoteStatus(long revision, int propStatus, int contentsStatus) {
        this.myRemotePropertiesStatus = propStatus;
        this.myRemoteContentsStatus = contentsStatus;
        this.myRemoteRevision = revision;
    }

    public void setPath(String path) {
        this.myPath = path;
    }
}

