/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import org.tigris.subversion.javahl.Notify;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.SVNUtil;

class UpdateWorkspaceListener
extends SVNWorkspaceAdapter {
    private ISVNWorkspace myWorkspace;
    private Notify myNotify;
    private String myRootPath;

    public UpdateWorkspaceListener(Notify notify, ISVNWorkspace ws) {
        this(notify, ws, null);
    }

    public UpdateWorkspaceListener(Notify notify, ISVNWorkspace ws, String rootPath) {
        this.myWorkspace = ws;
        this.myNotify = notify;
        this.myRootPath = rootPath;
    }

    public void updated(String p, int contentsStatus, int propertiesStatus, long updated) {
        if (this.myNotify == null) {
            return;
        }
        int updateKind = 0;
        int contents = 0;
        switch (contentsStatus) {
            case 1: {
                updateKind = 9;
                break;
            }
            case 4: {
                contents = contents != 0 ? contents : 6;
            }
            case 2: {
                contents = contents != 0 ? contents : 7;
            }
            case 7: 
            case 16: {
                updateKind = 10;
                contents = contents != 0 ? contents : 5;
                break;
            }
            case 3: {
                updateKind = 8;
            }
        }
        int props = 2;
        switch (propertiesStatus) {
            case 16: {
                props = 5;
                break;
            }
            case 2: {
                props = 7;
                break;
            }
            case 4: {
                props = 6;
            }
        }
        contents = contents == 0 ? 2 : contents;
        try {
            String mimeType = this.myWorkspace.getPropertyValue(p, "svn:mime-type");
            String nodeKindStr = this.myWorkspace.getPropertyValue(p, "svn:entry:kind");
            int nodeKind = 3;
            if ("dir".equals(nodeKindStr)) {
                nodeKind = 2;
            } else if ("file".equals(nodeKindStr)) {
                nodeKind = 1;
            }
            p = SVNUtil.getAbsolutePath(this.myWorkspace, p);
            this.myNotify.onNotify(p, updateKind, nodeKind, mimeType, contents, props, updated);
        }
        catch (SVNException e) {
            // empty catch block
        }
    }
}

