/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.Date;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.StatusKind;

public class Status {
    private String url;
    private String path;
    private int nodeKind;
    private long revision;
    private long lastChangedRevision;
    private long lastChangedDate;
    private String lastCommitAuthor;
    private int textStatus;
    private int propStatus;
    private boolean locked;
    private boolean copied;
    private boolean switched;
    private int repositoryTextStatus;
    private int repositoryPropStatus;
    private String conflictNew;
    private String conflictOld;
    private String conflictWorking;
    private String urlCopiedFrom;
    private long revisionCopiedFrom;

    public Status(String path, String url, int nodeKind, long revision, long lastChangedRevision, long lastChangedDate, String lastCommitAuthor, int textStatus, int propStatus, int repositoryTextStatus, int repositoryPropStatus, boolean locked, boolean copied, String conflictOld, String conflictNew, String conflictWorking, String urlCopiedFrom, long revisionCopiedFrom, boolean switched) {
        this.path = path;
        this.url = url;
        this.nodeKind = nodeKind;
        this.revision = revision;
        this.lastChangedRevision = lastChangedRevision;
        this.lastChangedDate = lastChangedDate;
        this.lastCommitAuthor = lastCommitAuthor;
        this.textStatus = textStatus;
        this.propStatus = propStatus;
        this.locked = locked;
        this.copied = copied;
        this.repositoryTextStatus = repositoryTextStatus;
        this.repositoryPropStatus = repositoryPropStatus;
        this.conflictOld = conflictOld;
        this.conflictNew = conflictNew;
        this.conflictWorking = conflictWorking;
        this.urlCopiedFrom = urlCopiedFrom;
        this.revisionCopiedFrom = revisionCopiedFrom;
        this.switched = switched;
    }

    public String getPath() {
        return this.path;
    }

    public Revision.Number getRevision() {
        if (this.revision < 0L) {
            return null;
        }
        return new Revision.Number(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate == 0L) {
            return null;
        }
        return new Date(this.lastChangedDate / 1000L);
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public int getTextStatus() {
        return this.textStatus;
    }

    public String getTextStatusDescription() {
        return Kind.getDescription(this.textStatus);
    }

    public int getPropStatus() {
        return this.propStatus;
    }

    public String getPropStatusDescription() {
        return Kind.getDescription(this.propStatus);
    }

    public int getRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public int getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getConflictNew() {
        return this.conflictNew;
    }

    public String getConflictOld() {
        return this.conflictOld;
    }

    public String getConflictWorking() {
        return this.conflictWorking;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision.Number getLastChangedRevision() {
        if (this.lastChangedRevision < 0L) {
            return null;
        }
        return new Revision.Number(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public String getUrlCopiedFrom() {
        return this.urlCopiedFrom;
    }

    public Revision.Number getRevisionCopiedFrom() {
        if (this.revisionCopiedFrom < 0L) {
            return null;
        }
        return new Revision.Number(this.revisionCopiedFrom);
    }

    public long getRevisionCopiedFromNumber() {
        return this.revisionCopiedFrom;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public boolean isManaged() {
        int textStatus = this.getTextStatus();
        return textStatus != 5 && textStatus != 0 && textStatus != 11;
    }

    public boolean hasRemote() {
        int textStatus = this.getTextStatus();
        return this.isManaged() && textStatus != 3;
    }

    public boolean isAdded() {
        int textStatus = this.getTextStatus();
        return textStatus == 3;
    }

    public boolean isDeleted() {
        int textStatus = this.getTextStatus();
        return textStatus == 4;
    }

    public boolean isMerged() {
        int textStatus = this.getTextStatus();
        return textStatus == 8;
    }

    public boolean isIgnored() {
        int textStatus = this.getTextStatus();
        return textStatus == 11;
    }

    public boolean isModified() {
        int textStatus = this.getTextStatus();
        return textStatus == 2;
    }

    public static final class Kind
    implements StatusKind {
        public static final String getDescription(int kind) {
            switch (kind) {
                case 0: {
                    return "non-svn";
                }
                case 1: {
                    return "normal";
                }
                case 3: {
                    return "added";
                }
                case 6: {
                    return "missing";
                }
                case 4: {
                    return "deleted";
                }
                case 7: {
                    return "replaced";
                }
                case 2: {
                    return "modified";
                }
                case 8: {
                    return "merged";
                }
                case 9: {
                    return "conflicted";
                }
                case 11: {
                    return "ignored";
                }
                case 12: {
                    return "incomplete";
                }
                case 13: {
                    return "external";
                }
            }
            return "unversioned";
        }
    }
}

