/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import org.tigris.subversion.javahl.ISVNCredentialsStorage;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PromptUserPassword3;
import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.ISVNCredentialsProviderEx;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.core.io.SVNSimpleCredentialsProvider;
import org.tmatesoft.svn.util.DebugLog;

public class SVNPromptCredentialsProvider
implements ISVNCredentialsProviderEx {
    private PromptUserPassword myPrompt;
    private boolean myIsAccepted;
    private boolean myIsAllowedtoSave;
    private SVNRepositoryLocation myLocation;
    private String myInitialUserName;
    private String myInitialPassword;
    private static ISVNCredentialsStorage ourStorage;

    public SVNPromptCredentialsProvider(PromptUserPassword svnPrompt, String userName, String password) {
        this.myPrompt = svnPrompt;
        this.myIsAccepted = true;
        this.myInitialUserName = userName;
        this.myInitialPassword = password;
        this.myInitialUserName = "".equals(this.myInitialUserName) ? null : this.myInitialUserName;
    }

    public static void setCredentialsStorage(ISVNCredentialsStorage storage) {
        ourStorage = storage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISVNCredentials nextCredentials(String realm, SVNRepositoryLocation location) {
        String userName;
        if (location != null) {
            String string = realm = realm == null ? location.toCanonicalForm() : realm;
        }
        if (this.myInitialUserName != null && this.myInitialPassword != null) {
            return new SVNSimpleCredentialsProvider.SimpleCredentials(this.myInitialUserName, this.myInitialPassword, null, null);
        }
        this.myLocation = location;
        if (ourStorage != null && location != null) {
            ISVNCredentials credentials = ourStorage.getCredentials(location);
            if (credentials != null) {
                DebugLog.log("stored credentials are used");
                return credentials;
            }
            DebugLog.log("no stored credentials found");
        }
        if ((userName = this.myPrompt.getUsername()) == null) {
            userName = System.getProperty("user.name");
        }
        String password = this.myPrompt.getPassword();
        this.myIsAllowedtoSave = false;
        if (this.myPrompt instanceof PromptUserPassword3) {
            PromptUserPassword3 prompt3 = (PromptUserPassword3)this.myPrompt;
            if (prompt3.userAllowedSave() && this.myIsAccepted) return new SVNSimpleCredentialsProvider.SimpleCredentials(userName, password, null, null);
            if (!prompt3.prompt(realm, userName, true)) return null;
            userName = prompt3.getUsername();
            password = prompt3.getPassword();
            this.myIsAllowedtoSave = prompt3.userAllowedSave();
            return new SVNSimpleCredentialsProvider.SimpleCredentials(userName, password, null, null);
        } else {
            if (this.myPrompt.prompt(realm, userName)) return new SVNSimpleCredentialsProvider.SimpleCredentials(userName, password, null, null);
            return null;
        }
    }

    public ISVNCredentials nextCredentials(String realm) {
        return null;
    }

    public void accepted(ISVNCredentials credentials) {
        DebugLog.log("credentials accepted: " + credentials.getName());
        if (this.myInitialUserName != null) {
            DebugLog.log("credentials are not stored");
            return;
        }
        if (this.myIsAllowedtoSave && ourStorage != null && this.myLocation != null) {
            ourStorage.saveCredentials(this.myLocation, credentials);
            DebugLog.log("credentials are stored");
            this.myLocation = null;
            this.myIsAllowedtoSave = false;
        }
        this.myIsAccepted = true;
    }

    public void notAccepted(ISVNCredentials credentials, String failureReason) {
        DebugLog.log("credentials NOT accepted: " + credentials.getName());
        if (this.myInitialUserName != null) {
            DebugLog.log("stored credentials are NOT deleted");
            this.myInitialUserName = null;
            this.myInitialPassword = null;
            return;
        }
        if (ourStorage != null && this.myLocation != null) {
            ourStorage.deleteCredentials(this.myLocation);
            DebugLog.log("credentials are deleted from storage");
            this.myLocation = null;
            this.myIsAllowedtoSave = false;
        }
        this.myIsAccepted = false;
    }

    public void reset() {
    }
}

