/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CommitItem;
import org.tigris.subversion.javahl.CommitMessage;
import org.tigris.subversion.javahl.CommitWorkspaceListener;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.LocalWorkspaceListener;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.Notify;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientExternalsHandler;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.SVNClientLogLevel;
import org.tigris.subversion.javahl.SVNPromptCredentialsProvider;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.UpdateWorkspaceListener;
import org.tmatesoft.svn.core.ISVNCommitHandler;
import org.tmatesoft.svn.core.ISVNEntryContent;
import org.tmatesoft.svn.core.ISVNStatusHandler;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.SVNWorkspaceManager;
import org.tmatesoft.svn.core.diff.ISVNDiffGenerator;
import org.tmatesoft.svn.core.diff.SVNDiffManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.ws.fs.FSEntryFactory;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.io.SVNDirEntry;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNLogEntry;
import org.tmatesoft.svn.core.io.SVNLogEntryPath;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.core.io.SVNSimpleCredentialsProvider;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;
import org.tmatesoft.svn.util.TimeUtil;
import org.tmatesoft.svn.util.Version;

public class SVNClient
implements SVNClientInterface {
    private CommitMessage myMessageHandler;
    private String myUserName;
    private String myPassword;
    private Notify myNotify;
    private PromptUserPassword myPrompt;
    private String myConfigDir;
    static final int[] STATUS_CONVERTION_TABLE = new int[19];

    public SVNClient() {
        SVNDiffManager.setup();
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSEntryFactory.setup();
    }

    public void dispose() {
    }

    public static String version() {
        return Version.getVersionString();
    }

    public static int versionMajor() {
        return Version.getMajorVersion();
    }

    public static int versionMinor() {
        return Version.getMinorVersion();
    }

    public static int versionMicro() {
        return Version.getMicroVersion();
    }

    public void username(String username) {
        this.myUserName = username;
    }

    public void password(String password) {
        this.myPassword = password;
    }

    public void setPrompt(PromptUserPassword prompt) {
        DebugLog.log("prompt set: " + prompt);
        this.myPrompt = prompt;
    }

    public Info info(String path) throws ClientException {
        if (path == null) {
            return null;
        }
        Map properties = null;
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            properties = ws.getProperties(SVNUtil.getWorkspacePath(ws, path), false, true);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
        if (properties != null) {
            String name = (String)properties.get("svn:entry:name");
            String url = (String)properties.get("svn:entry:url");
            String uuid = (String)properties.get("svn:entry:uuid");
            String repository = null;
            int schedule = 0;
            if ("add".equals(properties.get("svn:entry:schedule"))) {
                schedule = 1;
            } else if ("delete".equals(properties.get("svn:entry:schedule"))) {
                schedule = 2;
            }
            int nodeKind = 3;
            if ("dir".equals(properties.get("svn:entry:kind"))) {
                nodeKind = 2;
            } else if ("file".equals(properties.get("svn:entry:kind"))) {
                nodeKind = 1;
            }
            String author = (String)properties.get("svn:entry:last-author");
            long revision = SVNProperty.longValue((String)properties.get("svn:entry:revision"));
            long lastChangedRevision = SVNProperty.longValue((String)properties.get("svn:entry:committed-rev"));
            Date lastChangedDate = TimeUtil.parseDate((String)properties.get("svn:entry:committed-date"));
            Date lastTextUpdate = TimeUtil.parseDate((String)properties.get("svn:entry:text-time"));
            Date lastPropsUpdate = TimeUtil.parseDate((String)properties.get("svn:entry:prop-time"));
            boolean copied = SVNProperty.booleanValue((String)properties.get("svn:entry:copied"));
            File file = new File(path);
            boolean deleted = !file.exists() && schedule == 2;
            boolean absent = !deleted && !file.exists();
            boolean incomplete = false;
            long copyRev = SVNProperty.longValue((String)properties.get("svn:entry:copyfrom-rev"));
            String copyUrl = (String)properties.get("svn:entry:copyfrom-url");
            return new Info(name, url, uuid, repository, schedule, nodeKind, author, revision, lastChangedRevision, lastChangedDate, lastTextUpdate, lastPropsUpdate, copied, deleted, absent, incomplete, copyRev, copyUrl);
        }
        return null;
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll) throws ClientException {
        return this.status(path, descend, onServer, getAll, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore) throws ClientException {
        if (path == null) {
            DebugLog.log("status doesn't accept NULL path");
            return null;
        }
        DebugLog.log("STATUS PARAMS: " + descend + "," + onServer + "," + getAll + "," + noIgnore);
        DebugLog.log("IO fetching status for: " + path);
        final LinkedList statuses = new LinkedList();
        try {
            final ISVNWorkspace ws = this.createWorkspace(path);
            long revision = ws.status(SVNUtil.getWorkspacePath(ws, path), onServer, new ISVNStatusHandler(){

                public void handleStatus(String p, SVNStatus status) {
                    try {
                        Map properties = ws.getProperties(p, false, true);
                        if (properties == null) {
                            properties = Collections.EMPTY_MAP;
                        }
                        statuses.add(SVNClient.createStatus(SVNUtil.getAbsolutePath(ws, p), properties, status));
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                }
            }, descend, getAll, noIgnore);
            if (this.myNotify != null) {
                this.myNotify.onNotify(path, 13, 2, "", 0, 0, revision);
            }
        }
        catch (SVNException e) {
            return new Status[0];
        }
        return statuses.toArray(new Status[statuses.size()]);
    }

    public Status singleStatus(String path, boolean onServer) throws ClientException {
        if (path == null) {
            return null;
        }
        DebugLog.log("IO fetching 'single' status for: " + path);
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            SVNStatus status = ws.status(SVNUtil.getWorkspacePath(ws, path), onServer);
            Map properties = ws.getProperties(SVNUtil.getWorkspacePath(ws, path), false, true);
            DebugLog.log("single status for: " + path + " : " + properties);
            return SVNClient.createStatus(path, properties, status);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
            return null;
        }
    }

    public DirEntry[] list(String url, Revision revision, boolean recurse) throws ClientException {
        TreeSet<DirEntry> allEntries = new TreeSet<DirEntry>(new Comparator(){

            public int compare(Object o1, Object o2) {
                DirEntry d1 = (DirEntry)o1;
                DirEntry d2 = (DirEntry)o2;
                if (d1 == null || d1.getPath() == null) {
                    return d2 == null || d2.getPath() == null ? 0 : -1;
                }
                if (d2 == null || d2.getPath() == null) {
                    return 1;
                }
                return d1.getPath().toLowerCase().compareTo(d2.getPath().toLowerCase());
            }
        });
        ISVNWorkspace ws = null;
        String wsPath = null;
        if (!SVNClient.isURL(url)) {
            try {
                ws = this.createWorkspace(url);
                wsPath = SVNUtil.getWorkspacePath(ws, url);
                url = ws.getLocation(wsPath).toString();
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        }
        DebugLog.log("LIST is called for " + url);
        try {
            SVNRepository repository = this.createRepository(url);
            String parentPath = "";
            long revNumber = SVNClient.getRevisionNumber(revision, repository, ws, wsPath);
            Collection entries = repository.getDir("", revNumber, null, (Collection)null);
            Iterator svnEntries = entries.iterator();
            while (svnEntries.hasNext()) {
                DirEntry[] children;
                SVNDirEntry svnEntry = (SVNDirEntry)svnEntries.next();
                allEntries.add(SVNClient.createDirEntry(parentPath, svnEntry));
                if (!recurse || svnEntry.getKind() != SVNNodeKind.DIR || (children = this.list(url + "/" + svnEntry.getName(), revision, recurse)) == null) continue;
                allEntries.addAll(Arrays.asList(children));
            }
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
        return allEntries.toArray(new DirEntry[allEntries.size()]);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, true, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath) throws ClientException {
        final LinkedList<LogMessage> logMessages = new LinkedList<LogMessage>();
        ISVNLogEntryHandler handler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                logMessages.add(logEntry);
            }
        };
        if (SVNClient.isURL(path)) {
            try {
                String target = "";
                if (!path.endsWith("/")) {
                    target = PathUtil.tail(path);
                    path = PathUtil.removeTail(path);
                }
                SVNRepository repository = this.createRepository(path);
                long revStart = SVNClient.getRevisionNumber(revisionStart, repository, null, null);
                long revEnd = SVNClient.getRevisionNumber(revisionEnd, repository, null, null);
                repository.log(new String[]{target}, revStart, revEnd, discoverPath, stopOnCopy, handler);
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        } else if (path != null) {
            try {
                ISVNWorkspace workspace = this.createWorkspace(path);
                String wsPath = SVNUtil.getWorkspacePath(workspace, path);
                SVNRepository repository = SVNUtil.createRepository(workspace, wsPath);
                long revStart = SVNClient.getRevisionNumber(revisionStart, repository, workspace, wsPath);
                long revEnd = SVNClient.getRevisionNumber(revisionEnd, repository, workspace, wsPath);
                workspace.log(wsPath, revStart, revEnd, stopOnCopy, discoverPath, handler);
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        }
        for (int i = 0; i < logMessages.size(); ++i) {
            logMessages.set(i, SVNClient.createLogMessage((SVNLogEntry)logMessages.get(i)));
        }
        return logMessages.toArray(new LogMessage[logMessages.size()]);
    }

    public long checkout(String moduleName, String destPath, Revision revision, boolean recurse) throws ClientException {
        File file = new File(destPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            ISVNWorkspace ws = SVNWorkspaceManager.createWorkspace("file", new File(destPath).getAbsolutePath());
            SVNRepositoryLocation location = SVNRepositoryLocation.parseURL(moduleName);
            SVNRepository repository = SVNRepositoryFactory.create(location);
            if (this.myPrompt != null) {
                ws.setCredentials(new SVNPromptCredentialsProvider(this.myPrompt, this.myUserName, this.myPassword));
                repository.setCredentialsProvider(new SVNPromptCredentialsProvider(this.myPrompt, this.myUserName, this.myPassword));
            } else if (this.myUserName != null && this.myPassword != null) {
                ws.setCredentials(new SVNSimpleCredentialsProvider(this.myUserName, this.myPassword));
                repository.setCredentialsProvider(new SVNSimpleCredentialsProvider(this.myUserName, this.myPassword));
            }
            ws.setExternalsHandler(new SVNClientExternalsHandler(this.myNotify));
            long rev = SVNClient.getRevisionNumber(revision, repository, null, null);
            ws.addWorkspaceListener(new UpdateWorkspaceListener(this.myNotify, ws));
            long checkedOut = ws.checkout(location, rev, false, recurse);
            if (checkedOut >= 0L && this.myNotify != null) {
                this.myNotify.onNotify(destPath, 11, 3, null, 0, 0, checkedOut);
            }
            return checkedOut;
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
            return -1L;
        }
    }

    public long update(String path, Revision revision, boolean recurse) throws ClientException {
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            String wsPath = SVNUtil.getWorkspacePath(ws, path);
            SVNRepository repository = SVNUtil.createRepository(ws, wsPath);
            long revNumber = SVNClient.getRevisionNumber(revision, repository, ws, wsPath);
            ws.addWorkspaceListener(new UpdateWorkspaceListener(this.myNotify, ws));
            long updatedRev = ws.update(wsPath, revNumber, recurse);
            if (updatedRev >= 0L && this.myNotify != null) {
                this.myNotify.onNotify(path, 11, 3, null, 0, 0, updatedRev);
            }
            return updatedRev;
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
            return -1L;
        }
    }

    public long commit(String[] path, final String message, boolean recurse) throws ClientException {
        if (path == null || path.length == 0) {
            return -1L;
        }
        try {
            int i;
            String commonRoot = PathUtil.getFSCommonRoot(path);
            final ISVNWorkspace ws = this.createWorkspace(commonRoot);
            DebugLog.log("COMMIT: workspace created for: " + ws.getID());
            String[] paths = new String[path.length];
            for (i = 0; i < path.length; ++i) {
                paths[i] = SVNUtil.getWorkspacePath(ws, path[i]);
            }
            for (i = 0; i < paths.length; ++i) {
                DebugLog.log("COMMIT: commiting path: " + paths[i]);
            }
            ws.addWorkspaceListener(new CommitWorkspaceListener(this.myNotify, ws));
            return ws.commit(paths, new ISVNCommitHandler(){

                public String handleCommit(SVNStatus[] tobeCommited) {
                    if (SVNClient.this.myMessageHandler != null) {
                        CommitItem[] items = new CommitItem[tobeCommited.length];
                        for (int i = 0; i < items.length; ++i) {
                            SVNStatus status = tobeCommited[i];
                            String fullPath = SVNUtil.getAbsolutePath(ws, status.getPath());
                            int nodeKind = status.isDirectory() ? 2 : 1;
                            int stateFlag = 0;
                            if (status.getContentsStatus() == 3) {
                                stateFlag += 2;
                            } else if (status.getContentsStatus() == 1) {
                                ++stateFlag;
                            } else if (status.getContentsStatus() == 6) {
                                stateFlag += 4;
                            }
                            if (status.getPropertiesStatus() == 6) {
                                stateFlag += 8;
                            }
                            String copiedURL = null;
                            Map properties = Collections.EMPTY_MAP;
                            try {
                                properties = ws.getProperties(status.getPath(), false, true);
                            }
                            catch (SVNException e) {
                                // empty catch block
                            }
                            if (status.isAddedWithHistory()) {
                                stateFlag += 16;
                                copiedURL = (String)properties.get("svn:entry:copyfrom-url");
                            }
                            long revision = SVNProperty.longValue((String)properties.get("svn:entry:revision"));
                            items[i] = new CommitItem(fullPath, nodeKind, stateFlag, (String)properties.get("svn:entry:url"), copiedURL, revision);
                        }
                        return SVNClient.this.myMessageHandler.getLogMessage(items);
                    }
                    return message;
                }
            }, recurse, true);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
            return -1L;
        }
    }

    public long doExport(String srcPath, String destPath, Revision revision, boolean force) throws ClientException {
        File dir = new File(destPath);
        if (force) {
            FSUtil.deleteAll(dir);
        }
        dir.mkdirs();
        try {
            ISVNWorkspace ws = SVNWorkspaceManager.createWorkspace("file", dir.getAbsolutePath());
            SVNRepositoryLocation location = SVNRepositoryLocation.parseURL(srcPath);
            SVNRepository repository = SVNRepositoryFactory.create(location);
            if (this.myPrompt != null) {
                ws.setCredentials(new SVNPromptCredentialsProvider(this.myPrompt, this.myUserName, this.myPassword));
                repository.setCredentialsProvider(new SVNPromptCredentialsProvider(this.myPrompt, this.myUserName, this.myPassword));
            } else if (this.myUserName != null && this.myPassword != null) {
                ws.setCredentials(new SVNSimpleCredentialsProvider(this.myUserName, this.myPassword));
                repository.setCredentialsProvider(new SVNSimpleCredentialsProvider(this.myUserName, this.myPassword));
            }
            long revNumber = SVNClient.getRevisionNumber(revision, repository, null, null);
            ws.addWorkspaceListener(new UpdateWorkspaceListener(this.myNotify, ws));
            return ws.checkout(location, revNumber, true);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
            return -1L;
        }
    }

    public long doSwitch(String path, String url, Revision revision, boolean recurse) throws ClientException {
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            String relativePath = SVNUtil.getWorkspacePath(ws, path);
            long revNumber = SVNClient.getRevisionNumber(revision, SVNUtil.createRepository(ws, relativePath), ws, relativePath);
            ws.addWorkspaceListener(new UpdateWorkspaceListener(this.myNotify, ws));
            long switchedRev = ws.update(SVNRepositoryLocation.parseURL(url), relativePath, revNumber, recurse);
            if (switchedRev >= 0L && this.myNotify != null) {
                this.myNotify.onNotify(path, 11, 3, null, 0, 0, switchedRev);
            }
            return switchedRev;
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
            return -1L;
        }
    }

    public void doImport(String path, String url, String message, boolean recurse) throws ClientException {
        if (!recurse) {
            throw new ClientException("non-recursice import is not supported", "", 0);
        }
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            String wsPath = SVNUtil.getWorkspacePath(ws, path);
            if (wsPath.trim().length() == 0) {
                wsPath = null;
            } else {
                url = PathUtil.removeTail(url);
            }
            ws.addWorkspaceListener(new CommitWorkspaceListener(this.myNotify, ws));
            ws.commit(SVNRepositoryLocation.parseURL(url), wsPath, message);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public void notification(Notify notify) {
        this.myNotify = notify;
    }

    public void commitMessageHandler(CommitMessage messageHandler) {
        this.myMessageHandler = messageHandler;
    }

    public void remove(String[] path, String message, boolean force) throws ClientException {
        if (path == null || path.length == 0) {
            return;
        }
        if (SVNClient.isURL(path[0])) {
            String rootURL = PathUtil.getCommonRoot(path);
            if (!SVNClient.isURL(rootURL)) {
                SVNClient.throwException(new SVNException("all locations should be within the same repository"));
            }
            try {
                SVNRepository repository = this.createRepository(rootURL);
                ISVNEditor editor = repository.getCommitEditor(message, null);
                editor.openRoot(-1L);
                for (int i = 0; i < path.length; ++i) {
                    String subPath = path[i].substring(rootURL.length());
                    subPath = PathUtil.removeLeadingSlash(subPath);
                    editor.deleteEntry(PathUtil.decode(subPath), -1L);
                }
                editor.closeEdit();
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        } else {
            for (int i = 0; i < path.length; ++i) {
                if (SVNClient.isURL(path[i])) {
                    SVNClient.throwException(new SVNException("remove method doesn't accept remote locations mixed with WC path"));
                }
                try {
                    path[i] = path[i].replace(File.separatorChar, '/');
                    String parentPath = PathUtil.removeTail(path[i]);
                    ISVNWorkspace ws = this.createWorkspace(parentPath);
                    ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
                    ws.delete(SVNUtil.getWorkspacePath(ws, path[i]), force);
                    continue;
                }
                catch (SVNException e) {
                    SVNClient.throwException(e);
                }
            }
        }
    }

    public void revert(String path, boolean recurse) throws ClientException {
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
            ws.revert(SVNUtil.getWorkspacePath(ws, path), recurse);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public void add(String path, boolean recurse) throws ClientException {
        try {
            path = path.replace(File.separatorChar, '/');
            ISVNWorkspace ws = this.createWorkspace(PathUtil.removeTail(path));
            path = SVNUtil.getWorkspacePath(ws, path);
            ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
            ws.add(path, false, recurse);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public void copy(String srcPath, String destPath, String message, Revision revision) throws ClientException {
        if (SVNClient.isURL(srcPath) && SVNClient.isURL(destPath)) {
            ISVNEditor editor = null;
            String srcURL = srcPath;
            String dstURL = destPath;
            try {
                String newPath = PathUtil.tail(destPath);
                newPath = PathUtil.removeLeadingSlash(newPath);
                newPath = PathUtil.decode(newPath);
                String root = PathUtil.removeTail(destPath);
                SVNRepository repository = this.createRepository(root);
                long revNumber = SVNClient.getRevisionNumber(revision, repository, null, null);
                SVNRepositoryLocation srcLocation = SVNRepositoryLocation.parseURL(srcPath);
                srcPath = srcLocation.getPath();
                srcPath = PathUtil.decode(srcPath);
                if (repository.getRepositoryRoot() == null) {
                    repository.testConnection();
                }
                if (!(srcPath = srcPath.substring(repository.getRepositoryRoot().length())).startsWith("/")) {
                    srcPath = "/".concat(srcPath);
                }
                SVNNodeKind nodeKind = repository.checkPath(newPath, -1L);
                SVNNodeKind srcNodeKind = repository.checkPath(srcPath, revNumber);
                String newPathParent = null;
                if (nodeKind == SVNNodeKind.DIR) {
                    DebugLog.log("path " + newPath + " already exists and its a dir");
                    newPathParent = newPath;
                    newPath = PathUtil.tail(srcURL);
                    newPath = PathUtil.append(newPathParent, newPath);
                    nodeKind = repository.checkPath(newPath, -1L);
                    if (nodeKind == SVNNodeKind.DIR) {
                        SVNClient.throwException(new SVNException("can't copy to '" + PathUtil.append(dstURL, newPath) + "', location already exists"));
                    }
                }
                editor = repository.getCommitEditor(message, null);
                editor.openRoot(-1L);
                if (newPathParent != null) {
                    editor.openDir(newPathParent, -1L);
                }
                if (srcNodeKind == SVNNodeKind.DIR) {
                    editor.addDir(newPath, srcPath, revNumber);
                    editor.closeDir();
                } else {
                    DebugLog.log("adding file " + srcPath);
                    editor.addFile(newPath, srcPath, revNumber);
                    editor.closeFile(null);
                }
                if (newPathParent != null) {
                    editor.closeDir();
                }
                editor.closeDir();
                editor.closeEdit();
            }
            catch (SVNException e) {
                if (editor != null) {
                    try {
                        editor.abortEdit();
                    }
                    catch (SVNException es) {
                        // empty catch block
                    }
                }
                SVNClient.throwException(e);
            }
        } else if (!SVNClient.isURL(srcPath) && !SVNClient.isURL(destPath)) {
            try {
                String wsRoot = PathUtil.getFSCommonRoot(new String[]{srcPath, destPath});
                ISVNWorkspace ws = this.createWorkspace(wsRoot);
                SVNRepository repository = this.createRepository(ws.getLocation(srcPath).toCanonicalForm());
                long srcRevision = SVNClient.getRevisionNumber(revision, repository, ws, srcPath);
                if (srcRevision >= 0L && srcRevision != SVNProperty.longValue(ws.getPropertyValue(srcPath, "svn:entry:revision"))) {
                    this.copy(ws.getLocation(srcPath).toCanonicalForm(), destPath, message, revision);
                    return;
                }
                ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
                ws.copy(SVNUtil.getWorkspacePath(ws, srcPath), SVNUtil.getWorkspacePath(ws, destPath), false);
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        } else if (SVNClient.isURL(srcPath) && !SVNClient.isURL(destPath)) {
            try {
                SVNRepository repository = this.createRepository(srcPath);
                long revNumber = SVNClient.getRevisionNumber(revision, repository, null, null);
                destPath = destPath.replace(File.separatorChar, '/');
                ISVNWorkspace ws = this.createWorkspace(PathUtil.removeTail(destPath));
                ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
                ws.copy(SVNRepositoryLocation.parseURL(srcPath), SVNUtil.getWorkspacePath(ws, destPath), revNumber);
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        } else {
            try {
                srcPath = srcPath.replace(File.separatorChar, '/');
                ISVNWorkspace ws = this.createWorkspace(srcPath, true);
                ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
                ws.copy(SVNUtil.getWorkspacePath(ws, srcPath), SVNRepositoryLocation.parseURL(destPath), message);
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        }
    }

    public void move(String srcPath, String destPath, String message, Revision revision, boolean force) throws ClientException {
        if (SVNClient.isURL(srcPath) && SVNClient.isURL(destPath)) {
            ISVNEditor editor = null;
            try {
                String root = PathUtil.getCommonRoot(new String[]{destPath, srcPath});
                SVNRepository repository = this.createRepository(root);
                DebugLog.log("repository created: " + repository.getLocation());
                long revNumber = SVNClient.getRevisionNumber(revision, repository, null, null);
                String deletePath = srcPath.substring(root.length());
                destPath = destPath.substring(root.length());
                deletePath = PathUtil.removeLeadingSlash(deletePath);
                destPath = PathUtil.removeLeadingSlash(destPath);
                deletePath = PathUtil.decode(deletePath);
                destPath = PathUtil.decode(destPath);
                DebugLog.log("MOVE: dst path: " + destPath);
                DebugLog.log("MOVE: src path: " + deletePath);
                SVNNodeKind srcNodeKind = repository.checkPath(deletePath, revNumber);
                SVNNodeKind dstNodeKind = repository.checkPath(destPath, revNumber);
                LinkedList<String> parentDstDirs = new LinkedList<String>();
                StringTokenizer tokens = new StringTokenizer(destPath, "/");
                while (tokens.hasMoreTokens()) {
                    parentDstDirs.add(tokens.nextToken());
                }
                if (dstNodeKind == SVNNodeKind.NONE) {
                    parentDstDirs.remove(parentDstDirs.size() - 1);
                } else if (dstNodeKind == SVNNodeKind.DIR) {
                    destPath = PathUtil.append(destPath, PathUtil.tail(srcPath));
                    destPath = PathUtil.removeLeadingSlash(destPath);
                } else if (dstNodeKind == SVNNodeKind.FILE) {
                    SVNClient.throwException(new SVNException("destination already exists and its a file"));
                }
                editor = repository.getCommitEditor(message, null);
                editor.openRoot(-1L);
                String dir = "";
                Iterator dirs = parentDstDirs.iterator();
                while (dirs.hasNext()) {
                    dir = PathUtil.append(dir, (String)dirs.next());
                    dir = PathUtil.removeLeadingSlash(dir);
                    DebugLog.log("MOVE: open dir: " + dir);
                    editor.openDir(dir, -1L);
                }
                if (srcNodeKind == SVNNodeKind.DIR) {
                    DebugLog.log("MOVE: add dir: " + destPath + " : " + deletePath);
                    editor.addDir(destPath, deletePath, revNumber);
                    editor.closeDir();
                } else {
                    DebugLog.log("MOVE: add file: " + destPath + " : " + deletePath);
                    editor.addFile(destPath, deletePath, revNumber);
                    editor.closeFile(null);
                }
                dirs = parentDstDirs.iterator();
                while (dirs.hasNext()) {
                    dirs.next();
                    editor.closeDir();
                }
                DebugLog.log("COPY: delete: " + deletePath);
                editor.deleteEntry(deletePath, revNumber);
                editor.closeDir();
                editor.closeEdit();
            }
            catch (SVNException e) {
                if (editor != null) {
                    try {
                        editor.abortEdit();
                    }
                    catch (SVNException es) {
                        // empty catch block
                    }
                }
                SVNClient.throwException(e);
            }
        } else if (!SVNClient.isURL(srcPath) && !SVNClient.isURL(destPath)) {
            try {
                String wsRoot = PathUtil.getFSCommonRoot(new String[]{srcPath, destPath});
                ISVNWorkspace ws = this.createWorkspace(wsRoot);
                ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
                ws.copy(SVNUtil.getWorkspacePath(ws, srcPath), SVNUtil.getWorkspacePath(ws, destPath), true);
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        } else {
            throw new ClientException("only WC->WC or URL->URL move is supported", "", 0);
        }
    }

    public void mkdir(String[] path, String message) throws ClientException {
        if (path == null || path.length == 0) {
            return;
        }
        if (SVNClient.isURL(path[0])) {
            String root = PathUtil.getCommonRoot(path);
            for (int i = 0; i < path.length; ++i) {
                String dir = path[i].substring(root.length());
                path[i] = dir = PathUtil.removeLeadingSlash(dir);
            }
            Arrays.sort(path);
            ISVNEditor editor = null;
            try {
                SVNRepository repository = this.createRepository(root);
                editor = repository.getCommitEditor(message, null);
                editor.openRoot(-1L);
                for (int i = 0; i < path.length; ++i) {
                    int count = 0;
                    if (path[i] == null) continue;
                    String currentPath = "";
                    StringTokenizer tokens = new StringTokenizer(path[i], "/");
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        currentPath = PathUtil.append(currentPath, token);
                        if (tokens.hasMoreTokens()) {
                            editor.openDir(PathUtil.decode(currentPath), -1L);
                        } else {
                            editor.addDir(PathUtil.decode(currentPath), null, -1L);
                        }
                        ++count;
                    }
                    for (int j = 0; j < count; ++j) {
                        editor.closeDir();
                    }
                }
                editor.closeDir();
                editor.closeEdit();
            }
            catch (SVNException e) {
                e.printStackTrace();
                if (editor != null) {
                    try {
                        editor.abortEdit();
                    }
                    catch (SVNException inner) {
                        // empty catch block
                    }
                }
                SVNClient.throwException(e);
            }
        } else {
            try {
                String root = PathUtil.getFSCommonRoot(path);
                ISVNWorkspace ws = this.createWorkspace(root);
                ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
                for (int i = 0; i < path.length; ++i) {
                    ws.add(SVNUtil.getWorkspacePath(ws, path[i]), true, false);
                }
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        }
    }

    public void cleanup(String path) throws ClientException {
        DebugLog.log("SVNClient.cleanup is not yet implemented");
    }

    public void resolved(String path, boolean recurse) throws ClientException {
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            ws.addWorkspaceListener(new LocalWorkspaceListener(this.myNotify, ws));
            ws.markResolved(SVNUtil.getWorkspacePath(ws, path), recurse);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse) throws ClientException {
        SVNClient.notImplementedYet();
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse) throws ClientException {
        try {
            if (new File(target1).isDirectory()) {
                FileWriter outWriter = new FileWriter(new File(outFileName));
                ISVNWorkspace ws = this.createWorkspace(target1);
                DiffHandler handler = new DiffHandler(ws, revision1, revision2, outWriter);
                ws.status(SVNUtil.getWorkspacePath(ws, target1), false, handler, true, false, false, false, false);
                outWriter.close();
            } else {
                ISVNWorkspace ws = this.createWorkspace(target1);
                String wsPath = target1;
                if (ws != null) {
                    wsPath = SVNUtil.getWorkspacePath(ws, target1);
                }
                FileWriter outWriter = new FileWriter(new File(outFileName));
                this.diff(wsPath, target1, revision1, revision2, outWriter);
                outWriter.close();
            }
        }
        catch (SVNException se) {
            SVNClient.throwException(se);
        }
        catch (IOException ioe) {
            throw new ClientException(ioe.getMessage(), "", 0);
        }
    }

    private void diff(String wsPath, String path, Revision revision1, Revision revision2, Writer outWriter) throws ClientException {
        byte[] byteArray1 = this.fileContent(path, revision1, "LF", true);
        byte[] byteArray2 = this.fileContent(path, revision2, "LF", true);
        ByteArrayInputStream is1 = new ByteArrayInputStream(byteArray1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(byteArray2);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("compareEOL", Boolean.TRUE.toString());
        properties.put("whitespace", Boolean.FALSE.toString());
        properties.put("eol", System.getProperty("line.separator"));
        String encoding = System.getProperty("file.encoding", "US-ASCII");
        try {
            ISVNDiffGenerator diff;
            String targetPath;
            ISVNWorkspace ws = this.createWorkspace(path);
            ISVNWorkspace root = ws.getRootWorkspace(true, true);
            String osTargetPath = targetPath = SVNUtil.getWorkspacePath(root, path);
            if (FSUtil.isWindows) {
                osTargetPath = targetPath.replace('/', File.separatorChar);
            }
            if ((diff = SVNDiffManager.getDiffGenerator("unified", properties)) == null) {
                SVNClient.throwException(new SVNException("no suitable diff generator found"));
                return;
            }
            outWriter.write("Index: " + wsPath);
            outWriter.write(System.getProperty("line.separator", "\n"));
            outWriter.write("===================================================================");
            outWriter.write(System.getProperty("line.separator", "\n"));
            String rev1Str = revision1.toString();
            rev1Str = revision1 == Revision.WORKING ? "working copy" : "revision " + SVNClient.getRevisionNumber(revision1, null, root, targetPath);
            String rev2Str = revision1.toString();
            rev2Str = revision2 == Revision.WORKING ? "working copy" : "revision " + SVNClient.getRevisionNumber(revision2, null, root, targetPath);
            diff.generateDiffHeader(osTargetPath, "(" + rev1Str + ")", "(" + rev2Str + ")", outWriter);
            String mimeType = ws.getPropertyValue(targetPath, "svn:mime-type");
            if (mimeType != null && !mimeType.startsWith("text")) {
                diff.generateBinaryDiff(is1, is2, encoding, outWriter);
            } else {
                DebugLog.log("generating text diff");
                diff.generateTextDiff(is1, is2, encoding, outWriter);
            }
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
        catch (IOException ioe) {
            throw new ClientException(ioe.getMessage(), "", 0);
        }
    }

    public PropertyData[] properties(String path) throws ClientException {
        Map properties = null;
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            properties = ws.getProperties(SVNUtil.getWorkspacePath(ws, path), true, false);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
        if (properties == null) {
            return new PropertyData[0];
        }
        LinkedList<PropertyData> result = new LinkedList<PropertyData>();
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String value;
            String name;
            result.add(new PropertyData(this, path, name, value, (value = (String)properties.get(name = (String)names.next())) != null ? value.getBytes() : null));
        }
        return result.toArray(new PropertyData[result.size()]);
    }

    public PropertyData propertyGet(String path, String name) throws ClientException {
        String value = null;
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            value = ws.getPropertyValue(SVNUtil.getWorkspacePath(ws, path), name);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
        if (value == null) {
            return null;
        }
        return new PropertyData(this, path, name, value, value.getBytes());
    }

    public void propertySet(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertySet(path, name, new String(value), recurse);
    }

    public void propertySet(String path, String name, String value, boolean recurse) throws ClientException {
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            ws.setPropertyValue(SVNUtil.getWorkspacePath(ws, path), name, value, recurse);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public void propertyRemove(String path, String name, boolean recurse) throws ClientException {
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            ws.setPropertyValue(SVNUtil.getWorkspacePath(ws, path), name, null, recurse);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public void propertyCreate(String path, String name, String value, boolean recurse) throws ClientException {
        if (value == null) {
            value = "";
        }
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            ws.setPropertyValue(SVNUtil.getWorkspacePath(ws, path), name, value, recurse);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public void propertyCreate(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value == null ? null : new String(value), recurse);
    }

    public PropertyData revProperty(String path, String name, Revision rev) throws ClientException {
        String value = null;
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            String wsPath = SVNUtil.getWorkspacePath(ws, path);
            SVNRepository repos = SVNUtil.createRepository(ws, wsPath);
            long revNumber = SVNClient.getRevisionNumber(rev, repos, ws, wsPath);
            value = repos.getRevisionPropertyValue(revNumber, name);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
        if (value == null) {
            return null;
        }
        return new PropertyData(this, path, name, value, value.getBytes());
    }

    public byte[] fileContent(String path, Revision revision) throws ClientException {
        return this.fileContent(path, revision, null, false);
    }

    private byte[] fileContent(String path, Revision revision, String eol, boolean unexpandKeywords) throws ClientException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ISVNWorkspace ws = null;
        String wsPath = null;
        if (!SVNClient.isURL(path)) {
            try {
                ws = this.createWorkspace(path);
                wsPath = SVNUtil.getWorkspacePath(ws, path);
                ISVNEntryContent content = ws.getContent(wsPath);
                if (content == null || content.isDirectory()) {
                    throw new ClientException("Can't find file " + path, "", 0);
                }
                if (Revision.BASE.equals(revision)) {
                    content.asFile().getBaseFileContent(bos, eol);
                    return bos.toByteArray();
                }
                if (Revision.WORKING.equals(revision)) {
                    content.asFile().getWorkingCopyContent(bos, eol, unexpandKeywords);
                    return bos.toByteArray();
                }
                path = ws.getLocation(wsPath).toString();
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        }
        String repos = PathUtil.removeTail(path);
        try {
            SVNRepository repository = this.createRepository(repos);
            long revNumber = SVNClient.getRevisionNumber(revision, repository, ws, wsPath);
            path = PathUtil.tail(path);
            if (repository.checkPath(path, revNumber) != SVNNodeKind.FILE) {
                String fullPath = PathUtil.append(repository.getLocation().getPath(), path);
                if (!"/".equals(repository.getRepositoryRoot())) {
                    fullPath = fullPath.substring(PathUtil.removeTrailingSlash(repository.getRepositoryRoot()).length());
                }
                Collection logEntries = repository.log(new String[]{path}, null, -1L, revNumber, true, false);
                Iterator entries = logEntries.iterator();
                while (entries.hasNext()) {
                    SVNLogEntry entry = (SVNLogEntry)entries.next();
                    SVNLogEntryPath pathEntry = (SVNLogEntryPath)entry.getChangedPaths().get(fullPath);
                    if (pathEntry.getCopyPath() == null) continue;
                    fullPath = pathEntry.getCopyPath();
                }
                path = fullPath;
            }
            repository.getFile(path, revNumber, null, bos);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
        return bos.toByteArray();
    }

    public void relocate(String from, String to, String path, boolean recurse) throws ClientException {
        try {
            ISVNWorkspace ws = this.createWorkspace(path);
            ws.relocate(SVNRepositoryLocation.parseURL(to), SVNUtil.getWorkspacePath(ws, path), recurse);
        }
        catch (SVNException e) {
            SVNClient.throwException(e);
        }
    }

    public byte[] blame(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        final StringBuffer buffer = new StringBuffer();
        this.blame(path, revisionStart, revisionEnd, new BlameCallback(){

            public void singleLine(Date changed, long revision, String author, String line) {
                buffer.append(revision);
                buffer.append(" ");
                buffer.append(author);
                buffer.append(" ");
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
        });
        return buffer.toString().getBytes();
    }

    public void blame(String path, Revision revisionStart, Revision revisionEnd, final BlameCallback callback) throws ClientException {
        SVNRepository repository = null;
        String name = null;
        ISVNWorkspace ws = null;
        if (SVNClient.isURL(path)) {
            String url = PathUtil.removeTail(path);
            name = PathUtil.tail(path);
            try {
                repository = this.createRepository(url);
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        } else {
            try {
                ws = this.createWorkspace(path);
                repository = SVNUtil.createRepository(ws, PathUtil.tail(path));
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        }
        if (repository != null && name != null) {
            try {
                long rev1 = SVNClient.getRevisionNumber(revisionStart, repository, ws, name);
                long rev2 = SVNClient.getRevisionNumber(revisionEnd, repository, ws, name);
                repository.annotate(name, rev1, rev2, new ISVNAnnotateHandler(){

                    public void handleLine(Date date, long revision, String author, String line) {
                        if (line.endsWith("\n")) {
                            line = line.substring(0, line.lastIndexOf("\n"));
                        } else if (line.endsWith("\r\n")) {
                            line = line.substring(0, line.lastIndexOf("\r\n"));
                        } else if (line.endsWith("\r")) {
                            line = line.substring(0, line.lastIndexOf("\r"));
                        }
                        callback.singleLine(date, revision, author, line);
                    }
                });
            }
            catch (SVNException e) {
                SVNClient.throwException(e);
            }
        }
    }

    public void setConfigDirectory(String configDir) throws ClientException {
        this.myConfigDir = configDir;
    }

    public String getConfigDirectory() throws ClientException {
        return this.myConfigDir;
    }

    public void cancelOperation() throws ClientException {
        DebugLog.log("SVNClient.cancelOperation is not yet implemented");
    }

    public String getLastPath() {
        return null;
    }

    public static void enableLogging(int logLevel, String logFilePath) {
    }

    private SVNRepository createRepository(String url) throws SVNException {
        SVNRepository repository = SVNRepositoryFactory.create(SVNRepositoryLocation.parseURL(url));
        if (this.myPrompt != null) {
            repository.setCredentialsProvider(new SVNPromptCredentialsProvider(this.myPrompt, this.myUserName, this.myPassword));
        } else if (this.myUserName != null && this.myPassword != null) {
            repository.setCredentialsProvider(new SVNSimpleCredentialsProvider(this.myUserName, this.myPassword));
        }
        return repository;
    }

    private ISVNWorkspace createWorkspace(String path) throws SVNException {
        File file = new File(path);
        if (!file.exists()) {
            path = file.getParentFile().getAbsolutePath();
        }
        return this.createWorkspace(path, false);
    }

    private ISVNWorkspace createWorkspace(String path, boolean root) throws SVNException {
        path = path.replace(File.separatorChar, '/');
        ISVNWorkspace ws = SVNUtil.createWorkspace(path, root);
        DebugLog.log("workspace created: " + path + " (schedule: " + ws.getPropertyValue("", "svn:entry:schedule") + ")");
        if (ws != null) {
            if (ws.getPropertyValue("", "svn:entry:schedule") != null) {
                ws = SVNUtil.createWorkspace(PathUtil.removeTail(path));
            }
            if (this.myUserName != null && this.myPassword != null) {
                ws.setCredentials(this.myUserName, this.myPassword);
            } else if (this.myPrompt != null) {
                ws.setCredentials(new SVNPromptCredentialsProvider(this.myPrompt, this.myUserName, this.myPassword));
            }
            ws.setExternalsHandler(new SVNClientExternalsHandler(this.myNotify));
        }
        return ws;
    }

    private static void notImplementedYet() throws ClientException {
        ClientException e = new ClientException("not implemented yet", "", 0);
        DebugLog.error(e);
        throw e;
    }

    private static void throwException(SVNException e) throws ClientException {
        ClientException ec = new ClientException(e.getMessage(), "", 0);
        DebugLog.error(ec);
        DebugLog.error(e);
        if (e.getErrors() != null) {
            for (int i = 0; i < e.getErrors().length; ++i) {
                DebugLog.log(e.getErrors()[i].getMessage());
            }
        }
        throw ec;
    }

    private static long getRevisionNumber(Revision revision, SVNRepository repository, ISVNWorkspace workspace, String path) throws SVNException {
        if (revision == null) {
            return -2L;
        }
        int kind = revision.getKind();
        if (kind == 1 && revision instanceof Revision.Number) {
            return ((Revision.Number)revision).getNumber();
        }
        if (kind == 7 && repository != null) {
            return repository.getLatestRevision();
        }
        if (kind == 2 && revision instanceof Revision.DateSpec && repository != null) {
            Date date = ((Revision.DateSpec)revision).getDate();
            return repository.getDatedRevision(date);
        }
        if ((kind == 3 || kind == 6 || kind == 4 || kind == 5) && workspace != null && path != null) {
            if (kind == 5 || kind == 6) {
                String revisionStr = workspace.getPropertyValue(path, "svn:entry:revision");
                if (revisionStr != null) {
                    return SVNProperty.longValue(revisionStr);
                }
            } else {
                String revisionStr = workspace.getPropertyValue(path, "svn:entry:committed-rev");
                if (revisionStr != null) {
                    long rev = SVNProperty.longValue(revisionStr);
                    if (kind == 4) {
                        --rev;
                    }
                    return rev;
                }
            }
        }
        return -2L;
    }

    private static DirEntry createDirEntry(String parentPath, SVNDirEntry svnDirEntry) {
        long lastChanged = svnDirEntry.getDate().getTime() * 1000L;
        long lastChangedRevision = svnDirEntry.getRevision();
        boolean hasProps = svnDirEntry.hasProperties();
        String lastAuthor = svnDirEntry.getAuthor();
        int nodeKind = 3;
        if (svnDirEntry.getKind() == SVNNodeKind.DIR) {
            nodeKind = 2;
        } else if (svnDirEntry.getKind() == SVNNodeKind.FILE) {
            nodeKind = 1;
        } else if (svnDirEntry.getKind() == SVNNodeKind.NONE) {
            nodeKind = 0;
        }
        long size = svnDirEntry.size();
        String path = PathUtil.append(parentPath, svnDirEntry.getName());
        path = PathUtil.removeLeadingSlash(path);
        DebugLog.log("DIR ENTRY CREATED: " + path + "(" + lastChangedRevision + ")");
        return new DirEntry(path, nodeKind, size, hasProps, lastChangedRevision, lastChanged, lastAuthor);
    }

    private static Status createStatus(String path, Map properties, SVNStatus status) {
        String url = (String)properties.get("svn:entry:url");
        int nodeKind = 3;
        nodeKind = status.isDirectory() ? 2 : 1;
        if (status.getContentsStatus() == 5) {
            nodeKind = 3;
        }
        long revision = SVNProperty.longValue((String)properties.get("svn:entry:revision"));
        long lastChangedRevision = SVNProperty.longValue((String)properties.get("svn:entry:committed-rev"));
        Date date = TimeUtil.parseDate((String)properties.get("svn:entry:committed-date"));
        long lastChangedDate = date != null ? date.getTime() * 1000L : 0L;
        String lastCommitAuthor = (String)properties.get("svn:entry:last-author");
        int textStatus = SVNClient.convertStatus(status.getContentsStatus());
        int propStatus = SVNClient.convertPropertiesStatus(status.getPropertiesStatus());
        int repositoryTextStatus = SVNClient.convertStatus(status.getRepositoryContentsStatus());
        int repositoryPropStatus = SVNClient.convertPropertiesStatus(status.getRepositoryPropertiesStatus());
        boolean locked = false;
        boolean copied = SVNProperty.booleanValue((String)properties.get("svn:entry:copied"));
        boolean switched = status.isSwitched();
        String conflictNew = (String)properties.get("svn:entry:conflict-new");
        String conflictOld = (String)properties.get("svn:entry:conflict-old");
        String conflictWorking = (String)properties.get("svn:entry:conflict-wrk");
        String urlCopiedFrom = (String)properties.get("svn:entry:copyfrom-url");
        long revisionCopiedFrom = SVNProperty.longValue((String)properties.get("svn:entry:copyfrom-rev"));
        Status st = new Status(path, url, nodeKind, revision, lastChangedRevision, lastChangedDate, lastCommitAuthor, textStatus, propStatus, repositoryTextStatus, repositoryPropStatus, locked, copied, conflictOld, conflictNew, conflictWorking, urlCopiedFrom, revisionCopiedFrom, switched);
        DebugLog.log(path + ": created status: " + st.getTextStatus() + ":" + st.getPropStatus() + ":" + st.getNodeKind());
        return st;
    }

    private static LogMessage createLogMessage(SVNLogEntry svnLogEntry) {
        String message = svnLogEntry.getMessage();
        Date date = svnLogEntry.getDate();
        long revision = svnLogEntry.getRevision();
        String author = svnLogEntry.getAuthor();
        Map paths = svnLogEntry.getChangedPaths();
        TreeSet<ChangePath> changedPaths = new TreeSet<ChangePath>(new Comparator(){

            public int compare(Object o1, Object o2) {
                ChangePath c1 = (ChangePath)o1;
                ChangePath c2 = (ChangePath)o2;
                if (c1 == null || c1.getPath() == null) {
                    return c2 == null || c2.getPath() == null ? 0 : -1;
                }
                if (c2 == null || c2.getPath() == null) {
                    return 1;
                }
                return c1.getPath().toLowerCase().compareTo(c2.getPath().toLowerCase());
            }
        });
        if (paths != null) {
            Iterator keys = paths.keySet().iterator();
            while (keys.hasNext()) {
                String path = (String)keys.next();
                SVNLogEntryPath svnPath = (SVNLogEntryPath)paths.get(path);
                changedPaths.add(SVNClient.createChangePath(svnPath));
            }
        }
        ChangePath[] changePaths = changedPaths.toArray(new ChangePath[changedPaths.size()]);
        return new LogMessage(message, date, revision, author, changePaths);
    }

    private static ChangePath createChangePath(SVNLogEntryPath svnPath) {
        String path = svnPath.getPath();
        long copySrcRevision = svnPath.getCopyRevision();
        String copySrcPath = svnPath.getCopyPath();
        char action = svnPath.getType();
        return new ChangePath(path, copySrcRevision, copySrcPath, action);
    }

    private static int convertStatus(int javaSvnStatus) {
        if (javaSvnStatus >= 0 && javaSvnStatus < STATUS_CONVERTION_TABLE.length) {
            return STATUS_CONVERTION_TABLE[javaSvnStatus];
        }
        return -1;
    }

    private static int convertPropertiesStatus(int javaSvnStatus) {
        if (javaSvnStatus >= 0 && javaSvnStatus < STATUS_CONVERTION_TABLE.length) {
            int status = STATUS_CONVERTION_TABLE[javaSvnStatus];
            if (status != 1 && status != 2 && status != 9) {
                status = 1;
            }
            return status;
        }
        return -1;
    }

    private static boolean isURL(String pathOrUrl) {
        return PathUtil.isURL(pathOrUrl);
    }

    static {
        SVNClient.STATUS_CONVERTION_TABLE[0] = 1;
        SVNClient.STATUS_CONVERTION_TABLE[1] = 3;
        SVNClient.STATUS_CONVERTION_TABLE[2] = 9;
        SVNClient.STATUS_CONVERTION_TABLE[3] = 4;
        SVNClient.STATUS_CONVERTION_TABLE[4] = 8;
        SVNClient.STATUS_CONVERTION_TABLE[5] = 11;
        SVNClient.STATUS_CONVERTION_TABLE[6] = 2;
        SVNClient.STATUS_CONVERTION_TABLE[7] = 7;
        SVNClient.STATUS_CONVERTION_TABLE[8] = 5;
        SVNClient.STATUS_CONVERTION_TABLE[9] = 6;
        SVNClient.STATUS_CONVERTION_TABLE[10] = 10;
        SVNClient.STATUS_CONVERTION_TABLE[18] = 13;
    }

    public static final class LogLevel
    implements SVNClientLogLevel {
    }

    private class DiffHandler
    implements ISVNStatusHandler {
        private Revision myRevision1;
        private Revision myRevision2;
        private Writer myWriter;
        private ISVNWorkspace myWorkspace;

        public DiffHandler(ISVNWorkspace ws, Revision revision1, Revision revision2, Writer outWriter) {
            this.myRevision1 = revision1;
            this.myRevision2 = revision2;
            this.myWriter = outWriter;
            this.myWorkspace = ws;
        }

        public void handleStatus(String path, SVNStatus status) {
            try {
                if (status.getContentsStatus() != 8) {
                    String absPath = SVNUtil.getAbsolutePath(this.myWorkspace, status.getPath());
                    if (status.isDirectory()) {
                        return;
                    }
                    SVNClient.this.diff(path, absPath, this.myRevision1, this.myRevision2, this.myWriter);
                }
            }
            catch (ClientException ce) {
                DebugLog.error(ce);
            }
        }
    }
}

