/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.Date;
import org.tigris.subversion.javahl.Revision;

public class DirEntry {
    private long lastChanged;
    private long lastChangedRevision;
    private boolean hasProps;
    private String lastAuthor;
    private int nodeKind;
    private long size;
    private String path;

    DirEntry(String path, int nodeKind, long size, boolean hasProps, long lastChangedRevision, long lastChanged, String lastAuthor) {
        this.path = path;
        this.nodeKind = nodeKind;
        this.size = size;
        this.hasProps = hasProps;
        this.lastChangedRevision = lastChangedRevision;
        this.lastChanged = lastChanged;
        this.lastAuthor = lastAuthor;
    }

    public String getPath() {
        return this.path;
    }

    public Date getLastChanged() {
        return new Date(this.lastChanged / 1000L);
    }

    public Revision.Number getLastChangedRevision() {
        if (this.lastChangedRevision < 0L) {
            return null;
        }
        return new Revision.Number(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public boolean getHasProps() {
        return this.hasProps;
    }

    public String getLastAuthor() {
        return this.lastAuthor;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public long getSize() {
        return this.size;
    }
}

