/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.media;

import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceCanceller;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.media.QSequenceCachableMedia;
import de.regnis.q.sequence.media.QSequenceCachableMediaLeftGetter;
import de.regnis.q.sequence.media.QSequenceCachableMediaRightGetter;
import de.regnis.q.sequence.media.QSequenceCachingMediaSymbolMap;
import de.regnis.q.sequence.media.QSequenceMediaComparer;

public class QSequenceCachingMedia
implements QSequenceMedia,
QSequenceMediaComparer {
    private final QSequenceCanceller canceller;
    private final QSequenceCachingMediaSymbolMap symbolMap;
    private final int[] leftSymbols;
    private final int[] rightSymbols;

    public QSequenceCachingMedia(QSequenceCachableMedia media, QSequenceCanceller canceller) {
        this.canceller = canceller;
        this.symbolMap = new QSequenceCachingMediaSymbolMap(media.getLeftLength() + media.getRightLength());
        this.leftSymbols = this.symbolMap.createSymbols(media, new QSequenceCachableMediaLeftGetter());
        this.rightSymbols = this.symbolMap.createSymbols(media, new QSequenceCachableMediaRightGetter());
    }

    public int getLeftLength() {
        return this.leftSymbols.length;
    }

    public int getRightLength() {
        return this.rightSymbols.length;
    }

    public boolean equals(int leftIndex, int rightIndex) throws QSequenceCancelledException {
        this.canceller.checkCancelled();
        return this.leftSymbols[leftIndex] == this.rightSymbols[rightIndex];
    }

    public boolean equalsLeft(int left1, int left2) throws QSequenceCancelledException {
        this.canceller.checkCancelled();
        return this.leftSymbols[left1] == this.leftSymbols[left2];
    }

    public boolean equalsRight(int right1, int right2) throws QSequenceCancelledException {
        this.canceller.checkCancelled();
        return this.rightSymbols[right1] == this.rightSymbols[right2];
    }

    public QSequenceCachingMediaSymbolMap getSymbolMap() {
        return this.symbolMap;
    }

    public int[] getLeftSymbols() {
        return this.leftSymbols;
    }

    public int[] getRightSymbols() {
        return this.rightSymbols;
    }
}

