/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceMedia;

class QSequenceRestrictedMedia
implements QSequenceMedia {
    private final QSequenceMedia media;
    private int leftMin;
    private int rightMin;
    private int leftMax;
    private int rightMax;

    public QSequenceRestrictedMedia(QSequenceMedia media) {
        this.media = media;
        this.restrictTo(1, media.getLeftLength(), 1, media.getRightLength());
    }

    public void restrictTo(int leftMin, int leftMax, int rightMin, int rightMax) {
        QSequenceAssert.assertTrue(0 <= leftMin && leftMin <= leftMax + 1);
        QSequenceAssert.assertTrue(leftMax <= this.media.getLeftLength());
        QSequenceAssert.assertTrue(0 <= rightMin && rightMin <= rightMax + 1);
        QSequenceAssert.assertTrue(rightMax <= this.media.getRightLength());
        this.leftMin = leftMin;
        this.leftMax = leftMax;
        this.rightMin = rightMin;
        this.rightMax = rightMax;
    }

    public int getLeftLength() {
        return this.leftMax - this.leftMin + 1;
    }

    public int getRightLength() {
        return this.rightMax - this.rightMin + 1;
    }

    public boolean equals(int leftIndex, int rightIndex) throws QSequenceCancelledException {
        QSequenceAssert.assertTrue(1 <= leftIndex && leftIndex <= this.leftMax - this.leftMin + 1);
        QSequenceAssert.assertTrue(1 <= rightIndex && rightIndex <= this.rightMax - this.rightMin + 1);
        return this.media.equals(this.leftMin + leftIndex - 2, this.rightMin + rightIndex - 2);
    }

    public int getLeftMin() {
        return this.leftMin;
    }

    public int getLeftMax() {
        return this.leftMax;
    }

    public int getRightMin() {
        return this.rightMin;
    }

    public int getRightMax() {
        return this.rightMax;
    }
}

