/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceDeePathBackwardExtender;
import de.regnis.q.sequence.core.QSequenceDeePathForwardExtender;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.core.QSequenceMiddleSnakeFinderResult;

class QSequenceMiddleSnakeFinder {
    private final QSequenceDeePathForwardExtender forwardDeePathExtender;
    private final QSequenceDeePathBackwardExtender backwardDeePathExtender;
    private final QSequenceMiddleSnakeFinderResult result;

    public QSequenceMiddleSnakeFinder(int maximumMediaLeftLength, int maximumMediaRightLength) {
        this.forwardDeePathExtender = new QSequenceDeePathForwardExtender(maximumMediaLeftLength, maximumMediaRightLength);
        this.backwardDeePathExtender = new QSequenceDeePathBackwardExtender(maximumMediaLeftLength, maximumMediaRightLength);
        this.result = new QSequenceMiddleSnakeFinderResult();
    }

    public QSequenceMiddleSnakeFinderResult getResult() {
        return this.result;
    }

    public int determineMiddleSnake(QSequenceMedia media) throws QSequenceCancelledException {
        this.result.reset();
        this.forwardDeePathExtender.reset(media);
        this.backwardDeePathExtender.reset(media);
        int delta = media.getLeftLength() - media.getRightLength();
        int deeMax = (int)Math.ceil(((double)media.getLeftLength() + (double)media.getRightLength()) / 2.0);
        for (int dee = 0; dee <= deeMax; ++dee) {
            int diagonal;
            int n = diagonal = delta >= 0 ? dee : -dee;
            while (delta >= 0 ? diagonal >= -dee : diagonal <= dee) {
                this.forwardDeePathExtender.extendDeePath(media, dee, diagonal);
                if (QSequenceMiddleSnakeFinder.checkForwardOverlapping(delta, diagonal, dee) && this.isForwardAndBackwardOverlapping(diagonal)) {
                    this.result.setMiddleSnake(this.forwardDeePathExtender, diagonal);
                    return 2 * dee - 1;
                }
                diagonal += delta >= 0 ? -2 : 2;
            }
            int n2 = diagonal = delta >= 0 ? -dee : dee;
            while (delta >= 0 ? diagonal <= dee : diagonal >= -dee) {
                this.backwardDeePathExtender.extendDeePath(media, dee, diagonal + delta);
                if (QSequenceMiddleSnakeFinder.checkBackwardOverlapping(delta, diagonal, dee) && this.isForwardAndBackwardOverlapping(diagonal + delta)) {
                    this.result.setMiddleSnake(this.backwardDeePathExtender, diagonal + delta);
                    return 2 * dee;
                }
                diagonal += delta >= 0 ? 2 : -2;
            }
        }
        QSequenceAssert.assertTrue(false);
        return 0;
    }

    private static boolean checkForwardOverlapping(int delta, int diagonal, int dee) {
        return diagonal >= delta - (dee - 1) && diagonal <= delta + (dee - 1);
    }

    private static boolean checkBackwardOverlapping(int delta, int diagonal, int dee) {
        return diagonal + delta >= -dee && diagonal + delta <= dee;
    }

    private boolean isForwardAndBackwardOverlapping(int diagonal) {
        int backwardLeft;
        int forwardLeft = this.forwardDeePathExtender.getLeft(diagonal);
        return forwardLeft >= (backwardLeft = this.backwardDeePathExtender.getLeft(diagonal));
    }
}

