/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceDeePathExtenderArray;
import de.regnis.q.sequence.core.QSequenceMedia;

abstract class QSequenceDeePathExtender {
    private final QSequenceDeePathExtenderArray xs;
    private int snakeStartLeft;
    private int snakeStartRight;
    private int startX;
    private int startY;
    private int endX;
    private int endY;

    protected abstract int getNextX(QSequenceDeePathExtenderArray var1, int var2, int var3);

    protected abstract int getSnakeX(QSequenceMedia var1, int var2, int var3) throws QSequenceCancelledException;

    protected abstract void reset(QSequenceMedia var1, QSequenceDeePathExtenderArray var2);

    protected QSequenceDeePathExtender(QSequenceDeePathExtenderArray xs) {
        this.xs = xs;
    }

    public final int getLeft(int diagonal) {
        return this.xs.get(diagonal);
    }

    public final int getRight(int diagonal) {
        return this.xs.get(diagonal) - diagonal;
    }

    public final int getStartX() {
        return this.startX;
    }

    public final int getStartY() {
        return this.startY;
    }

    public final int getSnakeStartLeft() {
        return this.snakeStartLeft;
    }

    public final int getSnakeStartRight() {
        return this.snakeStartRight;
    }

    public final void extendDeePath(QSequenceMedia media, int dee, int diagonal) throws QSequenceCancelledException {
        this.startX = this.endX;
        this.startY = this.endY;
        int x = this.getNextX(this.xs, diagonal, dee);
        int y = x - diagonal;
        this.snakeStartLeft = x;
        this.snakeStartRight = y;
        x = this.getSnakeX(media, x, y);
        y = x - diagonal;
        this.xs.set(diagonal, x);
        this.endX = x;
        this.endY = y;
    }

    public final void reset(QSequenceMedia media) {
        this.startX = -1;
        this.startY = -1;
        this.endX = -1;
        this.endY = -1;
        this.reset(media, this.xs);
    }
}

