/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.media.QSequenceMediaComparer;
import java.util.List;

public class QSequenceDifferenceBlockShifter {
    private final QSequenceMedia media;
    private final QSequenceMediaComparer comparer;

    public static void joinBlocks(List blocks) {
        QSequenceDifferenceBlock lastBlock = null;
        int index = 0;
        while (index < blocks.size()) {
            QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)blocks.get(index);
            if (lastBlock == null) {
                ++index;
                lastBlock = block;
                continue;
            }
            QSequenceAssert.assertTrue(lastBlock.getLeftTo() < block.getLeftFrom());
            QSequenceAssert.assertTrue(lastBlock.getRightTo() < block.getRightFrom());
            if (lastBlock.getLeftTo() + 1 != block.getLeftFrom()) {
                QSequenceAssert.assertTrue(lastBlock.getRightTo() != block.getRightFrom() + 1);
                lastBlock = block;
                ++index;
                continue;
            }
            if (lastBlock.getRightTo() + 1 != block.getRightFrom()) {
                QSequenceAssert.assertTrue(lastBlock.getLeftTo() != block.getLeftFrom() + 1);
                lastBlock = block;
                ++index;
                continue;
            }
            lastBlock.setLeftTo(block.getLeftTo());
            lastBlock.setRightTo(block.getRightTo());
            blocks.remove(index);
        }
    }

    public QSequenceDifferenceBlockShifter(QSequenceMedia media, QSequenceMediaComparer comparer) {
        QSequenceAssert.assertNotNull(media);
        QSequenceAssert.assertNotNull(comparer);
        this.media = media;
        this.comparer = comparer;
    }

    public void shiftBlocks(List blocks) throws QSequenceCancelledException {
        if (blocks.isEmpty()) {
            return;
        }
        QSequenceDifferenceBlockShifter.joinBlocks(blocks);
        int index = 0;
        while (index < blocks.size()) {
            if (this.tryShiftUp(blocks, index, true)) continue;
            ++index;
        }
        index = 0;
        while (index < blocks.size()) {
            if (this.tryShiftDown(blocks, index)) continue;
            ++index;
        }
    }

    public boolean tryShiftUp(List blocks, int blockIndex, boolean requireMerge) throws QSequenceCancelledException {
        int rightTo;
        if (blockIndex == 0) {
            return false;
        }
        QSequenceDifferenceBlock prevBlock = (QSequenceDifferenceBlock)blocks.get(blockIndex - 1);
        QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)blocks.get(blockIndex);
        int prevLeftTo = prevBlock.getLeftTo();
        int prevRightTo = prevBlock.getRightTo();
        int leftFrom = block.getLeftFrom();
        int leftTo = block.getLeftTo();
        int rightFrom = block.getRightFrom();
        QSequenceAssert.assertTrue(leftFrom > prevLeftTo);
        QSequenceAssert.assertTrue(rightFrom > prevRightTo);
        QSequenceAssert.assertTrue(leftFrom <= leftTo || rightFrom <= rightTo);
        if (leftFrom - prevLeftTo != rightFrom - prevRightTo) {
            return false;
        }
        for (rightTo = block.getRightTo(); leftFrom > prevLeftTo + 1 && (leftFrom > leftTo || this.comparer.equalsLeft(leftFrom - 1, leftTo)) && (rightFrom > rightTo || this.comparer.equalsRight(rightFrom - 1, rightTo)); --leftFrom, --leftTo, --rightFrom, --rightTo) {
        }
        if (leftFrom > prevLeftTo + 1) {
            if (requireMerge) {
                return false;
            }
            block.setLeftFrom(leftFrom);
            block.setLeftTo(leftTo);
            block.setRightFrom(rightFrom);
            block.setRightTo(rightTo);
        } else {
            prevBlock.setLeftTo(prevBlock.getLeftTo() + (leftTo - leftFrom + 1));
            prevBlock.setRightTo(prevBlock.getRightTo() + (rightTo - rightFrom + 1));
            blocks.remove(blockIndex);
        }
        return true;
    }

    public boolean tryShiftDown(List blocks, int blockIndex) throws QSequenceCancelledException {
        int rightTo;
        QSequenceDifferenceBlock nextBlock = blockIndex < blocks.size() - 1 ? (QSequenceDifferenceBlock)blocks.get(blockIndex + 1) : null;
        QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)blocks.get(blockIndex);
        int nextLeftFrom = nextBlock != null ? nextBlock.getLeftFrom() : this.media.getLeftLength();
        int nextRightFrom = nextBlock != null ? nextBlock.getRightFrom() : this.media.getRightLength();
        int leftFrom = block.getLeftFrom();
        int leftTo = block.getLeftTo();
        int rightFrom = block.getRightFrom();
        QSequenceAssert.assertTrue(leftTo < nextLeftFrom);
        QSequenceAssert.assertTrue(rightTo < nextRightFrom);
        QSequenceAssert.assertTrue(leftFrom <= leftTo || rightFrom <= rightTo);
        for (rightTo = block.getRightTo(); leftTo < nextLeftFrom - 1 && rightTo < nextRightFrom - 1 && (leftFrom > leftTo || this.comparer.equalsLeft(leftFrom, leftTo + 1)) && (rightFrom > rightTo || this.comparer.equalsRight(rightFrom, rightTo + 1)); ++leftFrom, ++leftTo, ++rightFrom, ++rightTo) {
        }
        if (nextBlock != null && leftTo == nextLeftFrom - 1 && rightTo == nextRightFrom - 1) {
            nextBlock.setLeftFrom(nextBlock.getLeftFrom() - (leftTo - leftFrom + 1));
            nextBlock.setRightFrom(nextBlock.getRightFrom() - (rightTo - rightFrom + 1));
            blocks.remove(blockIndex);
            return true;
        }
        block.setLeftFrom(leftFrom);
        block.setLeftTo(leftTo);
        block.setRightFrom(rightFrom);
        block.setRightTo(rightTo);
        return false;
    }
}

