/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SequencedHashMap
implements Map,
Cloneable,
Externalizable {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int ENTRY = 2;
    private static final int REMOVED_MASK = Integer.MIN_VALUE;
    private static final long serialVersionUID = 3380552487888102930L;
    private Entry sentinel = SequencedHashMap.createSentinel();
    private HashMap entries;

    private static final Entry createSentinel() {
        Entry entry;
        entry.prev = entry = new Entry(null, null);
        entry.next = entry;
        return entry;
    }

    private final void removeEntry(Entry entry) {
        entry.next.prev = entry.prev;
        entry.prev.next = entry.next;
    }

    private final void insertEntry(Entry entry) {
        entry.next = this.sentinel;
        entry.prev = this.sentinel.prev;
        this.sentinel.prev.next = entry;
        this.sentinel.prev = entry;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.sentinel.next == this.sentinel;
    }

    public boolean containsKey(Object object) {
        return this.entries.containsKey(object);
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.sentinel.next;
            while (entry != this.sentinel) {
                if (entry.getValue() == null) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.sentinel.next;
            while (entry != this.sentinel) {
                if (object.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.entries.get(object);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry getFirst() {
        return this.isEmpty() ? null : this.sentinel.next;
    }

    public Object getFirstKey() {
        return this.sentinel.next.getKey();
    }

    public Object getFirstValue() {
        return this.sentinel.next.getValue();
    }

    public Map.Entry getLast() {
        return this.isEmpty() ? null : this.sentinel.prev;
    }

    public Object getLastKey() {
        return this.sentinel.prev.getKey();
    }

    public Object getLastValue() {
        return this.sentinel.prev.getValue();
    }

    public Object put(Object object, Object object2) {
        Object object3 = null;
        Entry entry = (Entry)this.entries.get(object);
        if (entry != null) {
            this.removeEntry(entry);
            object3 = entry.setValue(object2);
        } else {
            entry = new Entry(object, object2);
            this.entries.put(object, entry);
        }
        this.insertEntry(entry);
        return object3;
    }

    public Object remove(Object object) {
        Entry entry = (Entry)this.entries.remove(object);
        if (entry == null) {
            return null;
        }
        this.removeEntry(entry);
        return entry.getValue();
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.entries.clear();
        this.sentinel.next = this.sentinel;
        this.sentinel.prev = this.sentinel;
    }

    public Set keySet() {
        return new AbstractSet(this){
            private final /* synthetic */ SequencedHashMap this$0;

            public final Iterator iterator() {
                SequencedHashMap sequencedHashMap = this.this$0;
                if (sequencedHashMap == null) {
                    throw null;
                }
                return sequencedHashMap.new OrderedIterator(0);
            }

            public final boolean remove(Object object) {
                return this.this$0.remove(object) != null;
            }

            public final void clear() {
                this.this$0.clear();
            }

            public final int size() {
                return this.this$0.size();
            }

            public final boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public final boolean contains(Object object) {
                return this.this$0.containsKey(object);
            }
            {
                this.this$0 = sequencedHashMap;
                this.constructor$0(sequencedHashMap);
            }

            private final void constructor$0(SequencedHashMap sequencedHashMap) {
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(this){
            private final /* synthetic */ SequencedHashMap this$0;

            public final Iterator iterator() {
                SequencedHashMap sequencedHashMap = this.this$0;
                if (sequencedHashMap == null) {
                    throw null;
                }
                return sequencedHashMap.new OrderedIterator(1);
            }

            public final boolean remove(Object object) {
                if (object == null) {
                    Entry entry = SequencedHashMap.access$0((SequencedHashMap)this.this$0).next;
                    while (entry != SequencedHashMap.access$0(this.this$0)) {
                        if (entry.getValue() == null) {
                            this.this$0.remove(entry.getKey());
                            return true;
                        }
                        entry = entry.next;
                    }
                } else {
                    Entry entry = SequencedHashMap.access$0((SequencedHashMap)this.this$0).next;
                    while (entry != SequencedHashMap.access$0(this.this$0)) {
                        if (object.equals(entry.getValue())) {
                            this.this$0.remove(entry.getKey());
                            return true;
                        }
                        entry = entry.next;
                    }
                }
                return false;
            }

            public final void clear() {
                this.this$0.clear();
            }

            public final int size() {
                return this.this$0.size();
            }

            public final boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public final boolean contains(Object object) {
                return this.this$0.containsValue(object);
            }
            {
                this.this$0 = sequencedHashMap;
                this.constructor$0(sequencedHashMap);
            }

            private final void constructor$0(SequencedHashMap sequencedHashMap) {
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(this){
            private final /* synthetic */ SequencedHashMap this$0;

            private final Entry findEntry(Object object) {
                if (object == null) {
                    return null;
                }
                if (!(object instanceof Map.Entry)) {
                    return null;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = (Entry)SequencedHashMap.access$3(this.this$0).get(entry.getKey());
                if (entry2 != null && entry2.equals(entry)) {
                    return entry2;
                }
                return null;
            }

            public final Iterator iterator() {
                SequencedHashMap sequencedHashMap = this.this$0;
                if (sequencedHashMap == null) {
                    throw null;
                }
                return sequencedHashMap.new OrderedIterator(2);
            }

            public final boolean remove(Object object) {
                Entry entry = this.findEntry(object);
                if (entry == null) {
                    return false;
                }
                return this.this$0.remove(entry.getKey()) != null;
            }

            public final void clear() {
                this.this$0.clear();
            }

            public final int size() {
                return this.this$0.size();
            }

            public final boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public final boolean contains(Object object) {
                return this.findEntry(object) != null;
            }
            {
                this.this$0 = sequencedHashMap;
                this.constructor$0(sequencedHashMap);
            }

            private final void constructor$0(SequencedHashMap sequencedHashMap) {
            }
        };
    }

    public Object clone() throws CloneNotSupportedException {
        SequencedHashMap sequencedHashMap = (SequencedHashMap)super.clone();
        sequencedHashMap.sentinel = SequencedHashMap.createSentinel();
        sequencedHashMap.entries = new HashMap();
        sequencedHashMap.putAll((Map)this);
        return sequencedHashMap;
    }

    private final Map.Entry getEntry(int n) {
        Entry entry = this.sentinel;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
        int n2 = -1;
        while (n2 < n - 1 && entry.next != this.sentinel) {
            ++n2;
            entry = entry.next;
        }
        if (entry.next == this.sentinel) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + (n2 + 1));
        }
        return entry.next;
    }

    public Object get(int n) {
        return this.getEntry(n).getKey();
    }

    public Object getValue(int n) {
        return this.getEntry(n).getValue();
    }

    public int indexOf(Object object) {
        Entry entry = (Entry)this.entries.get(object);
        int n = 0;
        while (entry.prev != this.sentinel) {
            ++n;
            entry = entry.prev;
        }
        return n;
    }

    public Iterator iterator() {
        return this.keySet().iterator();
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public List sequence() {
        ArrayList arrayList = new ArrayList(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Object remove(int n) {
        return this.remove(this.get(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size());
        Entry entry = this.sentinel.next;
        while (entry != this.sentinel) {
            objectOutput.writeObject(entry.getKey());
            objectOutput.writeObject(entry.getValue());
            entry = entry.next;
        }
    }

    static /* synthetic */ int access$1() {
        return KEY;
    }

    static /* synthetic */ int access$2() {
        return VALUE;
    }

    static /* synthetic */ HashMap access$3(SequencedHashMap sequencedHashMap) {
        return sequencedHashMap.entries;
    }

    static /* synthetic */ int access$4() {
        return ENTRY;
    }

    static /* synthetic */ int access$5() {
        return REMOVED_MASK;
    }

    public SequencedHashMap() {
        this.entries = new HashMap();
    }

    public SequencedHashMap(int n) {
        this.entries = new HashMap(n);
    }

    public SequencedHashMap(int n, float f) {
        this.entries = new HashMap(n, f);
    }

    public SequencedHashMap(Map map) {
        this();
        this.putAll(map);
    }

    private static class Entry
    implements Map.Entry {
        private final Object key;
        private Object value;
        Entry next = null;
        Entry prev = null;

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.getKey() == null) {
                if (entry.getKey() != null) {
                    return false;
                }
                bl = true;
            } else {
                bl = this.getKey().equals(entry.getKey());
            }
            if (!bl) return false;
            if (this.getValue() == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl2 = this.getValue().equals(entry.getValue());
            if (bl2) return true;
            return false;
        }

        public String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }

        public Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }

    private class OrderedIterator
    implements Iterator {
        private int returnType;
        private Entry pos;

        public boolean hasNext() {
            return this.pos.next != SequencedHashMap.this.sentinel;
        }

        public Object next() {
            if (this.pos.next == SequencedHashMap.this.sentinel) {
                throw new NoSuchElementException();
            }
            this.returnType &= Integer.MAX_VALUE;
            this.pos = this.pos.next;
            switch (this.returnType) {
                case 0: {
                    return this.pos.getKey();
                }
                case 1: {
                    return this.pos.getValue();
                }
                case 2: {
                    return this.pos;
                }
            }
            throw new Error("bad iterator type: " + this.returnType);
        }

        public void remove() {
            if ((this.returnType & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException("remove() must follow next()");
            }
            SequencedHashMap.this.remove(this.pos.getKey());
            this.returnType |= Integer.MIN_VALUE;
        }

        public OrderedIterator(int n) {
            this.pos = SequencedHashMap.this.sentinel;
            this.returnType = n | Integer.MIN_VALUE;
        }
    }
}

