/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastHashMap
extends HashMap {
    protected HashMap map = null;
    protected boolean fast = false;

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public void clear() {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                hashMap.clear();
                this.map = hashMap;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    public Object clone() {
        FastHashMap fastHashMap = null;
        if (this.fast) {
            fastHashMap = new FastHashMap((Map)this.map);
        } else {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                fastHashMap = new FastHashMap((Map)this.map);
            }
        }
        fastHashMap.setFast(this.getFast());
        return fastHashMap;
    }

    public boolean containsKey(Object object) {
        if (this.fast) {
            return this.map.containsKey(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsKey(object);
        }
    }

    public boolean containsValue(Object object) {
        if (this.fast) {
            return this.map.containsValue(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsValue(object);
        }
    }

    public Set entrySet() {
        if (this.fast) {
            return this.map.entrySet();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.entrySet();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
            return true;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    if (map.get(k) == null && map.containsKey(k)) continue;
                    return false;
                }
                if (v.equals(map.get(k))) continue;
                return false;
            }
            return true;
        }
    }

    public Object get(Object object) {
        if (this.fast) {
            return this.map.get(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.get(object);
        }
    }

    public int hashCode() {
        if (this.fast) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.isEmpty();
        }
    }

    public Set keySet() {
        if (this.fast) {
            return this.map.keySet();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.keySet();
        }
    }

    public Object put(Object object, Object object2) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object object3 = hashMap.put(object, object2);
                this.map = hashMap;
                return object3;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.put(object, object2);
        }
    }

    public void putAll(Map map) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                hashMap.putAll(map);
                this.map = hashMap;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.putAll(map);
        }
    }

    public Object remove(Object object) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object v = hashMap.remove(object);
                this.map = hashMap;
                return v;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.remove(object);
        }
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.size();
        }
    }

    public Collection values() {
        if (this.fast) {
            return this.map.values();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.values();
        }
    }

    public FastHashMap() {
        this.map = new HashMap();
    }

    public FastHashMap(int n) {
        this.map = new HashMap(n);
    }

    public FastHashMap(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public FastHashMap(Map map) {
        this.map = new HashMap(map);
    }
}

