/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    String name;
    List children;

    BasicMarker(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker child) {
        if (child == null) {
            throw new NullPointerException("Null children cannot be added to a Marker.");
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(child);
    }

    public synchronized boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public synchronized Iterator iterator() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Marker markerToRemove) {
        if (this.children == null) {
            return false;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            Marker m = (Marker)this.children.get(i);
            if (m == markerToRemove) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this == other) {
            return true;
        }
        if (this.hasChildren()) {
            int i = 0;
            while (i < this.children.size()) {
                Marker child = (Marker)this.children.get(i);
                if (child.contains(other)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

