/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.samples;

import java.io.IOException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.util.Traverser;

public class DeclarationCounter
extends Traverser {
    private int classDeclarationCount = 0;
    private int interfaceDeclarationCount = 0;
    private int fieldCount = 0;
    private int localVariableCount = 0;

    public static void main(String[] stringArray) throws Scanner.ScanException, IOException, Parser.ParseException {
        DeclarationCounter declarationCounter = new DeclarationCounter();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Java.CompilationUnit compilationUnit = new Parser(new Scanner(string)).parseCompilationUnit();
            declarationCounter.traverseCompilationUnit(compilationUnit);
            ++n;
        }
        System.out.println("Class declarations:     " + declarationCounter.classDeclarationCount);
        System.out.println("Interface declarations: " + declarationCounter.interfaceDeclarationCount);
        System.out.println("Fields:                 " + declarationCounter.fieldCount);
        System.out.println("Local variables:        " + declarationCounter.localVariableCount);
    }

    public void traverseClassDeclaration(Java.ClassDeclaration classDeclaration) {
        ++this.classDeclarationCount;
        super.traverseClassDeclaration(classDeclaration);
    }

    public void traverseFieldDeclaration(Java.FieldDeclaration fieldDeclaration) {
        this.fieldCount += fieldDeclaration.variableDeclarators.length;
        super.traverseFieldDeclaration(fieldDeclaration);
    }

    public void traverseInterfaceDeclaration(Java.InterfaceDeclaration interfaceDeclaration) {
        ++this.interfaceDeclarationCount;
        super.traverseInterfaceDeclaration(interfaceDeclaration);
    }

    public void traverseLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
        this.localVariableCount += localVariableDeclarationStatement.variableDeclarators.length;
        super.traverseLocalVariableDeclarationStatement(localVariableDeclarationStatement);
    }
}

