/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.janino.Access;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.util.ClassFile;

public class ClassFileIClass
extends IClass {
    private static final boolean DEBUG = false;
    private final ClassFile classFile;
    private final IClassLoader iClassLoader;
    private final short accessFlags;
    private final Map resolvedFields = new HashMap();
    private final Map resolvedClasses = new HashMap();
    private final Map resolvedMethods = new HashMap();

    public ClassFileIClass(ClassFile classFile, IClassLoader iClassLoader) {
        this.classFile = classFile;
        this.iClassLoader = iClassLoader;
        this.accessFlags = classFile.accessFlags;
    }

    protected IClass getComponentType2() {
        return null;
    }

    protected IClass[] getDeclaredIClasses2() throws CompileException {
        ClassFile.InnerClassesAttribute innerClassesAttribute = this.classFile.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            return new IClass[0];
        }
        List list = innerClassesAttribute.getEntries();
        ArrayList<IClass> arrayList = new ArrayList<IClass>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry entry = (ClassFile.InnerClassesAttribute.Entry)iterator.next();
            if (entry.outerClassInfoIndex != this.classFile.thisClass) continue;
            try {
                arrayList.add(this.resolveClass(entry.innerClassInfoIndex));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CompileException(classNotFoundException.getMessage(), null);
            }
        }
        return arrayList.toArray(new IClass[arrayList.size()]);
    }

    protected IClass.IConstructor[] getDeclaredIConstructors2() {
        ArrayList<IClass.IInvocable> arrayList = new ArrayList<IClass.IInvocable>();
        Iterator iterator = this.classFile.methodInfos.iterator();
        while (iterator.hasNext()) {
            IClass.IInvocable iInvocable;
            ClassFile.MethodInfo methodInfo = (ClassFile.MethodInfo)iterator.next();
            try {
                iInvocable = this.resolveMethod(methodInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            if (!(iInvocable instanceof IClass.IConstructor)) continue;
            arrayList.add(iInvocable);
        }
        return arrayList.toArray(new IClass.IConstructor[arrayList.size()]);
    }

    protected IClass.IField[] getDeclaredIFields2() {
        IClass.IField[] iFieldArray = new IClass.IField[this.classFile.fieldInfos.size()];
        int n = 0;
        while (n < this.classFile.fieldInfos.size()) {
            try {
                iFieldArray[n] = this.resolveField((ClassFile.FieldInfo)this.classFile.fieldInfos.get(n));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            ++n;
        }
        return iFieldArray;
    }

    protected IClass.IMethod[] getDeclaredIMethods2() {
        ArrayList<IClass.IInvocable> arrayList = new ArrayList<IClass.IInvocable>();
        Iterator iterator = this.classFile.methodInfos.iterator();
        while (iterator.hasNext()) {
            IClass.IInvocable iInvocable;
            ClassFile.MethodInfo methodInfo = (ClassFile.MethodInfo)iterator.next();
            if ((methodInfo.getAccessFlags() & 0x1000) != 0) continue;
            try {
                iInvocable = this.resolveMethod(methodInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            if (!(iInvocable instanceof IClass.IMethod)) continue;
            arrayList.add(iInvocable);
        }
        return arrayList.toArray(new IClass.IMethod[arrayList.size()]);
    }

    protected IClass getDeclaringIClass2() throws CompileException {
        ClassFile.InnerClassesAttribute innerClassesAttribute = this.classFile.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            return null;
        }
        List list = innerClassesAttribute.getEntries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry entry = (ClassFile.InnerClassesAttribute.Entry)iterator.next();
            if (entry.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (entry.outerClassInfoIndex == 0) {
                return null;
            }
            try {
                return this.resolveClass(entry.outerClassInfoIndex);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CompileException(classNotFoundException.getMessage(), null);
            }
        }
        return null;
    }

    protected String getDescriptor2() {
        return Descriptor.fromClassName(this.classFile.getThisClassName());
    }

    protected IClass[] getInterfaces2() throws CompileException {
        return this.resolveClasses(this.classFile.interfaces);
    }

    protected IClass getOuterIClass2() throws CompileException {
        ClassFile.InnerClassesAttribute innerClassesAttribute = this.classFile.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            return null;
        }
        List list = innerClassesAttribute.getEntries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry entry = (ClassFile.InnerClassesAttribute.Entry)iterator.next();
            if (entry.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (entry.outerClassInfoIndex == 0) {
                return null;
            }
            if ((entry.innerClassAccessFlags & 8) != 0) {
                return null;
            }
            try {
                return this.resolveClass(entry.outerClassInfoIndex);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CompileException(classNotFoundException.getMessage(), null);
            }
        }
        return null;
    }

    protected IClass getSuperclass2() throws CompileException {
        if (this.classFile.superclass == 0) {
            return null;
        }
        try {
            return this.resolveClass(this.classFile.superclass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CompileException(classNotFoundException.getMessage(), null);
        }
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveNumeric() {
        return false;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public void resolveAllClasses() throws ClassNotFoundException {
        short s = 0;
        while (s < this.classFile.constantPool.size()) {
            ClassFile.ConstantPoolInfo constantPoolInfo = this.classFile.getConstantPoolInfo(s);
            if (constantPoolInfo instanceof ClassFile.ConstantClassInfo) {
                this.resolveClass(s);
            } else if (constantPoolInfo instanceof ClassFile.ConstantNameAndTypeInfo) {
                short s2 = ((ClassFile.ConstantNameAndTypeInfo)constantPoolInfo).getDescriptorIndex();
                String string = this.classFile.getConstantUtf8(s2);
                if (string.charAt(0) == '(') {
                    MethodDescriptor methodDescriptor = new MethodDescriptor(string);
                    this.resolveClass(methodDescriptor.returnFD);
                    int n = 0;
                    while (n < methodDescriptor.parameterFDs.length) {
                        this.resolveClass(methodDescriptor.parameterFDs[n]);
                        ++n;
                    }
                } else {
                    this.resolveClass(string);
                }
            }
            s = (short)(s + 1);
        }
    }

    private IClass resolveClass(String string) throws ClassNotFoundException {
        IClass iClass = (IClass)this.resolvedClasses.get(string);
        if (iClass != null) {
            return iClass;
        }
        iClass = this.iClassLoader.loadIClass(string);
        if (iClass == null) {
            throw new ClassNotFoundException(string);
        }
        this.resolvedClasses.put(string, iClass);
        return iClass;
    }

    private IClass resolveClass(short s) throws ClassNotFoundException {
        return this.resolveClass(Descriptor.fromInternalForm(this.classFile.getConstantClassName(s)));
    }

    private IClass[] resolveClasses(short[] sArray) throws CompileException {
        IClass[] iClassArray = new IClass[sArray.length];
        int n = 0;
        while (n < iClassArray.length) {
            try {
                iClassArray[n] = this.resolveClass(sArray[n]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CompileException(classNotFoundException.getMessage(), null);
            }
            ++n;
        }
        return iClassArray;
    }

    private IClass.IField resolveField(final ClassFile.FieldInfo fieldInfo) throws ClassNotFoundException {
        Object object;
        Object object2;
        IClass.IField iField = (IClass.IField)this.resolvedFields.get(fieldInfo);
        if (iField != null) {
            return iField;
        }
        final String string = this.classFile.getConstantUtf8(fieldInfo.getNameIndex());
        String string2 = this.classFile.getConstantUtf8(fieldInfo.getDescriptorIndex());
        final IClass iClass = this.resolveClass(string2);
        ClassFile.ConstantValueAttribute constantValueAttribute = null;
        ClassFile.AttributeInfo[] attributeInfoArray = fieldInfo.getAttributes();
        int n = 0;
        while (n < attributeInfoArray.length) {
            object2 = attributeInfoArray[n];
            if (object2 instanceof ClassFile.ConstantValueAttribute) {
                constantValueAttribute = (ClassFile.ConstantValueAttribute)object2;
                break;
            }
            ++n;
        }
        object2 = null;
        if (constantValueAttribute != null) {
            object = this.classFile.getConstantPoolInfo(constantValueAttribute.getConstantValueIndex());
            if (object instanceof ClassFile.ConstantValuePoolInfo) {
                object2 = ((ClassFile.ConstantValuePoolInfo)object).getValue(this.classFile);
            } else {
                throw new RuntimeException("Unexpected constant pool info type \"" + object.getClass().getName() + "\"");
            }
        }
        object = object2;
        short s = fieldInfo.getAccessFlags();
        final Access access = (s & 1) != 0 ? Access.PUBLIC : ((s & 4) != 0 ? Access.PROTECTED : ((s & 2) != 0 ? Access.PRIVATE : Access.DEFAULT));
        iField = new IClass.IField(this){

            public Access getAccess() {
                return access;
            }

            public Object getConstantValue() throws CompileException {
                return object;
            }

            public String getName() {
                return string;
            }

            public IClass getType() throws CompileException {
                return iClass;
            }

            public boolean isStatic() {
                return (fieldInfo.getAccessFlags() & 8) != 0;
            }
        };
        this.resolvedFields.put(fieldInfo, iField);
        return iField;
    }

    public void resolveHalf() throws ClassNotFoundException {
        this.resolveClass(this.classFile.superclass);
        int n = 0;
        while (n < this.classFile.interfaces.length) {
            this.resolveClass(this.classFile.interfaces[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.classFile.methodInfos.size()) {
            this.resolveMethod((ClassFile.MethodInfo)this.classFile.methodInfos.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.classFile.fieldInfos.size()) {
            this.resolveField((ClassFile.FieldInfo)this.classFile.fieldInfos.get(n3));
            ++n3;
        }
    }

    private IClass.IInvocable resolveMethod(final ClassFile.MethodInfo methodInfo) throws ClassNotFoundException {
        Access access;
        Object object;
        IClass.IInvocable iInvocable = (IClass.IInvocable)this.resolvedMethods.get(methodInfo);
        if (iInvocable != null) {
            return iInvocable;
        }
        final String string = this.classFile.getConstantUtf8(methodInfo.getNameIndex());
        MethodDescriptor methodDescriptor = new MethodDescriptor(this.classFile.getConstantUtf8(methodInfo.getDescriptorIndex()));
        final IClass iClass = this.resolveClass(methodDescriptor.returnFD);
        final IClass[] iClassArray = new IClass[methodDescriptor.parameterFDs.length];
        int n = 0;
        while (n < iClassArray.length) {
            iClassArray[n] = this.resolveClass(methodDescriptor.parameterFDs[n]);
            ++n;
        }
        IClass[] iClassArray2 = null;
        ClassFile.AttributeInfo[] attributeInfoArray = methodInfo.getAttributes();
        int n2 = 0;
        while (n2 < attributeInfoArray.length) {
            object = attributeInfoArray[n2];
            if (object instanceof ClassFile.ExceptionsAttribute) {
                short[] sArray = ((ClassFile.ExceptionsAttribute)object).getExceptionIndexes();
                iClassArray2 = new IClass[sArray.length];
                int n3 = 0;
                while (n3 < sArray.length) {
                    iClassArray2[n3] = this.resolveClass(sArray[n3]);
                    ++n3;
                }
            }
            ++n2;
        }
        object = iClassArray2 == null ? new IClass[]{} : iClassArray2;
        short s = methodInfo.getAccessFlags();
        Access access2 = (s & 1) != 0 ? Access.PUBLIC : ((s & 4) != 0 ? Access.PROTECTED : (access = (s & 2) != 0 ? Access.PRIVATE : Access.DEFAULT));
        iInvocable = string.equals("<init>") ? new IClass.IConstructor((IClass[])object, this){
            private final /* synthetic */ IClass[] val$thrownExceptions;
            {
                this.val$thrownExceptions = iClassArray2;
            }

            public Access getAccess() {
                return access;
            }

            public IClass[] getParameterTypes() throws CompileException {
                IClass iClass = this.getOuterIClass();
                if (iClass != null) {
                    if (iClassArray.length < 1) {
                        throw new RuntimeException("Inner class constructor lacks magic first parameter");
                    }
                    if (iClassArray[0] != iClass) {
                        throw new RuntimeException("Magic first parameter of inner class constructor has type \"" + iClassArray[0].toString() + "\" instead of that of its enclosing instance (\"" + iClass.toString() + "\")");
                    }
                    IClass[] iClassArray2 = new IClass[iClassArray.length - 1];
                    System.arraycopy(iClassArray, 1, iClassArray2, 0, iClassArray2.length);
                    return iClassArray2;
                }
                return iClassArray;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                return this.val$thrownExceptions;
            }
        } : new IClass.IMethod((IClass[])object, this){
            private final /* synthetic */ IClass[] val$thrownExceptions;
            {
                this.val$thrownExceptions = iClassArray2;
            }

            public Access getAccess() {
                return access;
            }

            public String getName() {
                return string;
            }

            public IClass[] getParameterTypes() throws CompileException {
                return iClassArray;
            }

            public IClass getReturnType() throws CompileException {
                return iClass;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                return this.val$thrownExceptions;
            }

            public boolean isAbstract() {
                return (methodInfo.getAccessFlags() & 0x400) != 0;
            }

            public boolean isStatic() {
                return (methodInfo.getAccessFlags() & 8) != 0;
            }
        };
        this.resolvedMethods.put(methodInfo, iInvocable);
        return iInvocable;
    }
}

