/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.WrappedHandler;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.log.Log;

public class SessionHandler
extends WrappedHandler {
    SessionManager _sessionManager = new HashSessionManager();

    public SessionHandler() {
        this(new HashSessionManager());
    }

    public SessionHandler(SessionManager manager) {
        this._sessionManager = manager;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._sessionManager = sessionManager;
    }

    protected void doStart() throws Exception {
        this._sessionManager.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._sessionManager.stop();
    }

    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        boolean result = false;
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        SessionManager old_session_manager = null;
        HttpSession old_session = null;
        try {
            HttpSession session;
            String requested_session_id = request.getRequestedSessionId();
            if (requested_session_id == null) {
                String path_params;
                String uri;
                int semi;
                boolean requested_session_id_from_cookie = false;
                Cookie[] cookies = request.getCookies();
                if (cookies != null && cookies.length > 0) {
                    for (int i = 0; i < cookies.length; ++i) {
                        if (!SessionManager.__SessionCookie.equalsIgnoreCase(cookies[i].getName())) continue;
                        if (requested_session_id != null && this._sessionManager.getHttpSession(requested_session_id) != null) break;
                        requested_session_id = cookies[i].getValue();
                        requested_session_id_from_cookie = true;
                        if (!Log.isDebugEnabled()) continue;
                        Log.debug("Got Session ID " + requested_session_id + " from cookie");
                    }
                }
                if (requested_session_id == null && (semi = (uri = request.getRequestURI()).lastIndexOf(59)) >= 0 && (path_params = uri.substring(semi + 1)) != null && path_params.startsWith(SessionManager.__SessionURL)) {
                    requested_session_id = path_params.substring(SessionManager.__SessionURL.length() + 1);
                    if (Log.isDebugEnabled()) {
                        Log.debug("Got Session ID " + requested_session_id + " from URL");
                    }
                }
                base_request.setRequestedSessionId(requested_session_id);
                base_request.setRequestedSessionIdFromCookie(requested_session_id != null && requested_session_id_from_cookie);
            }
            old_session_manager = base_request.getSessionManager();
            old_session = base_request.getSession(false);
            if (old_session_manager != this._sessionManager) {
                base_request.setSessionManager(this._sessionManager);
                base_request.setSession(null);
            }
            if ((session = request.getSession(false)) != null) {
                ((SessionManager.Session)session).access();
            } else if (this._sessionManager != null && (session = base_request.recoverNewSession(this._sessionManager)) != null) {
                base_request.setSession(session);
            }
            if (Log.isDebugEnabled()) {
                Log.debug("sessionManager=" + base_request.getSessionManager());
                Log.debug("session=" + session);
            }
            result = this.getHandler().handle(target, request, response, dispatch);
        }
        catch (RetryRequest r) {
            try {
                HttpSession session = base_request.getSession(false);
                if (session != null && session.isNew()) {
                    base_request.saveNewSession(this._sessionManager, session);
                }
                throw r;
            }
            catch (Throwable throwable) {
                base_request.setSessionManager(old_session_manager);
                base_request.setSession(old_session);
                throw throwable;
            }
        }
        base_request.setSessionManager(old_session_manager);
        base_request.setSession(old_session);
        return result;
    }

    public void addEventListener(EventListener listener) {
        if (this._sessionManager != null) {
            this._sessionManager.addEventListener(listener);
        }
    }

    public void clearEventListeners() {
        if (this._sessionManager != null) {
            this._sessionManager.clearEventListeners();
        }
    }
}

