/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.HttpOnlyCookie;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    private static final HttpSessionContext __nullSessionContext = new NullSessionContext();
    public static final int __distantFuture = 628992000;
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    private int _dftMaxIdleSecs = -1;
    protected boolean _httpOnly = false;
    protected int _maxSessions = 0;
    protected int _minSessions = 0;
    protected transient Random _random;
    private int _scavengePeriodMs = 30000;
    private SessionManager.MetaManager _metaManager;
    private transient SessionScavenger _scavenger = null;
    protected boolean _secureCookies = false;
    protected transient Object _sessionAttributeListeners;
    protected transient Object _sessionListeners;
    protected transient Map _sessions;
    private boolean _usingCookies = true;
    private String _workerName;
    protected transient ClassLoader _loader;
    protected transient ContextHandler.Context _context;

    public AbstractSessionManager() {
        this(null);
    }

    public AbstractSessionManager(Random random) {
        this._random = random;
    }

    public void clearEventListeners() {
        this._sessionAttributeListeners = null;
        this._sessionListeners = null;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.add(this._sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.add(this._sessionListeners, listener);
        }
    }

    public SessionManager.MetaManager getMetaManager() {
        return this._metaManager;
    }

    public void setMetaManager(SessionManager.MetaManager metaManager) {
        this._metaManager = metaManager;
    }

    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getHttpSession(String id) {
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            return (HttpSession)this._sessions.get(id);
        }
    }

    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    public int getMaxSessions() {
        return this._maxSessions;
    }

    public int getMinSessions() {
        return this._minSessions;
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public Cookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            HttpOnlyCookie cookie = this.getHttpOnly() ? new HttpOnlyCookie(SessionManager.__SessionCookie, session.getId()) : new Cookie(SessionManager.__SessionCookie, session.getId());
            cookie.setPath(contextPath == null ? "/" : contextPath);
            cookie.setMaxAge(-1);
            cookie.setSecure(requestIsSecure && this.getSecureCookies());
            if (this._context != null) {
                String domain = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionDomain");
                String maxAge = this._context.getInitParameter("org.mortbay.jetty.servlet.MaxAge");
                String path = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionPath");
                if (path != null) {
                    cookie.setPath(path);
                }
                if (domain != null) {
                    cookie.setDomain(domain);
                }
                if (maxAge != null) {
                    cookie.setMaxAge(Integer.parseInt(maxAge));
                }
            }
            return cookie;
        }
        return null;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        SessionManager.MetaManager metaManager = this._metaManager;
        synchronized (metaManager) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._sessions.put(session.getId(), session);
                this._metaManager.addSession(session);
                if (this._sessions.size() > this._maxSessions) {
                    this._maxSessions = this._sessions.size();
                }
            }
        }
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
        for (int i = 0; i < LazyList.size(this._sessionListeners); ++i) {
            ((HttpSessionListener)LazyList.get(this._sessionListeners, i)).sessionCreated(event);
        }
        if (!(this._metaManager instanceof NullMetaManager)) {
            request.setAttribute(__NEW_SESSION_ID, (Object)session.getId());
        }
        return session;
    }

    protected abstract Session newSession(HttpServletRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newSessionId(HttpServletRequest request, long created) {
        SessionManager.MetaManager metaManager = this._metaManager;
        synchronized (metaManager) {
            if (!(this._metaManager instanceof NullMetaManager)) {
                String requested_id = (String)request.getAttribute(__NEW_SESSION_ID);
                if (requested_id == null) {
                    requested_id = request.getRequestedSessionId();
                }
                if (requested_id != null && requested_id != null && this._metaManager.idInUse(requested_id) && !this._sessions.containsKey(requested_id)) {
                    return requested_id;
                }
            }
            String id = null;
            while (id == null || id.length() == 0 || this._metaManager.idInUse(id)) {
                long r = this._random.nextLong();
                if (r < 0L) {
                    r = -r;
                }
                id = Long.toString(r, 30 + (int)(created % 7L));
                String worker = (String)request.getAttribute("org.mortbay.http.ajp.JVMRoute");
                if (worker != null) {
                    id = id + "." + worker;
                    continue;
                }
                if (this._workerName == null) continue;
                id = id + "." + this._workerName;
            }
            return id;
        }
    }

    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.remove(this._sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.remove(this._sessionListeners, listener);
        }
    }

    public void resetStats() {
        this._minSessions = this._sessions.size();
        this._maxSessions = this._sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now = System.currentTimeMillis();
            Object stale = null;
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                Iterator i = this._sessions.values().iterator();
                while (i.hasNext()) {
                    Session session = (Session)i.next();
                    long idleTime = session._maxIdleMs;
                    if (idleTime <= 0L || session._accessed + idleTime >= now) continue;
                    stale = LazyList.add(stale, session);
                }
            }
            int i = LazyList.size(stale);
            while (i-- > 0) {
                Session session = (Session)LazyList.get(stale, i);
                long idleTime = session._maxIdleMs;
                if (idleTime <= 0L || session._accessed + idleTime >= System.currentTimeMillis()) continue;
                session.invalidate();
                int nbsess = this._sessions.size();
                if (nbsess >= this._minSessions) continue;
                this._minSessions = nbsess;
            }
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 100) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        if (period != old_period) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._scavengePeriodMs = period;
                if (this._scavenger != null) {
                    this._scavenger.interrupt();
                }
            }
        }
    }

    public void setSecureCookies(boolean secureCookies) {
        this._secureCookies = secureCookies;
    }

    public void setUsingCookies(boolean usingCookies) {
        this._usingCookies = usingCookies;
    }

    public void setWorkerName(String workerName) {
        this._workerName = workerName;
    }

    public void doStart() throws Exception {
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._random == null) {
            Log.debug("New random session seed");
            this._random = new Random();
        } else if (Log.isDebugEnabled()) {
            Log.debug("Initializing random session key: " + this._random);
        }
        this._random.nextLong();
        if (this._sessions == null) {
            this._sessions = new HashMap();
        }
        if (this._scavenger == null) {
            this._scavenger = new SessionScavenger();
            this._scavenger.start();
        }
        if (this._metaManager == null) {
            this._metaManager = new NullMetaManager();
        }
        this._metaManager.start();
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        ArrayList sessions = new ArrayList(this._sessions.values());
        Iterator i = ((AbstractList)sessions).iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            session.invalidate();
        }
        this._sessions.clear();
        SessionScavenger scavenger = this._scavenger;
        this._scavenger = null;
        if (scavenger != null) {
            scavenger.interrupt();
        }
        this._loader = null;
    }

    public static class NullMetaManager
    extends AbstractLifeCycle
    implements SessionManager.MetaManager {
        public boolean idInUse(String id) {
            return false;
        }

        public void addSession(HttpSession session) {
        }

        public void invalidateAll(String id) {
        }

        public boolean crossContext() {
            return true;
        }
    }

    public static class SimpleMetaManager
    extends AbstractLifeCycle
    implements SessionManager.MetaManager {
        MultiMap _sessions;

        protected void doStart() {
            this._sessions = new MultiMap();
        }

        protected void doStop() {
            if (this._sessions != null) {
                this._sessions.clear();
            }
            this._sessions = null;
        }

        public boolean idInUse(String id) {
            return this._sessions.containsKey(id);
        }

        public void addSession(HttpSession session) {
            this._sessions.add(session.getId(), session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateAll(String id) {
            SimpleMetaManager simpleMetaManager = this;
            synchronized (simpleMetaManager) {
                while (this._sessions.containsKey(id)) {
                    Session session = (Session)this._sessions.getValue(id, 0);
                    if (session.isValid()) {
                        session.invalidate();
                        continue;
                    }
                    this._sessions.removeValue(id, session);
                }
            }
        }

        public boolean crossContext() {
            return true;
        }
    }

    public static class NullSessionContext
    implements HttpSessionContext {
        private NullSessionContext() {
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public HttpSession getSession(String id) {
            return null;
        }
    }

    class SessionScavenger
    extends Thread {
        SessionScavenger() {
            super("SessionScavenger");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int period = -1;
            try {
                while (AbstractSessionManager.this.isStarted()) {
                    try {
                        if (period != AbstractSessionManager.this._scavengePeriodMs) {
                            if (Log.isDebugEnabled()) {
                                Log.debug("Session scavenger period = " + AbstractSessionManager.this._scavengePeriodMs / 1000 + "s");
                            }
                            period = AbstractSessionManager.this._scavengePeriodMs;
                        }
                        Thread.sleep(period > 1000 ? (long)period : 1000L);
                        AbstractSessionManager.this.scavenge();
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Error e) {
                        Log.warn("EXCEPTION ", e);
                    }
                    catch (Exception e) {
                        Log.warn("EXCEPTION ", e);
                    }
                }
            }
            finally {
                AbstractSessionManager.this._scavenger = null;
                Log.debug("Session scavenger exited");
            }
        }
    }

    public abstract class Session
    implements SessionManager.Session {
        long _created;
        long _accessed;
        String _id;
        boolean _invalid;
        long _maxIdleMs;
        boolean _newSession;
        Map _values;

        protected Session(HttpServletRequest request) {
            this._accessed = this._created = System.currentTimeMillis();
            this._invalid = false;
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            this._newSession = true;
            this._id = AbstractSessionManager.this.newSessionId(request, this._created);
            if (AbstractSessionManager.this._dftMaxIdleSecs >= 0) {
                this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            }
        }

        public void access() {
            this._newSession = false;
            this._accessed = System.currentTimeMillis();
        }

        private void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        public synchronized Object getAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return null;
            }
            return this._values.get(name);
        }

        public synchronized Enumeration getAttributeNames() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            List<Object> names = this._values == null ? Collections.EMPTY_LIST : new ArrayList(this._values.keySet());
            return Collections.enumeration(names);
        }

        public long getCreationTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public String getId() throws IllegalStateException {
            return this._id;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._accessed;
        }

        public int getMaxInactiveInterval() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._context;
        }

        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return __nullSessionContext;
        }

        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        public synchronized String[] getValueNames() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] a = new String[this._values.size()];
            return this._values.keySet().toArray(a);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() throws IllegalStateException {
            if (Log.isDebugEnabled()) {
                Log.debug("Invalidate session " + this.getId());
            }
            try {
                Session session = this;
                synchronized (session) {
                    if (this._invalid) {
                        throw new IllegalStateException();
                    }
                    if (AbstractSessionManager.this._sessionListeners != null) {
                        HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                        for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionListeners); ++i) {
                            ((HttpSessionListener)LazyList.get(AbstractSessionManager.this._sessionListeners, i)).sessionDestroyed(event);
                        }
                    }
                    if (this._values != null) {
                        Iterator iter = this._values.keySet().iterator();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            Object value = this._values.get(key);
                            iter.remove();
                            this.unbindValue(key, value);
                            if (AbstractSessionManager.this._sessionAttributeListeners == null) continue;
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                            for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                                ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved(event);
                            }
                        }
                    }
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                SessionManager.MetaManager metaManager = AbstractSessionManager.this._metaManager;
                synchronized (metaManager) {
                    String id = this.getId();
                    Map map = AbstractSessionManager.this._sessions;
                    synchronized (map) {
                        this._invalid = true;
                        AbstractSessionManager.this._sessions.remove(id);
                    }
                    AbstractSessionManager.this._metaManager.invalidateAll(id);
                }
                throw throwable;
            }
            SessionManager.MetaManager metaManager = AbstractSessionManager.this._metaManager;
            synchronized (metaManager) {
                String id = this.getId();
                Map map = AbstractSessionManager.this._sessions;
                synchronized (map) {
                    this._invalid = true;
                    AbstractSessionManager.this._sessions.remove(id);
                }
                AbstractSessionManager.this._metaManager.invalidateAll(id);
            }
        }

        public boolean isNew() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        public boolean isValid() {
            return !this._invalid;
        }

        protected abstract Map newAttributeMap();

        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        public synchronized void removeAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return;
            }
            Object old = this._values.remove(name);
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved(event);
                    }
                }
            }
        }

        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        public synchronized void setAttribute(String name, Object value) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                this._values = this.newAttributeMap();
            }
            Object oldValue = this._values.put(name, value);
            if (value == null || !value.equals(oldValue)) {
                this.unbindValue(name, oldValue);
                this.bindValue(name, value);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue == null ? value : oldValue);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i);
                        if (oldValue == null) {
                            l.attributeAdded(event);
                            continue;
                        }
                        if (value == null) {
                            l.attributeRemoved(event);
                            continue;
                        }
                        l.attributeReplaced(event);
                    }
                }
            }
        }

        public void setMaxInactiveInterval(int secs) {
            this._maxIdleMs = (long)secs * 1000L;
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)AbstractSessionManager.this._scavengePeriodMs) {
                AbstractSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        private void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.getId();
        }
    }
}

