/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.ServletSSL;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class SslSocketConnector
extends SocketConnector {
    private String[] cipherSuites = null;
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    static final String CACHED_INFO_ATTR = (class$org$mortbay$jetty$security$SslSocketConnector$CachedInfo == null ? (class$org$mortbay$jetty$security$SslSocketConnector$CachedInfo = SslSocketConnector.class$("org.mortbay.jetty.security.SslSocketConnector$CachedInfo")) : class$org$mortbay$jetty$security$SslSocketConnector$CachedInfo).getName();
    private String _keystore = DEFAULT_KEYSTORE;
    private transient Password _password;
    private transient Password _keypassword;
    private String _protocol = "TLS";
    private String _algorithm = "SunX509";
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    static /* synthetic */ Class class$org$mortbay$jetty$security$SslSocketConnector$CachedInfo;

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword(PASSWORD_PROPERTY, password, null);
    }

    public void setKeyPassword(String password) {
        this._keypassword = Password.getPassword(KEYPASSWORD_PROPERTY, password, null);
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this._wantClientAuth = wantClientAuth;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        SSLContext context = SSLContext.getInstance(this._protocol);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._algorithm);
        KeyStore keyStore = KeyStore.getInstance(this._keystoreType);
        keyStore.load(Resource.newResource(this._keystore).getInputStream(), this._password.toString().toCharArray());
        keyManagerFactory.init(keyStore, this._keypassword.toString().toCharArray());
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return context.getServerSocketFactory();
    }

    protected ServerSocket newServerSocket(SocketAddress addr, int backlog) throws IOException {
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = (SSLServerSocket)factory.createServerSocket();
            socket.bind(addr, backlog);
            socket.setNeedClientAuth(this._needClientAuth);
            socket.setWantClientAuth(this._wantClientAuth);
            if (this.cipherSuites != null && this.cipherSuites.length > 0) {
                socket.setEnabledCipherSuites(this.cipherSuites);
                for (int i = 0; i < this.cipherSuites.length; ++i) {
                    Log.debug("SslListener enabled ciphersuite: " + this.cipherSuites[i]);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            throw new IOException("Could not create JsseListener: " + e.toString());
        }
        return socket;
    }

    protected void configure(Socket socket) throws IOException {
        super.configure(socket);
        ((SSLSocket)socket).startHandshake();
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SocketEndPoint socket_end_point = (SocketEndPoint)endpoint;
        SSLSocket sslSocket = (SSLSocket)socket_end_point.getConnection();
        try {
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSession sslSession = sslSocket.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength(cipherSuite));
                certs = SslSocketConnector.getCertChain(sslSession);
                cachedInfo = new CachedInfo(keySize, certs);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            } else if (this._needClientAuth) {
                throw new IllegalStateException("no client auth");
            }
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
        }
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException pue) {
            return null;
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CachedInfo {
        private Integer _keySize;
        private java.security.cert.X509Certificate[] _certs;

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs) {
            this._keySize = keySize;
            this._certs = certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }
    }
}

