/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mortbay.io.Buffer;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;
import org.mortbay.util.ajax.Continuation;

public class SelectChannelConnector
extends AbstractConnector {
    private transient ServerSocketChannel _acceptChannel;
    private transient SelectionKey _acceptKey;
    private transient SelectSet[] _selectSets;
    private boolean _assumeShortDispatch = false;

    public boolean getAssumeShortDispatch() {
        return this._assumeShortDispatch;
    }

    public void setAssumeShortDispatch(boolean assumeShortDispatch) {
        this._assumeShortDispatch = assumeShortDispatch;
    }

    protected void doStart() throws Exception {
        this._selectSets = new SelectSet[this.getAcceptors()];
        for (int i = 0; i < this._selectSets.length; ++i) {
            this._selectSets[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (int i = 0; i < this._selectSets.length; ++i) {
            this._selectSets[i].destroy();
        }
        this._selectSets = null;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        super.setMaxIdleTime(maxIdleTime);
    }

    public void open() throws IOException {
        if (this._acceptChannel == null) {
            this._acceptChannel = ServerSocketChannel.open();
            this._acceptChannel.configureBlocking(false);
            this._acceptChannel.socket().bind(this.getAddress());
            this._acceptKey = this._acceptChannel.register(this._selectSets[0].getSelector(), 16);
        }
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept(int acceptorID) throws IOException {
        if (this._selectSets != null && this._selectSets.length > acceptorID && this._selectSets[acceptorID] != null) {
            this._selectSets[acceptorID].accept();
        }
    }

    protected Buffer newBuffer(int size) {
        if (size == this.getHeaderBufferSize()) {
            return new NIOBuffer(size, false);
        }
        return new NIOBuffer(size, true);
    }

    public Continuation newContinuation() {
        return new RetryContinuation();
    }

    private class RetryContinuation
    extends Timeout.Task
    implements Continuation {
        Object _object;
        HttpEndPoint _endPoint;
        long _timeout;
        boolean _new = true;
        boolean _pending = false;
        boolean _resumed = false;

        private RetryContinuation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setEndPoint(HttpEndPoint ep) {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                this._endPoint = ep;
                if (this._resumed && this._endPoint != null) {
                    this.redispatch();
                }
            }
        }

        long getTimeout() {
            return this._timeout;
        }

        public boolean isNew() {
            return this._new;
        }

        public boolean isPending() {
            return this._pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (this._pending) {
                    this.redispatch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean suspend(long timeout) {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                boolean resumed = this._resumed;
                this._resumed = false;
                this._new = false;
                if (!this._pending && !resumed && timeout > 0L) {
                    this._pending = true;
                    this._timeout = timeout;
                    throw new RetryRequest();
                }
                this._pending = false;
                return resumed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                this._resumed = true;
                if (this.isExpired()) {
                    return;
                }
                this.cancel();
                if (this._endPoint != null) {
                    this.redispatch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void redispatch() {
            boolean dispatch_done = false;
            try {
                dispatch_done = SelectChannelConnector.this.getThreadPool().dispatch(this._endPoint);
                Object var3_2 = null;
                if (dispatch_done) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (dispatch_done) throw throwable;
                Log.warn("redispatch failed");
                this._endPoint.undispatch();
                throw throwable;
            }
            Log.warn("redispatch failed");
            this._endPoint.undispatch();
        }

        public Object getObject() {
            return this._object;
        }

        public void setObject(Object object) {
            this._object = object;
        }
    }

    private class HttpEndPoint
    extends ChannelEndPoint
    implements Runnable {
        SelectSet _selectSet;
        boolean _dispatched = false;
        boolean _writable = true;
        SelectionKey _key;
        HttpConnection _connection;
        int _interestOps;
        int _readBlocked;
        int _writeBlocked;
        IdleTask _timeoutTask = new IdleTask();

        HttpEndPoint(SocketChannel channel, SelectSet selectSet) {
            super(channel);
            this._selectSet = selectSet;
            this._connection = new HttpConnection(SelectChannelConnector.this, this, SelectChannelConnector.this.getServer());
            this._selectSet.scheduleIdle(this._timeoutTask);
        }

        void setKey(SelectionKey key) {
            this._key = key;
            this._key.attach(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void dispatch() throws IOException {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                if (this._key == null) {
                    this._timeoutTask.cancel();
                    return;
                }
                this._timeoutTask.reschedule();
                if (this._readBlocked > 0 || this._writeBlocked > 0) {
                    this.notifyAll();
                    this._key.interestOps(0);
                    return;
                }
                if (!SelectChannelConnector.this._assumeShortDispatch) {
                    this._key.interestOps(0);
                }
                if (this._dispatched) {
                    this._key.interestOps(0);
                    return;
                }
                if (this._key == null) {
                    return;
                }
                if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                    this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                    this._key.interestOps(this._interestOps);
                }
                this._dispatched = true;
            }
            boolean dispatch_done = false;
            try {
                dispatch_done = SelectChannelConnector.this.getThreadPool().dispatch(this);
                Object var4_4 = null;
                if (dispatch_done) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (dispatch_done) throw throwable;
                Log.warn("dispatch failed! threads=" + SelectChannelConnector.this.getThreadPool().getThreads() + " idle=" + SelectChannelConnector.this.getThreadPool().getIdleThreads());
                this.undispatch();
                throw throwable;
            }
            Log.warn("dispatch failed! threads=" + SelectChannelConnector.this.getThreadPool().getThreads() + " idle=" + SelectChannelConnector.this.getThreadPool().getIdleThreads());
            this.undispatch();
        }

        private void undispatch() {
            try {
                this._dispatched = false;
                if (this.getChannel().isOpen()) {
                    this.updateKey();
                }
            }
            catch (Exception e) {
                Log.warn(e);
                this._interestOps = -1;
                this._selectSet.addChange(this);
            }
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.getChannel().close();
            }
            return l;
        }

        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            int l = super.flush(header, buffer, trailer);
            this._writable = l > 0;
            return l;
        }

        public int flush(Buffer buffer) throws IOException {
            int l = super.flush(buffer);
            this._writable = l > 0;
            return l;
        }

        public boolean isOpen() {
            return super.isOpen() && this._key.isValid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blockReadable(long timeoutMs) {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                if (this.isOpen()) {
                    try {
                        ++this._readBlocked;
                        this.updateKey();
                        this.wait(timeoutMs);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        --this._readBlocked;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blockWritable(long timeoutMs) {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                if (this.isOpen()) {
                    try {
                        ++this._writeBlocked;
                        this.updateKey();
                        this.wait(timeoutMs);
                    }
                    catch (InterruptedException e) {
                        Log.ignore(e);
                    }
                    finally {
                        --this._writeBlocked;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateKey() {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                int ops = this._key == null ? 0 : this._key.interestOps();
                this._interestOps = ops | (!this._dispatched || this._readBlocked > 0 ? 1 : 0) | (!this._writable || this._writeBlocked > 0 ? 4 : 0);
                this._writable = true;
                if (this._interestOps != ops) {
                    this._selectSet.addChange(this);
                    this._selectSet.wakeup();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            HttpEndPoint httpEndPoint;
            try {
                try {
                    this._connection.handle();
                }
                catch (ClosedChannelException e) {
                    Log.ignore(e);
                    Object var4_2 = null;
                    HttpEndPoint httpEndPoint3 = this;
                    synchronized (httpEndPoint3) {
                        RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                        if (continuation != null && continuation.isPending()) {
                            Log.debug("continuation {}", continuation);
                            long timeout = continuation.getTimeout();
                            continuation.setEndPoint(this);
                            this._selectSet.scheduleTimeout(continuation, timeout);
                            this._selectSet.wakeup();
                        } else {
                            this.undispatch();
                        }
                        return;
                    }
                }
                catch (EofException e) {
                    Log.debug("EOF", e);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_3 = null;
                    HttpEndPoint httpEndPoint4 = this;
                    synchronized (httpEndPoint4) {
                        RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                        if (continuation != null && continuation.isPending()) {
                            Log.debug("continuation {}", continuation);
                            long timeout = continuation.getTimeout();
                            continuation.setEndPoint(this);
                            this._selectSet.scheduleTimeout(continuation, timeout);
                            this._selectSet.wakeup();
                        } else {
                            this.undispatch();
                        }
                        return;
                    }
                }
                catch (HttpException e) {
                    Log.debug("BAD", e);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_4 = null;
                    HttpEndPoint httpEndPoint5 = this;
                    synchronized (httpEndPoint5) {
                        RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                        if (continuation != null && continuation.isPending()) {
                            Log.debug("continuation {}", continuation);
                            long timeout = continuation.getTimeout();
                            continuation.setEndPoint(this);
                            this._selectSet.scheduleTimeout(continuation, timeout);
                            this._selectSet.wakeup();
                        } else {
                            this.undispatch();
                        }
                        return;
                    }
                }
                catch (Throwable e) {
                    Log.warn("handle failed", e);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_5 = null;
                    HttpEndPoint httpEndPoint6 = this;
                    synchronized (httpEndPoint6) {
                        RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                        if (continuation != null && continuation.isPending()) {
                            Log.debug("continuation {}", continuation);
                            long timeout = continuation.getTimeout();
                            continuation.setEndPoint(this);
                            this._selectSet.scheduleTimeout(continuation, timeout);
                            this._selectSet.wakeup();
                        } else {
                            this.undispatch();
                        }
                        return;
                    }
                }
                Object var4_1 = null;
                httpEndPoint = this;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                HttpEndPoint httpEndPoint2 = this;
                synchronized (httpEndPoint2) {
                    RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                    if (continuation != null && continuation.isPending()) {
                        Log.debug("continuation {}", continuation);
                        long timeout = continuation.getTimeout();
                        continuation.setEndPoint(this);
                        this._selectSet.scheduleTimeout(continuation, timeout);
                        this._selectSet.wakeup();
                    } else {
                        this.undispatch();
                    }
                    throw throwable;
                }
            }
            synchronized (httpEndPoint) {
                RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                if (continuation != null && continuation.isPending()) {
                    Log.debug("continuation {}", continuation);
                    long timeout = continuation.getTimeout();
                    continuation.setEndPoint(this);
                    this._selectSet.scheduleTimeout(continuation, timeout);
                    this._selectSet.wakeup();
                } else {
                    this.undispatch();
                }
                return;
            }
        }

        public void close() throws IOException {
            if (this._key != null) {
                this._key.cancel();
            }
            this._key = null;
            try {
                super.close();
                if (this._connection != null) {
                    this._connection.close();
                }
            }
            catch (IOException e) {
                throw new EofException(e);
            }
        }

        public String toString() {
            return "HEP@" + this.hashCode() + "[d=" + this._dispatched + ",io=" + this._interestOps + ",w=" + this._writable + ",b=" + this._readBlocked + "|" + this._writeBlocked + "]";
        }

        private class IdleTask
        extends Timeout.Task {
            private IdleTask() {
            }

            public void expire() {
                try {
                    HttpEndPoint.this.close();
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
            }

            public String toString() {
                return "TimeoutTask:" + HttpEndPoint.this.toString();
            }
        }
    }

    private class SelectSet {
        private transient int _setID;
        private transient Timeout _idleTimeout;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient List _changes;
        private transient int _nextSet;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout();
            this._idleTimeout.setDuration(SelectChannelConnector.this.getMaxIdleTime());
            this._retryTimeout = new Timeout();
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList();
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() throws Exception {
            List list = this._changes;
            synchronized (list) {
                this._idleTimeout.cancelAll();
                this._idleTimeout = null;
                this._retryTimeout.cancelAll();
                this._retryTimeout = null;
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
                this._selector = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept() throws IOException {
            List list = this._changes;
            synchronized (list) {
                for (int i = 0; i < this._changes.size(); ++i) {
                    try {
                        Object o = this._changes.get(i);
                        if (o instanceof SocketChannel) {
                            SocketChannel channel = (SocketChannel)o;
                            SelectionKey cKey = channel.register(this._selector, 1);
                            HttpEndPoint connection = new HttpEndPoint(channel, this);
                            connection.setKey(cKey);
                            connection.dispatch();
                            continue;
                        }
                        HttpEndPoint c = (HttpEndPoint)o;
                        if (c._interestOps >= 0 && c._key != null && c._key.isValid()) {
                            c._key.interestOps(c._interestOps);
                            continue;
                        }
                        if (c._key != null && c._key.isValid()) {
                            c._key.cancel();
                        }
                        c._key = null;
                        continue;
                    }
                    catch (CancelledKeyException e) {
                        Log.warn(e);
                    }
                }
                this._changes.clear();
            }
            long wait = SelectChannelConnector.this.getMaxIdleTime();
            long to_next = this._idleTimeout.getTimeToNext();
            if (wait < 0L || to_next >= 0L && wait > to_next) {
                wait = to_next;
            }
            to_next = this._retryTimeout.getTimeToNext();
            if (wait < 0L || to_next >= 0L && wait > to_next) {
                wait = to_next;
            }
            if (wait > 0L) {
                this._selector.select(wait);
            } else if (wait == 0L) {
                this._selector.selectNow();
            } else {
                this._selector.select();
            }
            long now = -1L;
            List list2 = this._changes;
            synchronized (list2) {
                if (this._selector == null) {
                    return;
                }
                now = System.currentTimeMillis();
                this._idleTimeout.setNow(now);
                this._retryTimeout.setNow(now);
            }
            Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                iter.remove();
                try {
                    HttpEndPoint connection;
                    if (!key.isValid()) {
                        key.cancel();
                        connection = (HttpEndPoint)key.attachment();
                        if (connection == null) continue;
                        connection.close();
                        continue;
                    }
                    if (key.equals(SelectChannelConnector.this._acceptKey)) {
                        if (key.isAcceptable()) {
                            SocketChannel channel = SelectChannelConnector.this._acceptChannel.accept();
                            channel.configureBlocking(false);
                            Socket socket = channel.socket();
                            SelectChannelConnector.this.configure(socket);
                            ++this._nextSet;
                            this._nextSet %= SelectChannelConnector.this._selectSets.length;
                            if (this._nextSet != this._setID) {
                                SelectChannelConnector.this._selectSets[this._nextSet].addChange(channel);
                                SelectChannelConnector.this._selectSets[this._nextSet].wakeup();
                            } else {
                                SelectionKey cKey = channel.register(SelectChannelConnector.this._selectSets[this._nextSet].getSelector(), 1);
                                HttpEndPoint connection2 = new HttpEndPoint(channel, SelectChannelConnector.this._selectSets[this._nextSet]);
                                connection2.setKey(cKey);
                                connection2.dispatch();
                            }
                        }
                    } else {
                        connection = (HttpEndPoint)key.attachment();
                        if (connection != null) {
                            connection.dispatch();
                        }
                    }
                    key = null;
                }
                catch (CancelledKeyException e) {
                    if (!SelectChannelConnector.this.isRunning()) continue;
                    Log.debug(e.toString());
                }
                catch (Exception e) {
                    if (SelectChannelConnector.this.isRunning()) {
                        Log.warn(e);
                    }
                    if (key == null || key == SelectChannelConnector.this._acceptKey) continue;
                    key.interestOps(0);
                }
            }
            List list3 = this._changes;
            synchronized (list3) {
                if (this._selector != null) {
                    now = System.currentTimeMillis();
                    this._retryTimeout.setNow(now);
                    this._retryTimeout.tick();
                    this._idleTimeout.setNow(now);
                    this._idleTimeout.tick();
                }
            }
        }

        public void scheduleIdle(Timeout.Task task) {
            task.schedule(this._idleTimeout);
        }

        public void scheduleTimeout(Timeout.Task task, long timeout) {
            this._retryTimeout.schedule(task, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List list = this._changes;
            synchronized (list) {
                this._changes.add(point);
            }
        }

        public void wakeup() {
            this._selector.wakeup();
        }
    }
}

