/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;

public class WrappedHandler
extends AbstractHandler {
    private Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    public void setHandler(Handler handler) {
        if (this._handler != null) {
            this._handler.setServer(null);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._handler, handler, "handler");
        }
        this._handler = handler;
        if (this._handler != null) {
            this._handler.setServer(this.getServer());
        }
    }

    protected void doStart() throws Exception {
        if (this._handler != null) {
            this._handler.start();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._handler != null) {
            this._handler.stop();
        }
    }

    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this._handler == null || !this.isStarted()) {
            return false;
        }
        return this._handler.handle(target, request, response, dispatch);
    }

    public void setServer(Server server) {
        if (this.getServer() != null && this.getServer() != server) {
            this.getServer().getContainer().update((Object)this, this._handler, null, "handler");
        }
        if (server != null && this.getServer() != server) {
            server.getContainer().update((Object)this, null, this._handler, "handler");
        }
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
    }
}

