/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

public class HandlerCollection
extends AbstractHandler
implements Handler {
    private Handler[] _handlers;

    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._handlers, handlers, "handler");
        }
        for (int i = 0; this._handlers != null && i < this._handlers.length; ++i) {
            if (this._handlers[i] == null) continue;
            this._handlers[i].setServer(null);
        }
        this._handlers = handlers;
        Server server = this.getServer();
        for (int i = 0; this._handlers != null && i < this._handlers.length; ++i) {
            if (this._handlers[i].getServer() == server) continue;
            this._handlers[i].setServer(server);
        }
    }

    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this._handlers != null && this.isStarted()) {
            for (int i = 0; i < this._handlers.length; ++i) {
                if (!this._handlers[i].handle(target, request, response, dispatch)) continue;
                return true;
            }
        }
        return false;
    }

    protected void doStart() throws Exception {
        MultiException mex = new MultiException();
        if (this._handlers != null) {
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        super.doStart();
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._handlers != null) {
            int i = this._handlers.length;
            while (i-- > 0) {
                try {
                    this._handlers[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    public Handler getHandler() {
        if (this._handlers == null || this._handlers.length == 0) {
            return null;
        }
        if (this._handlers.length > 1) {
            throw new IllegalStateException("Multiple Handlers");
        }
        return this._handlers[0];
    }

    public void setHandler(Handler handler) {
        this.setHandlers(new Handler[]{handler});
    }

    public void setServer(Server server) {
        if (this.getServer() != null && this.getServer() != server) {
            this.getServer().getContainer().update((Object)this, this._handlers, null, "handler");
        }
        if (server != null && this.getServer() != server) {
            server.getContainer().update((Object)this, null, this._handlers, "handler");
        }
        super.setServer(server);
        Handler[] h = this.getHandlers();
        for (int i = 0; h != null && i < h.length; ++i) {
            h[i].setServer(server);
        }
    }

    public void addHandler(Handler handler) throws Exception {
        Object[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            this.setHandler(handler);
        } else {
            this.setHandlers((Handler[])LazyList.addToArray(handlers, handler));
        }
        if (this.isStarted()) {
            handler.start();
        }
    }

    public void removeHandler(Handler handler) throws Exception {
        Object[] handlers = this.getHandlers();
        if (handlers != null && handlers.length > 0) {
            if (handler.isStarted()) {
                handler.stop();
            }
            this.setHandlers((Handler[])LazyList.removeFromArray(handlers, handler));
        }
    }
}

