/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.util.StringUtil;

public class MimeTypes {
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MESSAGE_HTTP = "message/http";
    public static final String MULTIPART_BYTERANGES = "multipart/byteranges";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML_8859_1 = "text/html;charset=ISO-8859-1";
    public static final String TEXT_PLAIN_8859_1 = "text/plain;charset=ISO-8859-1";
    public static final String TEXT_XML_8859_1 = "text/xml;charset=ISO-8859-1";
    public static final String TEXT_HTML_UTF_8 = "text/html;charset=UTF-8";
    public static final String TEXT_PLAIN_UTF_8 = "text/plain;charset=UTF-8";
    public static final String TEXT_XML_UTF_8 = "text/xml;charset=UTF-8";
    private static int index = 1;
    private static final int FORM_ENCODED_ORDINAL = index++;
    private static final int MESSAGE_HTTP_ORDINAL = index++;
    private static final int MULTIPART_BYTERANGES_ORDINAL = index++;
    private static final int TEXT_HTML_ORDINAL = index++;
    private static final int TEXT_PLAIN_ORDINAL = index++;
    private static final int TEXT_XML_ORDINAL = index++;
    private static final int TEXT_HTML_8859_1_ORDINAL = index++;
    private static final int TEXT_PLAIN_8859_1_ORDINAL = index++;
    private static final int TEXT_XML_8859_1_ORDINAL = index++;
    private static final int TEXT_HTML_UTF_8_ORDINAL = index++;
    private static final int TEXT_PLAIN_UTF_8_ORDINAL = index++;
    private static final int TEXT_XML_UTF_8_ORDINAL = index++;
    public static final BufferCache CACHE = new BufferCache();
    public static final BufferCache.CachedBuffer FORM_ENCODED_BUFFER = CACHE.add("application/x-www-form-urlencoded", FORM_ENCODED_ORDINAL);
    public static final BufferCache.CachedBuffer MESSAGE_HTTP_BUFFER = CACHE.add("message/http", MESSAGE_HTTP_ORDINAL);
    public static final BufferCache.CachedBuffer MULTIPART_BYTERANGES_BUFFER = CACHE.add("multipart/byteranges", MULTIPART_BYTERANGES_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_HTML_BUFFER = CACHE.add("text/html", TEXT_HTML_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_BUFFER = CACHE.add("text/plain", TEXT_PLAIN_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_XML_BUFFER = CACHE.add("text/xml", TEXT_XML_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_HTML_8859_1_BUFFER = new BufferCache.CachedBuffer("text/html;charset=ISO-8859-1", TEXT_HTML_8859_1_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_8859_1_BUFFER = new BufferCache.CachedBuffer("text/plain;charset=ISO-8859-1", TEXT_PLAIN_8859_1_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_XML_8859_1_BUFFER = new BufferCache.CachedBuffer("text/xml;charset=ISO-8859-1", TEXT_XML_8859_1_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_HTML_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/html;charset=UTF-8", TEXT_HTML_UTF_8_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/plain;charset=UTF-8", TEXT_PLAIN_UTF_8_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_XML_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/xml;charset=UTF-8", TEXT_XML_UTF_8_ORDINAL);
    private static final Map __dftMimeMap = new HashMap();
    private static final Map __encodings = new HashMap();
    private Map _mimeMap;
    private Map _encodingMap;

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map mimeMap) {
        if (mimeMap == null) {
            this._mimeMap = null;
            return;
        }
        HashMap m = new HashMap();
        Iterator i = mimeMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            m.put(entry.getKey(), MimeTypes.normalizeMimeType(entry.getValue().toString()));
        }
        this._mimeMap = m;
    }

    public Buffer getMimeByExtension(String filename) {
        Buffer type = null;
        if (filename != null) {
            int i = -1;
            while (type == null && (i = filename.indexOf(".", i + 1)) >= 0 && i < filename.length()) {
                String ext = StringUtil.asciiToLowerCase(filename.substring(i + 1));
                if (this._mimeMap != null) {
                    type = (Buffer)this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = (Buffer)__dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = (Buffer)this._mimeMap.get("*");
            }
            if (type == null) {
                type = (Buffer)__dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(StringUtil.asciiToLowerCase(extension), MimeTypes.normalizeMimeType(type));
    }

    public synchronized Map getEncodingMap() {
        return this._encodingMap;
    }

    public void setEncodingMap(Map encodingMap) {
        if (encodingMap == null) {
            this._encodingMap = null;
            return;
        }
        HashMap e = new HashMap();
        Iterator i = encodingMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            e.put(MimeTypes.normalizeMimeType(entry.getKey().toString()), entry.getValue());
        }
        this._encodingMap = e;
    }

    public String getEncodingByMimeType(String type) {
        String encoding = null;
        if (type != null) {
            encoding = (String)this._encodingMap.get(type);
        }
        return encoding;
    }

    public void addTypeEncoding(String mimeType, String encoding) {
        this.getEncodingMap().put(mimeType, encoding);
    }

    private static synchronized Buffer normalizeMimeType(String type) {
        BufferCache.CachedBuffer b = CACHE.get(type);
        if (b == null) {
            b = CACHE.add(type, index++);
        }
        return b;
    }

    static {
        ResourceBundle mime = ResourceBundle.getBundle("org/mortbay/jetty/mime");
        Enumeration<String> i = mime.getKeys();
        while (i.hasMoreElements()) {
            String ext = i.nextElement();
            String m = mime.getString(ext);
            __dftMimeMap.put(StringUtil.asciiToLowerCase(ext), MimeTypes.normalizeMimeType(m));
        }
        ResourceBundle encoding = ResourceBundle.getBundle("org/mortbay/jetty/encoding");
        i = encoding.getKeys();
        while (i.hasMoreElements()) {
            Buffer type = MimeTypes.normalizeMimeType(i.nextElement());
            __encodings.put(type, encoding.getString(type.toString()));
        }
        TEXT_HTML_BUFFER.setAssociate("ISO-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("ISO_8859_1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("iso-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO_8859_1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("iso-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO_8859_1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("iso-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("utf-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF-8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf-8", TEXT_XML_UTF_8_BUFFER);
    }
}

