/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.Server;
import org.mortbay.log.Log;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public class HttpConnection {
    private static int UNKNOWN = -2;
    private static ThreadLocal __currentConnection = new ThreadLocal();
    private Connector _connector;
    private EndPoint _endp;
    private Server _server;
    private boolean _expectingContinues;
    private URI _uri;
    private HttpParser _parser;
    private HttpFields _requestFields;
    private Request _request;
    private Input _in;
    private HttpGenerator _generator;
    private HttpFields _responseFields;
    private Response _response;
    private Output _out;
    private OutputWriter _writer;
    private PrintWriter _printWriter;
    int _writeChunk = 1500;
    int _include;
    private Object _associatedObject;
    private transient Buffer _content;
    private transient int _connection = UNKNOWN;
    private transient int _expect = UNKNOWN;
    private transient int _version = UNKNOWN;
    private transient boolean _head = false;
    private transient boolean _host = false;

    public static HttpConnection getCurrentConnection() {
        return (HttpConnection)__currentConnection.get();
    }

    public HttpConnection(Connector connector, EndPoint endpoint, Server server) {
        this._connector = connector;
        this._endp = endpoint;
        this._parser = new HttpParser(this._connector, endpoint, new RequestHandler(), this._connector.getHeaderBufferSize(), this._connector.getRequestBufferSize());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(this._connector, this._endp, this._connector.getHeaderBufferSize(), this._connector.getResponseBufferSize());
        this._server = server;
    }

    public void close() throws IOException {
        if (this._parser != null) {
            this._parser.reset(true);
        }
        if (this._generator != null) {
            this._generator.reset(true);
        }
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this._associatedObject = associatedObject;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public Handler getHandler() {
        return this._server;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        if (this._connector != null) {
            return this._connector.isConfidential(request);
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public boolean useDNS() {
        return false;
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() {
        if (this._in == null) {
            this._in = new Input();
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public PrintWriter getPrintWriter(String encoding) {
        this.getOutputStream();
        if (this._writer == null) {
            this._writer = new OutputWriter();
            this._printWriter = new PrintWriter(this._writer){

                public void close() {
                    try {
                        HttpConnection.this._out.close();
                    }
                    catch (IOException e) {
                        Log.debug(e);
                        this.setError();
                    }
                }
            };
        }
        this._writer.setCharacterEncoding(encoding);
        return this._printWriter;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    /*
     * Exception decompiling
     */
    public void handle() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doHandler() throws IOException {
        boolean error;
        block12: {
            if (this._server == null) return;
            boolean retry = false;
            error = false;
            try {
                try {
                    this._request.setRequestURI(this._uri.getRawPath());
                    this._request.setQueryString(this._uri.getRawQuery());
                    String path_info = URIUtil.canonicalPath(this._uri.getPath());
                    int semi = path_info.indexOf(59);
                    if (semi > 0) {
                        path_info = path_info.substring(0, semi);
                    }
                    this._request.setPathInfo(path_info);
                    if (this._out != null) {
                        this._out.reopen();
                    }
                    this._connector.customize(this._endp, this._request);
                    this._server.handle(this);
                }
                catch (RetryRequest r) {
                    Log.ignore(r);
                    return;
                }
                catch (EofException e) {
                    Log.ignore(e);
                    error = true;
                    Object var6_10 = null;
                    if (retry) return;
                    if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                        Log.debug("continuation still pending {}");
                        this._request.getContinuation().suspend(0L);
                    }
                    if (error) return;
                    this._response.complete();
                    if (this._generator.isComplete()) return;
                    this._generator.completeHeader(this._responseFields, true);
                    this._generator.complete();
                    return;
                }
                catch (ServletException e) {
                    Log.warn(e);
                    this._generator.sendError(500, null, null, true);
                    Object var6_11 = null;
                    if (retry) return;
                    if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                        Log.debug("continuation still pending {}");
                        this._request.getContinuation().suspend(0L);
                    }
                    if (error) return;
                    this._response.complete();
                    if (this._generator.isComplete()) return;
                    this._generator.completeHeader(this._responseFields, true);
                    this._generator.complete();
                    return;
                }
                Object var6_8 = null;
                if (retry) return;
                if (this._request.getContinuation() == null || !this._request.getContinuation().isPending()) break block12;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                if (retry) throw throwable;
                if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                    Log.debug("continuation still pending {}");
                    this._request.getContinuation().suspend(0L);
                }
                if (error) throw throwable;
                this._response.complete();
                if (this._generator.isComplete()) throw throwable;
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw throwable;
            }
            Log.debug("continuation still pending {}");
            this._request.getContinuation().suspend(0L);
        }
        if (error) return;
        this._response.complete();
        if (this._generator.isComplete()) return;
        this._generator.completeHeader(this._responseFields, true);
        this._generator.complete();
    }

    public void commitResponse(boolean last) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, last);
        }
        if (last) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, true);
        }
        if (!this._generator.isComplete()) {
            this._generator.complete();
        }
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this._generator.flushBuffers();
        }
        catch (IOException e) {
            throw new EofException(e);
        }
    }

    HttpGenerator getGenerator() {
        return this._generator;
    }

    public boolean isIncluding() {
        return this._include > 0;
    }

    public void include() {
        ++this._include;
    }

    public void included() {
        --this._include;
        if (this._out != null) {
            this._out.reopen();
        }
    }

    public class OutputWriter
    extends Writer {
        int _maxChar;
        String _characterEncoding;
        Writer _converter;
        ByteArrayOutputStream2 _bytes;
        char[] _chars;

        public void setCharacterEncoding(String encoding) {
            if (this._characterEncoding == null || !this._characterEncoding.equalsIgnoreCase(encoding)) {
                this._converter = null;
            }
            this._characterEncoding = encoding;
        }

        public void close() throws IOException {
            HttpConnection.this._out.close();
        }

        public void flush() throws IOException {
            HttpConnection.this._out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String s, int offset, int length) throws IOException {
            if (this._bytes == null) {
                this._bytes = new ByteArrayOutputStream2(HttpConnection.this._writeChunk * 2);
                this._maxChar = this._characterEncoding == null ? 128 : (StringUtil.__ISO_8859_1.equalsIgnoreCase(this._characterEncoding) ? 256 : ("UTF-8".equalsIgnoreCase(this._characterEncoding) ? 128 : 0));
            }
            if (this._converter == null) {
                Writer writer = this._converter = this._characterEncoding == null ? new OutputStreamWriter(this._bytes) : new OutputStreamWriter((OutputStream)this._bytes, this._characterEncoding);
            }
            if (length > 16) {
                if (this._chars == null) {
                    this._chars = new char[HttpConnection.this._writeChunk];
                }
                int end = offset + length;
                int i = offset;
                while (i < end) {
                    int chunk = HttpConnection.this._writeChunk;
                    int next = i + chunk;
                    if (next > end) {
                        next = end;
                        chunk = next - i;
                    }
                    s.getChars(i, next, this._chars, 0);
                    i += chunk;
                    int n = 0;
                    while (n < chunk) {
                        char c = this._chars[n];
                        if (c < this._maxChar) {
                            this._bytes.writeUnchecked(c);
                            ++n;
                            continue;
                        }
                        int i0 = n++;
                        if ((n += HttpConnection.this._writeChunk / 2) > chunk) {
                            n = chunk;
                        }
                        this._converter.write(this._chars, i0, i - i0);
                        this._converter.flush();
                    }
                    HttpConnection.this._out.write(this._bytes.getBuf(), 0, this._bytes.getCount());
                    this._bytes.reset();
                }
            } else {
                ByteArrayOutputStream2 byteArrayOutputStream2 = this._bytes;
                synchronized (byteArrayOutputStream2) {
                    int end = offset + length;
                    int i = offset;
                    while (i < end) {
                        int next = i + HttpConnection.this._writeChunk;
                        if (next > end) {
                            next = end;
                        }
                        while (i < next) {
                            char c = s.charAt(i);
                            if (c < this._maxChar) {
                                this._bytes.writeUnchecked(c);
                                ++i;
                                continue;
                            }
                            int i0 = i;
                            if ((i += HttpConnection.this._writeChunk / 2) > next) {
                                i = next;
                            }
                            this._converter.write(s, i0, i - i0);
                            this._converter.flush();
                        }
                        HttpConnection.this._out.write(this._bytes.getBuf(), 0, this._bytes.getCount());
                        this._bytes.reset();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(char[] s, int offset, int length) throws IOException {
            if (this._bytes == null) {
                this._bytes = new ByteArrayOutputStream2(HttpConnection.this._writeChunk * 2);
                this._maxChar = this._characterEncoding == null ? 0 : (StringUtil.__ISO_8859_1.equalsIgnoreCase(this._characterEncoding) ? 256 : ("UTF-8".equalsIgnoreCase(this._characterEncoding) ? 128 : 0));
            }
            ByteArrayOutputStream2 byteArrayOutputStream2 = this._bytes;
            synchronized (byteArrayOutputStream2) {
                int end = offset + length;
                int i = offset;
                while (i < end) {
                    int next = i + HttpConnection.this._writeChunk;
                    if (next > end) {
                        next = end;
                    }
                    while (i < next) {
                        char c = s[i];
                        if (c < this._maxChar) {
                            ++i;
                            this._bytes.writeUnchecked(c);
                            continue;
                        }
                        if (this._converter == null) {
                            this._converter = new OutputStreamWriter((OutputStream)this._bytes, this._characterEncoding);
                        }
                        int i0 = i;
                        if ((i += HttpConnection.this._writeChunk / 2) > next) {
                            i = next;
                        }
                        this._converter.write(s, i0, i - i0);
                        this._converter.flush();
                    }
                    byte[] b = this._bytes.getBuf();
                    HttpConnection.this._out.write(b, 0, this._bytes.getCount());
                    this._bytes.reset();
                }
            }
        }
    }

    public class Output
    extends ServletOutputStream {
        ByteArrayBuffer _buf1 = null;
        ByteArrayBuffer _bufn = null;
        boolean _closed;

        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            if (!HttpConnection.this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(true);
            } else {
                HttpConnection.this.flushResponse();
            }
            this._closed = true;
        }

        void reopen() {
            this._closed = false;
        }

        public void flush() throws IOException {
            HttpConnection.this.flushResponse();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this._bufn == null) {
                this._bufn = new ByteArrayBuffer(b, off, len);
            } else {
                this._bufn.wrap(b, off, len);
            }
            this.write(this._bufn);
        }

        public void write(byte[] b) throws IOException {
            if (this._bufn == null) {
                this._bufn = new ByteArrayBuffer(b);
            } else {
                this._bufn.wrap(b);
            }
            this.write(this._bufn);
        }

        public void write(int b) throws IOException {
            if (this._buf1 == null) {
                this._buf1 = new ByteArrayBuffer(1);
            } else {
                this._buf1.clear();
            }
            this._buf1.put((byte)b);
            this.write(this._buf1);
        }

        private void write(Buffer buffer) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            while (HttpConnection.this._generator.isBufferFull() && HttpConnection.this._endp.isOpen() && !HttpConnection.this._endp.isBlocking()) {
                HttpConnection.this._endp.blockWritable(HttpConnection.this._connector.getMaxIdleTime());
                HttpConnection.this._generator.flushBuffers();
            }
            HttpConnection.this._generator.addContent(buffer, false);
            if (HttpConnection.this._generator.isBufferFull()) {
                HttpConnection.this.commitResponse(false);
                HttpConnection.this._generator.flushBuffers();
            }
            while (buffer.length() > 0 && HttpConnection.this._endp.isOpen() && !HttpConnection.this._endp.isBlocking()) {
                HttpConnection.this._endp.blockWritable(HttpConnection.this._connector.getMaxIdleTime());
                HttpConnection.this._generator.flushBuffers();
            }
        }

        public void print(String s) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            PrintWriter writer = HttpConnection.this.getPrintWriter(null);
            writer.print(s);
        }

        public void sendContent(Object content) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (HttpConnection.this._generator.getContentAdded() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (content instanceof HttpContent) {
                HttpContent c = (HttpContent)content;
                if (c.getContentType() != null && !HttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    HttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, c.getContentType());
                }
                if (c.getContentLength() > 0L) {
                    HttpConnection.this._responseFields.addLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, c.getContentLength());
                }
                if (c.getLastModified() != null) {
                    HttpConnection.this._responseFields.add(HttpHeaders.LAST_MODIFIED_BUFFER, c.getLastModified());
                }
                if (c.getBuffer() != null) {
                    HttpConnection.this._generator.addContent(c.getBuffer(), true);
                }
                HttpConnection.this.commitResponse(true);
            } else if (content instanceof Buffer) {
                HttpConnection.this._generator.addContent((Buffer)content, true);
                HttpConnection.this.commitResponse(true);
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    private class Input
    extends ServletInputStream {
        private Input() {
        }

        private boolean blockForContent() throws IOException {
            if (HttpConnection.this._content != null && HttpConnection.this._content.length() > 0) {
                return true;
            }
            if (HttpConnection.this._parser.isState(0)) {
                return false;
            }
            HttpConnection.this._content = null;
            if (HttpConnection.this._endp == null) {
                HttpConnection.this._parser.parseNext();
            } else if (HttpConnection.this._endp.isBlocking()) {
                long filled = HttpConnection.this._parser.parseNext();
                while (!(HttpConnection.this._content != null && HttpConnection.this._content.length() != 0 || filled == 0L || HttpConnection.this._parser.isState(0))) {
                    filled = HttpConnection.this._parser.parseNext();
                }
            } else {
                long filled = HttpConnection.this._parser.parseNext();
                boolean blocked = false;
                while (!(HttpConnection.this._content != null && HttpConnection.this._content.length() != 0 || HttpConnection.this._parser.isState(0))) {
                    if (filled > 0L) {
                        blocked = false;
                    } else if (filled == 0L) {
                        if (blocked) {
                            throw new InterruptedIOException("timeout");
                        }
                        blocked = true;
                        HttpConnection.this._endp.blockReadable(HttpConnection.this._connector.getMaxIdleTime());
                    }
                    filled = HttpConnection.this._parser.parseNext();
                }
            }
            return HttpConnection.this._content != null && HttpConnection.this._content.length() > 0;
        }

        public int read() throws IOException {
            int c = -1;
            if (this.blockForContent()) {
                c = HttpConnection.this._content.get();
            }
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int l = -1;
            if (this.blockForContent()) {
                l = HttpConnection.this._content.get(b, off, len);
            }
            return l;
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        boolean _delayedHandling = false;

        private RequestHandler() {
        }

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            HttpConnection.this._host = false;
            HttpConnection.this._expect = UNKNOWN;
            HttpConnection.this._connection = UNKNOWN;
            this._delayedHandling = false;
            HttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            HttpConnection.this._request.setMethod(method.toString());
            try {
                HttpConnection.this._uri = new URI(new String(uri.asArray(), "UTF-8"));
                HttpConnection.this._uri = HttpConnection.this._uri.normalize();
                HttpConnection.this._request.setUri(HttpConnection.this._uri);
                HttpConnection.this._version = version == null ? 9 : HttpVersions.CACHE.getOrdinal(version);
                if (HttpConnection.this._version <= 0) {
                    HttpConnection.this._version = 10;
                }
                HttpConnection.this._request.setProtocol(version.toString());
                HttpConnection.this._head = method == HttpMethods.HEAD_BUFFER;
            }
            catch (URISyntaxException e) {
                HttpConnection.this._parser.reset(true);
                HttpConnection.this._generator.setResponse(400, null);
                HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                HttpConnection.this._generator.complete();
                return;
            }
        }

        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            switch (ho) {
                case 27: {
                    HttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    HttpConnection.this._expect = HttpHeaderValues.CACHE.getOrdinal(value);
                    break;
                }
                case 21: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    break;
                }
                case 1: {
                    HttpConnection.this._connection = HttpHeaderValues.CACHE.getOrdinal(value);
                    if (HttpConnection.this._connection < 0) {
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, value);
                        break;
                    }
                    value = HttpHeaderValues.CACHE.get(HttpConnection.this._connection);
                    HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, value);
                }
            }
            HttpConnection.this._requestFields.add(name, value);
        }

        public void headerComplete() throws IOException {
            HttpConnection.this._generator.setVersion(HttpConnection.this._version);
            switch (HttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    break;
                }
                case 11: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (!HttpConnection.this._host) {
                        HttpConnection.this._generator.setResponse(400, null);
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                        HttpConnection.this._generator.complete();
                        return;
                    }
                    if (HttpConnection.this._expect == UNKNOWN) break;
                    if (HttpConnection.this._expect == HttpHeaderValues.CONTINUE_ORDINAL) {
                        HttpConnection.this._expectingContinues = true;
                        if (HttpConnection.this._parser.getHeaderBuffer() != null && HttpConnection.this._parser.getHeaderBuffer().length() >= 2) break;
                        HttpConnection.this._generator.setResponse(100, null);
                        HttpConnection.this._generator.completeHeader(null, true);
                        HttpConnection.this._generator.complete();
                        HttpConnection.this._generator.reset(false);
                        break;
                    }
                    HttpConnection.this._generator.sendError(417, null, null, true);
                    return;
                }
            }
            if (HttpConnection.this._parser.getContentLength() <= 0 && !HttpConnection.this._parser.isChunking()) {
                HttpConnection.this.doHandler();
            } else {
                this._delayedHandling = true;
            }
        }

        public void content(Buffer ref) throws IOException {
            HttpConnection.this._content = ref;
            if (this._delayedHandling) {
                this._delayedHandling = false;
                HttpConnection.this.doHandler();
            }
        }

        public void messageComplete(int contextLength) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            throw new IllegalStateException("response");
        }
    }
}

