/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNUtil;

public class SwitchCommand
extends SVNCommand {
    public void run(final PrintStream out, final PrintStream err) throws SVNException {
        String url = this.getCommandLine().getURL(0);
        String absolutePath = this.getCommandLine().getPathAt(0);
        final ISVNWorkspace workspace = this.createWorkspace(absolutePath, true);
        final String homePath = absolutePath;
        String path = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absolutePath);
        final boolean[] changesReceived = new boolean[]{false};
        String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
        long revision = -1L;
        if (revStr != null) {
            try {
                revision = Long.parseLong(revStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

            public void updated(String updatedPath, int contentsStatus, int propertiesStatus, long rev) {
                try {
                    updatedPath = SwitchCommand.this.convertPath(homePath, workspace, updatedPath);
                }
                catch (IOException e) {
                    DebugLog.error((Throwable)e);
                }
                char contents = 'U';
                char properties = ' ';
                if (contentsStatus == 1) {
                    contents = 'A';
                } else if (contentsStatus == 3) {
                    contents = 'D';
                } else if (contentsStatus == 4) {
                    contents = 'G';
                } else if (contentsStatus == 2) {
                    contents = 'C';
                } else if (contentsStatus == 0) {
                    contents = ' ';
                } else if (contentsStatus == 19) {
                    contents = 'U';
                }
                if (propertiesStatus == 16) {
                    properties = 'U';
                } else if (propertiesStatus == 2) {
                    properties = 'C';
                }
                DebugLog.log((String)(contents + "" + properties + ' ' + updatedPath));
                if (contents == ' ' && properties == ' ') {
                    return;
                }
                changesReceived[0] = true;
                out.println(contents + "" + properties + ' ' + updatedPath);
                if (contentsStatus == 19) {
                    err.println("svn: Checksum error: base version of file '" + updatedPath + "' is corrupted and was not updated.");
                    DebugLog.log((String)("svn: Checksum error: base version of file '" + updatedPath + "' is corrupted and was not updated."));
                }
            }
        });
        workspace.update(SVNRepositoryLocation.parseURL((String)url), path, revision, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
        if (!changesReceived[0]) {
            SwitchCommand.println(out, "At revision " + revision + ".");
        } else {
            SwitchCommand.println(out, "Updated to revision " + revision + ".");
        }
    }
}

