/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.SVNUtil;

public class RevertCommand
extends SVNCommand {
    public final void run(final PrintStream out, PrintStream err) throws SVNException {
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            String absolutePath;
            final String workspacePath = absolutePath = this.getCommandLine().getPathAt(i);
            final ISVNWorkspace workspace = this.createWorkspace(absolutePath);
            workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

                public void modified(String path, int kind) {
                    try {
                        path = RevertCommand.this.convertPath(workspacePath, workspace, path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (kind == 11) {
                        RevertCommand.println(out, "Reverted '" + path + "'");
                    } else {
                        RevertCommand.println(out, "Error: Failed to revert '" + path + "' -- try updating instead");
                    }
                }
            });
            String relativePath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absolutePath);
            workspace.revert(relativePath, recursive);
        }
    }
}

