/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.SVNUtil;

public class ProplistCommand
extends SVNCommand {
    public final void run(PrintStream out, PrintStream err) throws SVNException {
        boolean verbose = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        if (recursive) {
            throw new SVNException("Recursive currently not supported!");
        }
        String absolutePath = this.getCommandLine().getPathAt(0);
        ISVNWorkspace workspace = this.createWorkspace(absolutePath, false);
        String relativePath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)new File(absolutePath).getAbsolutePath());
        ProplistCommand.println(out, "Properties on '" + absolutePath + "':");
        Iterator it = workspace.propertyNames(relativePath);
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if (propertyName.startsWith("svn:entry:")) continue;
            StringBuffer line = new StringBuffer();
            line.append("  ");
            line.append(propertyName);
            if (verbose) {
                line.append(" : ");
                line.append(workspace.getPropertyValue(relativePath, propertyName));
            }
            ProplistCommand.println(out, line.toString());
        }
    }
}

