/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class MoveCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasPaths() && this.getCommandLine().hasURLs()) {
            err.println("only URL->URL or WC->WC copy is supported");
            return;
        }
        if (this.getCommandLine().hasURLs()) {
            this.runRemote(out);
        } else {
            this.runLocally(out);
        }
    }

    private void runRemote(PrintStream out) throws SVNException {
        String srcPath = this.getCommandLine().getURL(0);
        String destPath = this.getCommandLine().getURL(1);
        String message = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        String root = PathUtil.getCommonRoot((String[])new String[]{destPath, srcPath});
        SVNRepository repository = this.createRepository(root);
        long revNumber = -1L;
        String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
        if (revStr != null) {
            try {
                revNumber = Long.parseLong(revStr);
            }
            catch (NumberFormatException e) {
                revNumber = -1L;
            }
        }
        if (revNumber < 0L) {
            revNumber = repository.getLatestRevision();
        }
        String deletePath = srcPath.substring(root.length());
        destPath = destPath.substring(root.length());
        deletePath = PathUtil.removeLeadingSlash((String)deletePath);
        destPath = PathUtil.removeLeadingSlash((String)destPath);
        destPath = PathUtil.decode((String)destPath);
        deletePath = PathUtil.decode((String)deletePath);
        ISVNEditor editor = repository.getCommitEditor(message, null);
        try {
            editor.openRoot(-1L);
            DebugLog.log((String)("adding: " + destPath + " from " + deletePath));
            editor.addDir(destPath, deletePath, revNumber);
            editor.closeDir();
            DebugLog.log((String)("deleting: " + deletePath + " at " + revNumber));
            editor.deleteEntry(deletePath, revNumber);
            editor.closeDir();
            SVNCommitInfo info = editor.closeEdit();
            out.println();
            out.println("Committed revision " + info.getNewRevision() + ".");
        }
        catch (SVNException e) {
            if (editor != null) {
                try {
                    editor.abortEdit();
                }
                catch (SVNException inner) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private void runLocally(final PrintStream out) throws SVNException {
        if (this.getCommandLine().getPathCount() != 2) {
            throw new SVNException("Please enter SRC and DST path");
        }
        final String absoluteSrcPath = this.getCommandLine().getPathAt(0);
        final String absoluteDstPath = this.getCommandLine().getPathAt(1);
        final ISVNWorkspace workspace = this.createWorkspace(absoluteSrcPath);
        final String srcPath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absoluteSrcPath);
        String dstTempPath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absoluteDstPath);
        SVNStatus status = workspace.status(dstTempPath, false);
        String dstPath = status != null && status.isDirectory() ? PathUtil.append((String)dstTempPath, (String)PathUtil.tail((String)srcPath)) : dstTempPath;
        workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

            public void modified(String path, int kind) {
                try {
                    path = path.equals(srcPath) ? MoveCommand.this.convertPath(absoluteSrcPath, workspace, path) : MoveCommand.this.convertPath(absoluteDstPath, workspace, path);
                }
                catch (IOException e) {
                    // empty catch block
                }
                String kindString = kind == 1 ? "A" : "D";
                MoveCommand.println(out, kindString + "  " + path);
            }
        });
        workspace.copy(srcPath, dstPath, true);
    }
}

