/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.io.SVNDirEntry;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class LsCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasURLs()) {
            this.runRemote();
        } else {
            this.runLocally(out);
        }
    }

    private void runRemote() throws SVNException {
        throw new SVNException("Remote cat is currently not supported.");
    }

    private void runLocally(PrintStream out) throws SVNException {
        for (int index = 0; index < this.getCommandLine().getPathCount(); ++index) {
            String absolutePath = this.getCommandLine().getPathAt(index);
            ISVNWorkspace workspace = this.createWorkspace(absolutePath);
            String path = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absolutePath);
            SVNRepositoryLocation location = workspace.getLocation();
            long revision = LsCommand.parseRevision(this.getCommandLine(), workspace, path);
            this.list(location, path, revision, out);
        }
    }

    private void list(SVNRepositoryLocation location, String path, long revision, PrintStream out) throws SVNException {
        SVNRepository repository = this.createRepository(location.toString());
        ArrayList entries = new ArrayList();
        SVNNodeKind kind = repository.checkPath(path, revision);
        if (kind == SVNNodeKind.FILE) {
            repository.getFile(path, revision, null, (OutputStream)new ByteArrayOutputStream());
            LsCommand.println(out, PathUtil.tail((String)path));
            return;
        }
        repository.getDir(path, revision, new HashMap(), entries);
        Collections.sort(entries, new DirEntryByNameComparator());
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            SVNDirEntry entry = (SVNDirEntry)it.next();
            LsCommand.println(out, entry.getName() + (entry.getKind() == SVNNodeKind.DIR ? "/" : ""));
        }
    }

    private static final class DirEntryByNameComparator
    implements Comparator {
        private DirEntryByNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((SVNDirEntry)o1).getName().compareTo(((SVNDirEntry)o2).getName());
        }
    }
}

