/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.ISVNWorkspaceListener;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.SVNWorkspaceAdapter;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class CopyCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasURLs()) {
            if (this.getCommandLine().hasPaths()) {
                String path = this.getCommandLine().getPathAt(0);
                String url = this.getCommandLine().getURL(0);
                if (this.getCommandLine().isPathURLBefore(url, path)) {
                    this.runRemoteToLocal(out);
                } else {
                    this.runLocalToRemote(out);
                }
            } else {
                this.runRemote(out, err);
            }
        } else {
            this.runLocally(out);
        }
    }

    private void runLocally(final PrintStream out) throws SVNException {
        if (this.getCommandLine().getPathCount() != 2) {
            throw new SVNException("Please enter SRC and DST path");
        }
        String absoluteSrcPath = this.getCommandLine().getPathAt(0);
        final String absoluteDstPath = this.getCommandLine().getPathAt(1);
        final ISVNWorkspace workspace = this.createWorkspace(absoluteSrcPath);
        String srcPath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absoluteSrcPath);
        SVNRepository repository = this.createRepository(workspace.getLocation(srcPath).toCanonicalForm());
        long revNumber = CopyCommand.getRevisionNumber((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION), srcPath, workspace, repository);
        if (revNumber >= 0L && revNumber != SVNProperty.longValue((String)workspace.getPropertyValue(srcPath, "svn:entry:revision"))) {
            this.getCommandLine().setPathAt(0, null);
            this.getCommandLine().setURLAt(0, workspace.getLocation(srcPath).toCanonicalForm());
            this.getCommandLine().setArgumentValue(SVNArgument.REVISION, Long.toString(revNumber));
            this.runRemoteToLocal(out);
            return;
        }
        workspace.addWorkspaceListener((ISVNWorkspaceListener)new SVNWorkspaceAdapter(){

            public void modified(String path, int kind) {
                try {
                    path = CopyCommand.this.convertPath(absoluteDstPath, workspace, path);
                }
                catch (IOException e) {
                    // empty catch block
                }
                String kindString = kind == 1 ? "A" : "D";
                CopyCommand.println(out, kindString + "  " + path);
            }
        });
        String dstTempPath = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absoluteDstPath);
        SVNStatus status = workspace.status(dstTempPath, false);
        String dstPath = status != null && status.isDirectory() ? PathUtil.append((String)dstTempPath, (String)PathUtil.tail((String)srcPath)) : dstTempPath;
        workspace.copy(srcPath, dstPath, false);
    }

    private void runRemote(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().getURLCount() != 2) {
            throw new SVNException("Please enter SRC and DST URL");
        }
        String srcURL = this.getCommandLine().getURL(0);
        String destURL = this.getCommandLine().getURL(1);
        String message = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        SVNRepository repository = this.createRepository(destURL);
        String root = destURL;
        String newPath = PathUtil.tail((String)srcURL);
        SVNNodeKind nodeKind = repository.checkPath("", -1L);
        if (nodeKind == SVNNodeKind.NONE) {
            root = PathUtil.removeTail((String)destURL);
            repository = this.createRepository(root);
            newPath = PathUtil.tail((String)destURL);
        }
        newPath = PathUtil.removeLeadingSlash((String)newPath);
        newPath = PathUtil.decode((String)newPath);
        long revNumber = -1L;
        String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
        if (revStr != null) {
            try {
                revNumber = Long.parseLong(revStr);
            }
            catch (NumberFormatException e) {
                revNumber = -1L;
            }
        }
        if (revNumber < 0L) {
            revNumber = repository.getLatestRevision();
        }
        String newPathParent = null;
        DebugLog.log((String)("checking new path: " + newPath));
        nodeKind = repository.checkPath(newPath, -1L);
        if (nodeKind == SVNNodeKind.DIR) {
            DebugLog.log((String)("can't copy to '" + PathUtil.append((String)destURL, (String)newPath) + "', location already exists"));
            err.println("can't copy to '" + PathUtil.append((String)destURL, (String)newPath) + "', location already exists");
            return;
        }
        SVNRepositoryLocation srcLocation = SVNRepositoryLocation.parseURL((String)srcURL);
        srcURL = srcLocation.getPath();
        srcURL = PathUtil.decode((String)srcURL);
        if (repository.getRepositoryRoot() == null) {
            repository.testConnection();
        }
        if (!(srcURL = srcURL.substring(repository.getRepositoryRoot().length())).startsWith("/")) {
            srcURL = srcURL + "/";
        }
        ISVNEditor editor = repository.getCommitEditor(message, null);
        try {
            editor.openRoot(-1L);
            if (newPathParent != null) {
                editor.openDir(newPathParent, -1L);
            }
            editor.addDir(newPath, srcURL, revNumber);
            editor.closeDir();
            if (newPathParent != null) {
                editor.closeDir();
            }
            editor.closeDir();
            SVNCommitInfo info = editor.closeEdit();
            out.println();
            out.println("Committed revision " + info.getNewRevision() + ".");
        }
        catch (SVNException e) {
            if (editor != null) {
                try {
                    editor.abortEdit();
                }
                catch (SVNException es) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private void runRemoteToLocal(PrintStream out) throws SVNException {
        String srcURL = this.getCommandLine().getURL(0);
        String destPathParent = this.getCommandLine().getPathAt(0);
        destPathParent = destPathParent.replace(File.separatorChar, '/');
        long revision = -1L;
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
            revision = Long.parseLong(revStr);
        }
        DebugLog.log((String)("workspace id is : " + destPathParent));
        ISVNWorkspace ws = this.createWorkspace(destPathParent);
        DebugLog.log((String)("workspace root is : " + ws.getID()));
        String wsPath = SVNUtil.getWorkspacePath((ISVNWorkspace)ws, (String)destPathParent);
        DebugLog.log((String)("workspace path is : " + wsPath));
        ws.copy(SVNRepositoryLocation.parseURL((String)srcURL), wsPath, revision);
    }

    private void runLocalToRemote(PrintStream out) throws SVNException {
        String dstURL = this.getCommandLine().getURL(0);
        String srcPath = this.getCommandLine().getPathAt(0);
        String message = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        srcPath = srcPath.replace(File.separatorChar, '/');
        ISVNWorkspace ws = this.createWorkspace(srcPath);
        String wsPath = SVNUtil.getWorkspacePath((ISVNWorkspace)ws, (String)srcPath);
        DebugLog.log((String)("workspace path is : " + wsPath));
        long revision = ws.copy(wsPath, SVNRepositoryLocation.parseURL((String)dstURL), message);
        out.println();
        out.println("Committed revision " + revision + ".");
    }
}

