/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNEntryContent;
import org.tmatesoft.svn.core.ISVNFileContent;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.io.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNLogEntry;
import org.tmatesoft.svn.core.io.SVNLogEntryPath;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.SVNUtil;

public class CatCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasURLs()) {
            this.runRemote();
        } else {
            this.runLocally(out);
        }
    }

    private void runRemote() throws SVNException {
        throw new SVNException("Remote cat is currently not supported.");
    }

    private void runLocally(PrintStream out) throws SVNException {
        for (int index = 0; index < this.getCommandLine().getPathCount(); ++index) {
            String absolutePath = this.getCommandLine().getPathAt(index);
            ISVNWorkspace workspace = this.createWorkspace(absolutePath);
            String path = SVNUtil.getWorkspacePath((ISVNWorkspace)workspace, (String)absolutePath);
            this.cat(out, workspace, path);
        }
    }

    private void cat(PrintStream out, ISVNWorkspace workspace, String path) throws SVNException {
        String currentRevisionStr;
        long currentRevNumber;
        ISVNEntryContent content = workspace.getContent(path);
        if (!(content instanceof ISVNFileContent)) {
            throw new SVNException("Can only cat files.");
        }
        String filePath = workspace.getPropertyValue(path, "svn:entry:url");
        if (workspace.getPropertyValue(path, "svn:entry:copyfrom-url") != null) {
            filePath = workspace.getPropertyValue(path, "svn:entry:copyfrom-url");
        }
        String fileURL = PathUtil.removeTail((String)filePath);
        filePath = PathUtil.tail((String)filePath);
        SVNRepository repository = this.createRepository(fileURL);
        repository.testConnection();
        String revision = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
        long revNumber = -1L;
        if (revision != null) {
            revNumber = CatCommand.getRevisionNumber(revision, repository);
        }
        if (revNumber >= 0L && (currentRevNumber = Long.parseLong(currentRevisionStr = workspace.getPropertyValue(path, "svn:entry:revision"))) != revNumber) {
            String absoluteFilePath = SVNRepositoryLocation.parseURL((String)fileURL).getPath();
            absoluteFilePath = absoluteFilePath.substring(repository.getRepositoryRoot().length());
            absoluteFilePath = PathUtil.append((String)absoluteFilePath, (String)filePath);
            final String[] realPath = new String[]{absoluteFilePath};
            repository.log(new String[]{absoluteFilePath}, currentRevNumber, revNumber, true, false, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) {
                    Map paths = logEntry.getChangedPaths();
                    SVNLogEntryPath p = (SVNLogEntryPath)paths.get(realPath[0]);
                    if (p.getCopyPath() != null) {
                        realPath[0] = p.getCopyPath();
                    }
                }
            });
            filePath = realPath[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        repository.getFile(filePath, revNumber, null, (OutputStream)bos);
        out.print(new String(bos.toByteArray()));
    }

    private static long getRevisionNumber(String revision, SVNRepository repository) throws SVNException {
        if (revision == null) {
            return -2L;
        }
        try {
            return Long.parseLong(revision);
        }
        catch (NumberFormatException numberFormatException) {
            return repository.getLatestRevision();
        }
    }
}

