/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNAssert;

public class SVNCommandLine {
    private Set myUnaryArguments;
    private Map myBinaryArguments;
    private String myCommandName;
    private List myPaths;
    private List myURLs;
    private List myPathURLs;

    public SVNCommandLine(String[] commandLine) throws SVNException {
        this.init(commandLine);
    }

    public boolean hasArgument(SVNArgument argument) {
        return this.myBinaryArguments.containsKey(argument) || this.myUnaryArguments.contains(argument);
    }

    public Object getArgumentValue(SVNArgument argument) {
        return this.myBinaryArguments.get(argument);
    }

    public void setArgumentValue(SVNArgument argument, Object value) {
        this.myBinaryArguments.put(argument, value);
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public boolean hasPaths() {
        return !this.myPaths.isEmpty();
    }

    public int getPathCount() {
        return this.myPaths.size();
    }

    public String getPathAt(int index) {
        return (String)this.myPaths.get(index);
    }

    public boolean hasURLs() {
        return !this.myURLs.isEmpty();
    }

    public int getURLCount() {
        return this.myURLs.size();
    }

    public String getURL(int index) {
        return (String)this.myURLs.get(index);
    }

    public void setURLAt(int index, String url) {
        if (index >= this.myURLs.size()) {
            this.myURLs.add(url);
            return;
        }
        if (url != null) {
            this.myURLs.set(index, url);
        } else {
            this.myURLs.remove(index);
        }
    }

    public void setPathAt(int index, String path) {
        if (index >= this.myPaths.size()) {
            this.myPaths.add(path);
            return;
        }
        if (path != null) {
            this.myPaths.set(index, path);
        } else {
            this.myPaths.remove(index);
        }
    }

    protected void init(String[] arguments) throws SVNException {
        this.myUnaryArguments = new HashSet();
        this.myBinaryArguments = new HashMap();
        this.myPaths = new ArrayList();
        this.myURLs = new ArrayList();
        this.myPathURLs = new ArrayList();
        SVNArgument previousArgument = null;
        String previousArgumentName = null;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (previousArgument != null) {
                if (argument.startsWith("--") || argument.startsWith("-")) {
                    throw new SVNException("argument '" + previousArgumentName + "' requires value");
                }
                Object value = previousArgument.parseValue(argument);
                DebugLog.log((String)("value (2): " + value));
                this.myBinaryArguments.put(previousArgument, value);
                previousArgument = null;
                previousArgumentName = null;
                continue;
            }
            if (argument.startsWith("--")) {
                SVNArgument svnArgument = SVNArgument.findArgument(argument);
                if (svnArgument != null) {
                    if (svnArgument.hasValue()) {
                        previousArgument = svnArgument;
                        previousArgumentName = argument;
                        continue;
                    }
                    this.myUnaryArguments.add(svnArgument);
                    continue;
                }
                throw new SVNException("invalid argument '" + argument + "'");
            }
            if (argument.startsWith("-")) {
                for (int j = 1; j < argument.length(); ++j) {
                    String name = "-" + argument.charAt(j);
                    DebugLog.log((String)("parsing argument: " + name));
                    SVNArgument svnArgument = SVNArgument.findArgument(name);
                    if (svnArgument != null) {
                        if (svnArgument.hasValue()) {
                            if (j + 1 < argument.length()) {
                                String value = argument.substring(j + 1);
                                Object argValue = svnArgument.parseValue(value);
                                DebugLog.log((String)("value: " + value));
                                this.myBinaryArguments.put(svnArgument, argValue);
                            } else {
                                previousArgument = svnArgument;
                                previousArgumentName = name;
                            }
                            j = argument.length();
                            continue;
                        }
                        this.myUnaryArguments.add(svnArgument);
                        continue;
                    }
                    throw new SVNException("invalid argument '" + name + "'");
                }
                continue;
            }
            if (this.myCommandName == null) {
                this.myCommandName = argument;
                continue;
            }
            this.myPathURLs.add(argument);
            if (argument.indexOf("://") >= 0) {
                this.myURLs.add(argument);
                continue;
            }
            this.myPaths.add(argument);
        }
        if (this.myCommandName == null) {
            throw new SVNException("no command name defined");
        }
        if (this.myPathURLs.isEmpty()) {
            this.myPaths.add(".");
            this.myPathURLs.add(".");
        }
    }

    public boolean isPathURLBefore(String pathURL1, String pathURL2) {
        int index1 = this.myPathURLs.indexOf(pathURL1);
        int index2 = this.myPathURLs.indexOf(pathURL2);
        SVNAssert.assertTrue((index1 >= 0 ? 1 : 0) != 0, (String)pathURL1);
        SVNAssert.assertTrue((index2 >= 0 ? 1 : 0) != 0, (String)pathURL2);
        SVNAssert.assertTrue((index1 != index2 ? 1 : 0) != 0, (String)pathURL2);
        return index1 < index2;
    }
}

