/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.tmatesoft.svn.core.io.SVNException;

public abstract class SVNArgument {
    public static final SVNArgument PASSWORD = SVNArgument.createStringArgument(new String[]{"--password"});
    public static final SVNArgument USERNAME = SVNArgument.createStringArgument(new String[]{"--username"});
    public static final SVNArgument CONFIG_DIR = SVNArgument.createStringArgument(new String[]{"--config-dir"});
    public static final SVNArgument NON_RECURSIVE = SVNArgument.createUnaryArgument(new String[]{"--non-recursive", "-N"});
    public static final SVNArgument RECURSIVE = SVNArgument.createUnaryArgument(new String[]{"--recursive", "-R"});
    public static final SVNArgument VERBOSE = SVNArgument.createUnaryArgument(new String[]{"--verbose", "-v"});
    public static final SVNArgument QUIET = SVNArgument.createUnaryArgument(new String[]{"--quiet", "-q"});
    public static final SVNArgument SHOW_UPDATES = SVNArgument.createUnaryArgument(new String[]{"--show-updates", "-u"});
    public static final SVNArgument NO_IGNORE = SVNArgument.createUnaryArgument(new String[]{"--no-ignore"});
    public static final SVNArgument MESSAGE = SVNArgument.createStringArgument(new String[]{"--message", "-m"});
    public static final SVNArgument REVISION = SVNArgument.createStringArgument(new String[]{"--revision", "-r"});
    public static final SVNArgument FORCE = SVNArgument.createUnaryArgument(new String[]{"--force"});
    public static final SVNArgument FILE = SVNArgument.createStringArgument(new String[]{"-F"});
    public static final SVNArgument EDITOR_CMD = SVNArgument.createStringArgument(new String[]{"--editor-cmd"});
    public static final SVNArgument STRICT = SVNArgument.createUnaryArgument(new String[]{"--strict"});
    private static Set ourArguments = new HashSet();
    private ArrayList myNames = new ArrayList();

    public static SVNArgument findArgument(String name) {
        Iterator arguments = ourArguments.iterator();
        while (arguments.hasNext()) {
            SVNArgument argument = (SVNArgument)arguments.next();
            Iterator names = argument.names();
            while (names.hasNext()) {
                String argumentName = (String)names.next();
                if (!argumentName.equals(name)) continue;
                return argument;
            }
        }
        return null;
    }

    private static SVNArgument createStringArgument(String[] names) {
        return new SVNStringArgument(names);
    }

    private static SVNArgument createUnaryArgument(String[] names) {
        return new SVNUnaryArgument(names);
    }

    private SVNArgument(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.myNames.add(names[i]);
        }
    }

    public Iterator names() {
        return this.myNames.iterator();
    }

    public abstract boolean hasValue();

    public abstract Object parseValue(String var1) throws SVNException;

    static {
        ourArguments.add(PASSWORD);
        ourArguments.add(USERNAME);
        ourArguments.add(CONFIG_DIR);
        ourArguments.add(NON_RECURSIVE);
        ourArguments.add(RECURSIVE);
        ourArguments.add(VERBOSE);
        ourArguments.add(QUIET);
        ourArguments.add(SHOW_UPDATES);
        ourArguments.add(NO_IGNORE);
        ourArguments.add(MESSAGE);
        ourArguments.add(REVISION);
        ourArguments.add(FORCE);
        ourArguments.add(FILE);
        ourArguments.add(EDITOR_CMD);
        ourArguments.add(STRICT);
    }

    private static class SVNStringArgument
    extends SVNArgument {
        protected SVNStringArgument(String[] names) {
            super(names);
        }

        public boolean hasValue() {
            return true;
        }

        public Object parseValue(String value) throws SVNException {
            return value;
        }
    }

    private static class SVNUnaryArgument
    extends SVNArgument {
        protected SVNUnaryArgument(String[] names) {
            super(names);
        }

        public boolean hasValue() {
            return false;
        }

        public Object parseValue(String value) throws SVNException {
            return null;
        }
    }
}

