/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class BoundedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private static final long serialVersionUID = 2806675379803919606L;
    private static int __id;
    private transient List _blocked;
    private int _blockMs = 10000;
    private boolean _daemon;
    private transient int _id;
    private final String _lock = "LOCK";
    private final String _joinLock = "JOIN";
    private int _maxIdleTimeMs = 10000;
    private int _maxThreads = 255;
    private int _minThreads = 1;
    private String _name = this.getClass().getName();
    int _priority = 5;
    private Set _threads;
    private List _idle;
    private boolean _warned = false;

    public BoundedThreadPool() {
        int dot = this._name.lastIndexOf(46);
        if (dot >= 0) {
            this._name = this._name.substring(dot + 1);
        }
        this._name = this._name + __id++;
    }

    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        String string = "JOIN";
        synchronized ("JOIN") {
            while (this.isRunning()) {
                "JOIN".wait(this.getMaxIdleTimeMs());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            while (this.isStopping()) {
                Thread.sleep(10L);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newThread() {
        String string = "LOCK";
        synchronized ("LOCK") {
            PoolThread thread = new PoolThread();
            this._threads.add(thread);
            this._idle.add(thread);
            thread.setName(this._name + "-" + this._id++);
            thread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(Runnable job) {
        boolean queued = false;
        String string = "LOCK";
        synchronized ("LOCK") {
            if (!this.isRunning()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            int blockMs = this._blockMs;
            while (this._idle.size() == 0) {
                if (this._threads.size() < this._maxThreads) {
                    this.newThread();
                    break;
                }
                if (!this._warned) {
                    this._warned = true;
                    Log.debug("Out of threads for {}", this);
                }
                if (blockMs < 0) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                try {
                    this._blocked.add(Thread.currentThread());
                    "LOCK".wait(blockMs);
                    blockMs = -1;
                }
                catch (InterruptedException ie) {}
                continue;
                finally {
                    this._blocked.remove(Thread.currentThread());
                }
            }
            PoolThread thread = (PoolThread)this._idle.remove(this._idle.size() - 1);
            thread.dispatch(job);
            queued = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this._idle.size() == 0) {
                Thread.yield();
            }
            return queued;
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        this._maxThreads = maxThreads;
    }

    public void setMinThreads(int minThreads) {
        this._minThreads = minThreads;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void doStart() throws Exception {
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._blocked = new ArrayList();
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        String string = "LOCK";
        synchronized ("LOCK") {
            Iterator iter = this._threads.iterator();
            while (iter.hasNext()) {
                ((Thread)iter.next()).interrupt();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            super.doStop();
            string = "JOIN";
            synchronized ("JOIN") {
                "JOIN".notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this._job != null) {
                    throw new IllegalStateException();
                }
                this._job = job;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (BoundedThreadPool.this.isRunning()) {
                    String string;
                    Object var4_2;
                    PoolThread poolThread = this;
                    // MONITORENTER : poolThread
                    try {
                        block26: {
                            try {
                                while (this._job == null) {
                                    this.wait(BoundedThreadPool.this.getMaxIdleTimeMs());
                                }
                                if (!BoundedThreadPool.this.isRunning() || this._job == null) break block26;
                                this._job.run();
                            }
                            catch (InterruptedException e) {
                                Log.ignore(e);
                                var4_2 = null;
                                string = "LOCK";
                                // MONITORENTER : "LOCK"
                                if (this._job != null) {
                                    BoundedThreadPool.this._idle.add(this);
                                    if (BoundedThreadPool.this._idle.size() >= BoundedThreadPool.this._minThreads) {
                                        BoundedThreadPool.this._warned = false;
                                    }
                                }
                                this._job = null;
                                if (BoundedThreadPool.this._blocked.size() > 0) {
                                    ((Thread)BoundedThreadPool.this._blocked.get(0)).interrupt();
                                }
                                // MONITOREXIT : string
                                // MONITOREXIT : poolThread
                                break;
                            }
                        }
                        var4_2 = null;
                        string = "LOCK";
                        // MONITORENTER : "LOCK"
                        if (this._job != null) {
                            BoundedThreadPool.this._idle.add(this);
                            if (BoundedThreadPool.this._idle.size() >= BoundedThreadPool.this._minThreads) {
                                BoundedThreadPool.this._warned = false;
                            }
                        }
                        this._job = null;
                        if (BoundedThreadPool.this._blocked.size() > 0) {
                            ((Thread)BoundedThreadPool.this._blocked.get(0)).interrupt();
                        }
                        // MONITOREXIT : string
                    }
                    catch (Throwable throwable) {
                        var4_2 = null;
                        string = "LOCK";
                        // MONITORENTER : "LOCK"
                        if (this._job != null) {
                            BoundedThreadPool.this._idle.add(this);
                            if (BoundedThreadPool.this._idle.size() >= BoundedThreadPool.this._minThreads) {
                                BoundedThreadPool.this._warned = false;
                            }
                        }
                        this._job = null;
                        if (BoundedThreadPool.this._blocked.size() > 0) {
                            ((Thread)BoundedThreadPool.this._blocked.get(0)).interrupt();
                        }
                        // MONITOREXIT : string
                        throw throwable;
                    }
                    // MONITOREXIT : poolThread
                }
                Object var9_6 = null;
                String string = "LOCK";
                // MONITORENTER : "LOCK"
                BoundedThreadPool.this._threads.remove(this);
                // MONITOREXIT : string
                return;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                String string = "LOCK";
                // MONITORENTER : "LOCK"
                BoundedThreadPool.this._threads.remove(this);
                // MONITOREXIT : string
                throw throwable;
            }
        }
    }
}

