/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Buffer;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.log.Log;

public class BlockingChannelConnector
extends AbstractConnector {
    private transient ServerSocketChannel _acceptChannel;

    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        this._acceptChannel.socket().bind(this.getAddress());
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        Connection connection = new Connection(channel);
        connection.dispatch();
    }

    protected Buffer newBuffer(int size) {
        return new NIOBuffer(size, true);
    }

    private class Connection
    extends ChannelEndPoint
    implements Runnable {
        boolean _dispatched = false;
        HttpConnection _connection;

        Connection(ByteChannel channel) throws IOException {
            super(channel);
            this._connection = new HttpConnection(BlockingChannelConnector.this, this, BlockingChannelConnector.this.getServer());
        }

        void dispatch() throws InterruptedException, IOException {
            if (!BlockingChannelConnector.this.getThreadPool().dispatch(this)) {
                Log.warn("dispatch failed for  {}", this._connection);
                this.close();
            }
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.getChannel().close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.isOpen()) {
                    this._connection.handle();
                }
            }
            catch (EofException e) {
                Log.debug("EOF", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (HttpException e) {
                Log.debug("BAD", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (Throwable e) {
                Log.warn("handle failed", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
        }
    }
}

