/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroFactory;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.log.LogManager;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.apache.velocity.runtime.log.PrimordialLogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.util.SimplePool;
import org.apache.velocity.util.StringUtils;
import org.apache.velocity.util.introspection.Introspector;

public class RuntimeInstance
implements RuntimeConstants,
RuntimeServices {
    private VelocimacroFactory vmFactory = null;
    private LogSystem logSystem = new PrimordialLogSystem();
    private SimplePool parserPool;
    private boolean initialized;
    private ExtendedProperties overridingProperties = null;
    private Hashtable runtimeDirectives;
    private ExtendedProperties configuration = new ExtendedProperties();
    private ResourceManager resourceManager = null;
    private Introspector introspector = null;
    private Map applicationAttributes = null;

    public synchronized void init() throws Exception {
        if (!this.initialized) {
            this.info("************************************************************** ");
            this.info("Starting Jakarta Velocity v1.4-dev");
            this.info("RuntimeInstance initializing.");
            this.initializeProperties();
            this.initializeLogger();
            this.initializeResourceManager();
            this.initializeDirectives();
            this.initializeParserPool();
            this.vmFactory.initVelocimacro();
            this.info("Velocity successfully started.");
            this.initialized = true;
        }
    }

    private final void setDefaultProperties() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream("org/apache/velocity/runtime/defaults/velocity.properties");
            this.configuration.load(inputStream);
            this.info("Default Properties File: " + new File("org/apache/velocity/runtime/defaults/velocity.properties").getPath());
        }
        catch (IOException ioe) {
            System.err.println("Cannot get Velocity Runtime default properties!");
        }
    }

    public void setProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtendedProperties();
        }
        this.overridingProperties.setProperty(key, value);
    }

    public void setConfiguration(ExtendedProperties configuration) {
        if (this.overridingProperties == null) {
            this.overridingProperties = configuration;
        } else if (this.overridingProperties != configuration) {
            this.overridingProperties.combine(configuration);
        }
    }

    public void addProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtendedProperties();
        }
        this.overridingProperties.addProperty(key, value);
    }

    public void clearProperty(String key) {
        if (this.overridingProperties != null) {
            this.overridingProperties.clearProperty(key);
        }
    }

    public Object getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    private final void initializeProperties() {
        if (!this.configuration.isInitialized()) {
            this.setDefaultProperties();
        }
        if (this.overridingProperties != null) {
            this.configuration.combine(this.overridingProperties);
        }
    }

    public void init(Properties p) throws Exception {
        this.overridingProperties = ExtendedProperties.convertProperties((Properties)p);
        this.init();
    }

    public void init(String configurationFile) throws Exception {
        this.overridingProperties = new ExtendedProperties(configurationFile);
        this.init();
    }

    private final void initializeResourceManager() throws Exception {
        Object o;
        String rm = this.getString("resource.manager.class");
        if (rm != null && rm.length() > 0) {
            o = null;
            try {
                o = Class.forName(rm).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for Resourcemanager (" + rm + ") does not exist (or is not accessible to the current classlaoder.";
                this.error(err);
                throw new Exception(err);
            }
            if (!(o instanceof ResourceManager)) {
                String err = "The specified class for ResourceManager (" + rm + ") does not implement org.apache.runtime.resource.ResourceManager." + " Velocity not initialized correctly.";
                this.error(err);
                throw new Exception(err);
            }
        } else {
            String err = "It appears that no class was specified as the ResourceManager.  Please ensure that all configuration information is correct.";
            this.error(err);
            throw new Exception(err);
        }
        this.resourceManager = o;
        this.resourceManager.initialize(this);
    }

    private final void initializeLogger() throws Exception {
        if (this.logSystem instanceof PrimordialLogSystem) {
            PrimordialLogSystem pls = (PrimordialLogSystem)this.logSystem;
            this.logSystem = LogManager.createLogSystem(this);
            if (this.logSystem == null) {
                this.logSystem = new NullLogSystem();
            } else {
                pls.dumpLogMessages(this.logSystem);
            }
        }
    }

    private final void initializeDirectives() throws Exception {
        this.runtimeDirectives = new Hashtable();
        Properties directiveProperties = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/apache/velocity/runtime/defaults/directive.properties");
        if (inputStream == null) {
            throw new Exception("Error loading directive.properties! Something is very wrong if these properties aren't being located. Either your Velocity distribution is incomplete or your Velocity jar file is corrupted!");
        }
        directiveProperties.load(inputStream);
        Enumeration directiveClasses = ((Hashtable)directiveProperties).elements();
        while (directiveClasses.hasMoreElements()) {
            String directiveClass = (String)directiveClasses.nextElement();
            this.loadDirective(directiveClass, "System");
        }
        String[] userdirective = this.configuration.getStringArray("userdirective");
        int i = 0;
        while (i < userdirective.length) {
            this.loadDirective(userdirective[i], "User");
            ++i;
        }
    }

    private final void loadDirective(String directiveClass, String caption) {
        try {
            Object o = Class.forName(directiveClass).newInstance();
            if (o instanceof Directive) {
                Directive directive = (Directive)o;
                this.runtimeDirectives.put(directive.getName(), directive);
                this.info("Loaded " + caption + " Directive: " + directiveClass);
            } else {
                this.error(caption + " Directive " + directiveClass + " is not org.apache.velocity.runtime.directive.Directive." + " Ignoring. ");
            }
        }
        catch (Exception e) {
            this.error("Exception Loading " + caption + " Directive: " + directiveClass + " : " + e);
        }
    }

    private final void initializeParserPool() {
        int numParsers = this.getInt("parser.pool.size", 20);
        this.parserPool = new SimplePool(numParsers);
        int i = 0;
        while (i < numParsers) {
            this.parserPool.put(this.createNewParser());
            ++i;
        }
        this.info("Created: " + numParsers + " parsers.");
    }

    public Parser createNewParser() {
        Parser parser = new Parser(this);
        parser.setDirectives(this.runtimeDirectives);
        return parser;
    }

    public SimpleNode parse(Reader reader, String templateName) throws ParseException {
        return this.parse(reader, templateName, true);
    }

    public SimpleNode parse(Reader reader, String templateName, boolean dumpNamespace) throws ParseException {
        SimpleNode ast = null;
        Parser parser = (Parser)this.parserPool.get();
        boolean madeNew = false;
        if (parser == null) {
            this.error("Runtime : ran out of parsers. Creating new.   Please increment the parser.pool.size property. The current value is too small.");
            parser = this.createNewParser();
            if (parser != null) {
                madeNew = true;
            }
        }
        if (parser != null) {
            try {
                if (dumpNamespace) {
                    this.dumpVMNamespace(templateName);
                }
                ast = parser.parse(reader, templateName);
            }
            finally {
                Object var8_7 = null;
                if (!madeNew) {
                    this.parserPool.put(parser);
                }
            }
        } else {
            this.error("Runtime : ran out of parsers and unable to create more.");
        }
        return ast;
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getTemplate(name, this.getString("input.encoding", "ISO-8859-1"));
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return (Template)this.resourceManager.getResource(name, 1, encoding);
    }

    public ContentResource getContent(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getContent(name, this.getString("input.encoding", "ISO-8859-1"));
    }

    public ContentResource getContent(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return (ContentResource)this.resourceManager.getResource(name, 2, encoding);
    }

    public String getLoaderNameForResource(String resourceName) {
        return this.resourceManager.getLoaderNameForResource(resourceName);
    }

    private final boolean showStackTrace() {
        if (this.configuration.isInitialized()) {
            return this.getBoolean("runtime.log.warn.stacktrace", false);
        }
        return false;
    }

    private final void log(int level, Object message) {
        String out;
        if (this.showStackTrace() && (message instanceof Throwable || message instanceof Exception)) {
            String string = StringUtils.stackTrace((Throwable)message);
        } else {
            out = message.toString();
        }
        this.logSystem.logVelocityMessage(level, out);
    }

    public void warn(Object message) {
        this.log(2, message);
    }

    public void info(Object message) {
        this.log(1, message);
    }

    public void error(Object message) {
        this.log(3, message);
    }

    public void debug(Object message) {
        this.log(0, message);
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public Directive getVelocimacro(String vmName, String templateName) {
        return this.vmFactory.getVelocimacro(vmName, templateName);
    }

    public boolean addVelocimacro(String name, String macro, String[] argArray, String sourceTemplate) {
        return this.vmFactory.addVelocimacro(name, macro, argArray, sourceTemplate);
    }

    public boolean isVelocimacro(String vmName, String templateName) {
        return this.vmFactory.isVelocimacro(vmName, templateName);
    }

    public boolean dumpVMNamespace(String namespace) {
        return this.vmFactory.dumpVMNamespace(namespace);
    }

    public String getString(String key) {
        return this.configuration.getString(key);
    }

    public int getInt(String key) {
        return this.configuration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean def) {
        return this.configuration.getBoolean(key, def);
    }

    public ExtendedProperties getConfiguration() {
        return this.configuration;
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public Object getApplicationAttribute(Object key) {
        return this.applicationAttributes.get(key);
    }

    public Object setApplicationAttribute(Object key, Object o) {
        return this.applicationAttributes.put(key, o);
    }

    public RuntimeInstance() {
        this.vmFactory = new VelocimacroFactory(this);
        this.introspector = new Introspector(this);
        this.applicationAttributes = new HashMap();
    }
}

