/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.internal.io.dav.IDAVSSLManager;
import org.tmatesoft.svn.util.DebugLog;

public class SocketFactory {
    public static Socket createPlainSocket(String host, int port) throws IOException {
        int attempts = 3;
        while (true) {
            try {
                return new Socket(SocketFactory.createAddres(host), port);
            }
            catch (ConnectException timeOut) {
                if (timeOut.getMessage().indexOf("time") >= 0) {
                    DebugLog.log("SOCKET: attempting to reconnect... (" + --attempts + ")");
                    if (attempts > 0) continue;
                    throw timeOut;
                }
                throw timeOut;
            }
            break;
        }
    }

    public static Socket createSSLSocket(IDAVSSLManager manager, String host, int port) throws IOException {
        int attempts = 3;
        while (true) {
            try {
                return manager.getSSLContext(host, port).getSocketFactory().createSocket(SocketFactory.createAddres(host), port);
            }
            catch (ConnectException timeOut) {
                if (timeOut.getMessage().indexOf("time") >= 0) {
                    DebugLog.log("SOCKET: attempting to reconnect... (" + --attempts + ")");
                    if (attempts > 0) continue;
                    throw timeOut;
                }
                throw timeOut;
            }
            break;
        }
    }

    public static Socket createSSLSocket(IDAVSSLManager manager, String host, int port, Socket socket) throws IOException {
        int attempts = 3;
        while (true) {
            try {
                return manager.getSSLContext(host, port).getSocketFactory().createSocket(socket, host, port, true);
            }
            catch (ConnectException timeOut) {
                if (timeOut.getMessage().indexOf("time") >= 0) {
                    DebugLog.log("SOCKET: attempting to reconnect... (" + --attempts + ")");
                    if (attempts > 0) continue;
                    throw timeOut;
                }
                throw timeOut;
            }
            break;
        }
    }

    private static InetAddress createAddres(String hostName) throws UnknownHostException {
        byte[] bytes = new byte[4];
        int index = 0;
        StringTokenizer tokens = new StringTokenizer(hostName, ".");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            try {
                byte b = (byte)Integer.parseInt(token);
                if (index < bytes.length) {
                    bytes[index] = b;
                    ++index;
                    continue;
                }
                bytes = null;
            }
            catch (NumberFormatException e) {
                bytes = null;
            }
            break;
        }
        if (bytes != null && index == 4) {
            return InetAddress.getByAddress(hostName, bytes);
        }
        return InetAddress.getByName(hostName);
    }
}

