/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.progress;

import java.util.Collection;
import java.util.Iterator;
import org.tmatesoft.svn.core.progress.ISVNProgressViewer;
import org.tmatesoft.svn.util.SVNAssert;

public final class SVNProgressViewerIterator
implements ISVNProgressViewer,
Iterator {
    private final Iterator iterator;
    private final ISVNProgressViewer viewer;
    private final int count;
    private int index = -1;

    public SVNProgressViewerIterator(Collection collection, ISVNProgressViewer viewer) {
        SVNAssert.assertNotNull(collection);
        SVNAssert.assertNotNull(viewer);
        this.iterator = collection.iterator();
        this.count = collection.size();
        this.viewer = viewer;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        ++this.index;
        this.setProgress(0.0);
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setProgress(double value) {
        SVNAssert.assertTrue(0.0 <= value && value <= 1.0);
        this.viewer.setProgress(((double)this.index + value) / (double)this.count);
    }
}

