/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.ISVNCredentialsProvider;
import org.tmatesoft.svn.core.io.ISVNSSHCredentials;
import org.tmatesoft.svn.util.DebugLog;

public class SVNSimpleCredentialsProvider
implements ISVNCredentialsProvider {
    private SimpleCredentials myCredentials;
    private boolean myIsFinished;

    public SVNSimpleCredentialsProvider(String userName, String password) {
        this(userName, password, null);
    }

    public SVNSimpleCredentialsProvider(String userName, String password, String privateKey) {
        this(userName, password, privateKey, null);
    }

    public SVNSimpleCredentialsProvider(String userName, String password, String privateKey, String passphrase) {
        this.myCredentials = new SimpleCredentials(userName, password, privateKey, passphrase);
    }

    public ISVNCredentials nextCredentials(String realm) {
        if (this.myIsFinished) {
            return null;
        }
        this.myIsFinished = true;
        return this.myCredentials;
    }

    public void accepted(ISVNCredentials credentials) {
    }

    public void notAccepted(ISVNCredentials credentials, String failureReason) {
    }

    public void reset() {
        this.myIsFinished = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SVNSimpleCredentialsProvider)) {
            return false;
        }
        SVNSimpleCredentialsProvider provider = (SVNSimpleCredentialsProvider)o;
        return this.myCredentials.equals(provider.myCredentials);
    }

    public int hashCode() {
        return this.myCredentials.hashCode();
    }

    public static class SimpleCredentials
    implements ISVNSSHCredentials {
        private String myPassword;
        private String myUserName;
        private String myPrivateKey;
        private String myPassphrase;

        public SimpleCredentials(String userName, String password, String privateKey, String passprhase) {
            this.myUserName = userName;
            this.myPassword = password;
            this.myPrivateKey = privateKey;
            this.myPassphrase = passprhase;
            if (this.myPrivateKey == null) {
                this.myPrivateKey = System.getProperty("javasvn.ssh2.key");
                if (this.myPrivateKey != null) {
                    DebugLog.log("using private key defined in javasvn.ssh2.key property: " + this.myPrivateKey);
                }
                if (this.myPassphrase == null) {
                    this.myPassphrase = System.getProperty("javasvn.ssh2.passphrase");
                }
            }
        }

        public String getName() {
            return this.myUserName;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public String getPrivateKeyID() {
            return this.myPrivateKey;
        }

        public String getPassphrase() {
            return this.myPassphrase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleCredentials)) {
                return false;
            }
            SimpleCredentials credentials = (SimpleCredentials)o;
            boolean equals = true;
            boolean bl = this.myUserName == null ? credentials.myUserName == null : (equals = this.myUserName.equals(credentials.myUserName));
            if (!equals) {
                return false;
            }
            boolean bl2 = this.myPassword == null ? credentials.myPassword == null : (equals = this.myPassword.equals(credentials.myPassword));
            if (!equals) {
                return false;
            }
            boolean bl3 = this.myPrivateKey == null ? credentials.myPrivateKey == null : (equals = this.myPrivateKey.equals(credentials.myPrivateKey));
            if (!equals) {
                return false;
            }
            return this.myPassphrase == null ? credentials.myPassphrase == null : this.myPassphrase.equals(credentials.myPassphrase);
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode += this.myUserName != null ? this.myUserName.hashCode() * 31 : 0;
            hashCode += this.myPassword != null ? this.myPassword.hashCode() * 31 : 0;
            hashCode += this.myPrivateKey != null ? this.myPrivateKey.hashCode() * 31 : 0;
            return hashCode += this.myPassphrase != null ? this.myPassphrase.hashCode() * 31 : 0;
        }
    }
}

