/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;

public abstract class SVNRepositoryFactory {
    private static final Map myFactoriesMap = new HashMap();

    protected static void registerRepositoryFactory(String protocol, SVNRepositoryFactory factory) {
        if (protocol != null && factory != null && !myFactoriesMap.containsKey(protocol)) {
            myFactoriesMap.put(protocol, factory);
        }
    }

    public static boolean canCreate(SVNRepositoryLocation location) {
        Iterator keys = myFactoriesMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!Pattern.matches(key, location.toString())) continue;
            return myFactoriesMap.get(key) instanceof SVNRepositoryFactory;
        }
        return false;
    }

    public static SVNRepository create(SVNRepositoryLocation location) throws SVNException {
        if (!SVNRepositoryFactory.canCreate(location)) {
            throw new SVNException("no connection protocol implementation for " + location.toString());
        }
        Iterator keys = myFactoriesMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!Pattern.matches(key, location.toString())) continue;
            return ((SVNRepositoryFactory)myFactoriesMap.get(key)).createRepositoryImpl(location);
        }
        return null;
    }

    public abstract SVNRepository createRepositoryImpl(SVNRepositoryLocation var1);
}

