/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLine;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLineReader;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceMedia;
import org.tmatesoft.svn.core.internal.ws.fs.FSMergerBySequenceList;

public class FSMergerBySequence {
    private final byte[] myConflictStart;
    private final byte[] myConflictSeparator;
    private final byte[] myConflictEnd;
    private final byte[] eolBytes;

    public FSMergerBySequence(byte[] conflictStart, byte[] conflictSeparator, byte[] conflictEnd, byte[] eolBytesArray) {
        this.myConflictStart = conflictStart;
        this.myConflictSeparator = conflictSeparator;
        this.myConflictEnd = conflictEnd;
        this.eolBytes = eolBytesArray;
    }

    public int merge(InputStream baseStream, InputStream localStream, InputStream latestStream, OutputStream result) throws IOException {
        SVNSequenceLineReader reader = new SVNSequenceLineReader(this.eolBytes);
        SVNSequenceLine[] baseLines = reader.read(baseStream);
        SVNSequenceLine[] localLines = reader.read(localStream);
        SVNSequenceLine[] latestLines = reader.read(latestStream);
        FSMergerBySequenceList local = new FSMergerBySequenceList(SVNSequenceMedia.createBlocks(baseLines, localLines));
        FSMergerBySequenceList latest = new FSMergerBySequenceList(SVNSequenceMedia.createBlocks(baseLines, latestLines));
        int baseLineIndex = -1;
        boolean conflict = false;
        boolean merged = false;
        while (local.hasCurrent() || latest.hasCurrent()) {
            if (local.hasCurrent() && latest.hasCurrent() && this.isEqualChange(local.current(), latest.current(), localLines, latestLines)) {
                baseLineIndex = this.appendLines(result, local.current(), localLines, baseLineIndex);
                local.forward();
                latest.forward();
                merged = true;
                continue;
            }
            if (local.hasCurrent() && latest.hasCurrent()) {
                QSequenceDifferenceBlock localStartBlock = local.current();
                QSequenceDifferenceBlock latestStartBlock = latest.current();
                if (this.checkConflict(local, latest, localLines, latestLines)) {
                    baseLineIndex = this.createConflict(result, localStartBlock, local.current(), latestStartBlock, latest.current(), baseLines, localLines, latestLines, baseLineIndex);
                    local.forward();
                    latest.forward();
                    conflict = true;
                    continue;
                }
            }
            if (local.hasCurrent() && this.isBefore(local.current(), latest.hasCurrent() ? latest.current() : null)) {
                baseLineIndex = this.appendLines(result, local.current(), localLines, baseLineIndex);
                local.forward();
                merged = true;
                continue;
            }
            if (!latest.hasCurrent()) continue;
            baseLineIndex = this.appendLines(result, latest.current(), latestLines, baseLineIndex);
            latest.forward();
            merged = true;
        }
        ++baseLineIndex;
        while (baseLineIndex < baseLines.length) {
            this.writeLine(result, baseLines[baseLineIndex]);
            ++baseLineIndex;
        }
        if (conflict) {
            return 2;
        }
        if (merged) {
            return 4;
        }
        return 0;
    }

    private boolean isBefore(QSequenceDifferenceBlock block1, QSequenceDifferenceBlock block2) {
        return block1 != null && (block2 == null || block1.getLeftTo() < block2.getLeftFrom());
    }

    private boolean intersect(QSequenceDifferenceBlock block1, QSequenceDifferenceBlock block2) {
        return block1.getLeftFrom() <= block2.getLeftTo() + 1 && block2.getLeftFrom() <= block1.getLeftTo() + 1;
    }

    private int appendLines(OutputStream result, QSequenceDifferenceBlock block, SVNSequenceLine[] changedLines, int baseLineIndex) throws IOException {
        for (int equalLineIndex = block.getRightFrom() - (block.getLeftFrom() - 1 - baseLineIndex); equalLineIndex < block.getRightFrom(); ++equalLineIndex) {
            this.writeLine(result, changedLines[equalLineIndex]);
        }
        for (int changedLineIndex = block.getRightFrom(); changedLineIndex <= block.getRightTo(); ++changedLineIndex) {
            this.writeLine(result, changedLines[changedLineIndex]);
        }
        return block.getLeftTo();
    }

    private boolean isEqualChange(QSequenceDifferenceBlock localBlock, QSequenceDifferenceBlock latestBlock, SVNSequenceLine[] localLines, SVNSequenceLine[] latestLines) {
        if (localBlock.getLeftTo() - localBlock.getLeftFrom() != latestBlock.getLeftTo() - latestBlock.getLeftFrom()) {
            return false;
        }
        if (localBlock.getRightTo() - localBlock.getRightFrom() != latestBlock.getRightTo() - latestBlock.getRightFrom()) {
            return false;
        }
        for (int index = 0; index < localBlock.getRightTo() - localBlock.getRightFrom() + 1; ++index) {
            SVNSequenceLine latestLine;
            SVNSequenceLine localLine = localLines[localBlock.getRightFrom() + index];
            if (localLine.equals(latestLine = latestLines[latestBlock.getRightFrom() + index])) continue;
            return false;
        }
        return true;
    }

    private boolean checkConflict(FSMergerBySequenceList localChanges, FSMergerBySequenceList latestChanges, SVNSequenceLine[] localLines, SVNSequenceLine[] latestLines) {
        boolean conflict = false;
        while (this.intersect(localChanges.current(), latestChanges.current()) && !this.isEqualChange(localChanges.current(), latestChanges.current(), localLines, latestLines)) {
            conflict = true;
            if (localChanges.current().getLeftTo() <= latestChanges.current().getLeftTo()) {
                if (!localChanges.hasNext() || !this.intersect(localChanges.peekNext(), latestChanges.current())) break;
                localChanges.forward();
                continue;
            }
            if (!latestChanges.hasNext() || !this.intersect(localChanges.current(), latestChanges.peekNext())) break;
            latestChanges.forward();
        }
        return conflict;
    }

    private int createConflict(OutputStream result, QSequenceDifferenceBlock localStart, QSequenceDifferenceBlock localEnd, QSequenceDifferenceBlock latestStart, QSequenceDifferenceBlock latestEnd, SVNSequenceLine[] baseLines, SVNSequenceLine[] localLines, SVNSequenceLine[] latestLines, int baseLineIndex) throws IOException {
        int index;
        int minBaseFrom = Math.min(localStart.getLeftFrom(), latestStart.getLeftFrom());
        int maxBaseTo = Math.max(localEnd.getLeftTo(), latestEnd.getLeftTo());
        ++baseLineIndex;
        while (baseLineIndex < minBaseFrom) {
            this.writeLine(result, baseLines[baseLineIndex]);
            ++baseLineIndex;
        }
        int localFrom = Math.max(0, localStart.getRightFrom() - (localStart.getLeftFrom() - minBaseFrom));
        int localTo = Math.min(localLines.length - 1, localEnd.getRightTo() + (maxBaseTo - localEnd.getLeftTo()));
        int latestFrom = Math.max(0, latestStart.getRightFrom() - (latestStart.getLeftFrom() - minBaseFrom));
        int latestTo = Math.min(latestLines.length - 1, latestEnd.getRightTo() + (maxBaseTo - latestEnd.getLeftTo()));
        this.writeBytesAndEol(result, this.myConflictStart);
        for (index = localFrom; index <= localTo; ++index) {
            this.writeLine(result, localLines[index]);
        }
        this.writeBytesAndEol(result, this.myConflictSeparator);
        for (index = latestFrom; index <= latestTo; ++index) {
            this.writeLine(result, latestLines[index]);
        }
        this.writeBytesAndEol(result, this.myConflictEnd);
        return maxBaseTo;
    }

    private void writeLine(OutputStream os, SVNSequenceLine line) throws IOException {
        byte[] bytes = line.getBytes();
        if (bytes.length == 0) {
            return;
        }
        os.write(bytes);
    }

    private void writeBytesAndEol(OutputStream os, byte[] bytes) throws IOException {
        if (bytes.length > 0) {
            os.write(bytes);
            os.write(this.eolBytes);
        }
    }
}

