/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNDirectoryContent;
import org.tmatesoft.svn.core.ISVNFileContent;
import org.tmatesoft.svn.core.internal.ws.fs.FSFileEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.SVNException;

public class FSFileEntryContent
implements ISVNFileContent {
    private final FSFileEntry myEntry;

    public String getName() {
        return this.myEntry.getName();
    }

    public String getPath() {
        return this.myEntry.getPath();
    }

    public boolean isDirectory() {
        return false;
    }

    public ISVNDirectoryContent asDirectory() {
        return null;
    }

    public ISVNFileContent asFile() {
        return this;
    }

    public FSFileEntryContent(FSFileEntry entry) {
        this.myEntry = entry;
    }

    public boolean hasWorkingCopyContent() {
        File file = this.myEntry.getRootEntry().getWorkingCopyFile(this.myEntry);
        return file != null && file.isFile();
    }

    public void getWorkingCopyContent(OutputStream os) throws SVNException {
        this.getWorkingCopyContent(os, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWorkingCopyContent(OutputStream os, String eol, boolean unexpandKeywords) throws SVNException {
        File file = this.myEntry.getRootEntry().getWorkingCopyFile(this.myEntry);
        if (file == null || !file.isFile()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                FSUtil.copy(is, os, this.myEntry.isBinary() ? null : eol, this.myEntry.isBinary() || !unexpandKeywords ? null : this.myEntry.computeKeywords(false), null);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            throw new SVNException(ex);
        }
    }

    public boolean hasBaseFileContent() throws SVNException {
        File file = this.myEntry.getAdminArea().getBaseFile(this.myEntry);
        return file != null && file.isFile();
    }

    public void getBaseFileContent(OutputStream os) throws SVNException {
        this.getBaseFileContent(os, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBaseFileContent(OutputStream os, String eol) throws SVNException {
        File file = this.myEntry.getAdminArea().getBaseFile(this.myEntry);
        if (file == null || !file.isFile()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                FSUtil.copy(is, os, this.myEntry.isBinary() ? null : eol, null);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            throw new SVNException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkingCopyContent(InputStream is) throws SVNException {
        File file = this.myEntry.getRootEntry().getWorkingCopyFile(this.myEntry);
        if (file != null && file.exists() && !file.isFile()) {
            throw new SVNException("Can't write to '" + file + "'.");
        }
        try {
            FileOutputStream os = new FileOutputStream(file);
            try {
                FSUtil.copy(is, os, null);
            }
            finally {
                os.close();
            }
        }
        catch (IOException ex) {
            throw new SVNException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkingCopyContent() throws SVNException {
        try {
            File file = this.myEntry.getRootEntry().getWorkingCopyFile(this.myEntry);
            if (file == null || !file.isFile()) {
                return;
            }
            boolean deleted = file.delete();
            if (!deleted) {
                throw new SVNException("Can't delete '" + file + "'.");
            }
        }
        finally {
            this.myEntry.dispose();
        }
    }
}

