/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.ISVNEntryContent;
import org.tmatesoft.svn.core.ISVNFileEntry;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.diff.delta.ISVNDeltaGenerator;
import org.tmatesoft.svn.core.diff.delta.SVNAllDeltaGenerator;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceDeltaGenerator;
import org.tmatesoft.svn.core.internal.ws.fs.FSAdminArea;
import org.tmatesoft.svn.core.internal.ws.fs.FSEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSFileEntryContent;
import org.tmatesoft.svn.core.internal.ws.fs.FSMerger;
import org.tmatesoft.svn.core.internal.ws.fs.FSRootEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.internal.ws.fs.SVNRAFileData;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.TimeUtil;

public class FSFileEntry
extends FSEntry
implements ISVNFileEntry {
    private Map myEntry;
    private File myTempFile;
    private boolean myIsCheckout;

    public FSFileEntry(FSAdminArea area, FSRootEntry root, String path, Map entryProperties) {
        super(area, root, path);
        this.myEntry = entryProperties;
    }

    public void setPropertyValue(String name, String value) throws SVNException {
        if ("svn:entry:uuid".equals(name)) {
            return;
        }
        super.setPropertyValue(name, value);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isObstructed() {
        return super.isObstructed() || this.getRootEntry().getWorkingCopyFile(this).isDirectory();
    }

    public void applyDelta(SVNDiffWindow window, InputStream newData, boolean overwrite) throws SVNException {
        if (overwrite) {
            SVNRAFileData contents = null;
            if (window == null) {
                try {
                    this.myTempFile = this.getRootEntry().createTemporaryFile(this);
                    this.myTempFile.createNewFile();
                }
                catch (IOException e) {
                    throw new SVNException(e);
                }
            } else {
                if (!this.isBinary() && "native".equals(this.getPropertyValue("svn:eol-style"))) {
                    if (this.myTempFile == null) {
                        this.myTempFile = this.getRootEntry().createTemporaryFile(this);
                    }
                    contents = new SVNRAFileData(this.myTempFile, false);
                } else {
                    contents = new SVNRAFileData(this.getRootEntry().getWorkingCopyFile(this), false);
                }
                window.apply(contents, contents, newData, contents.length());
            }
            return;
        }
        if (this.isScheduledForAddition()) {
            return;
        }
        if (window == null) {
            File newFile = this.getAdminArea().getTemporaryBaseFile(this);
            try {
                newFile.getParentFile().mkdirs();
                newFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SVNException(e);
            }
        } else if (this.myIsCheckout || !this.getAdminArea().getBaseFile(this).exists()) {
            SVNRAFileData source = new SVNRAFileData(this.getAdminArea().getBaseFile(this), false);
            long offset = 0L;
            if (this.getAdminArea().getBaseFile(this).exists()) {
                offset = this.getAdminArea().getBaseFile(this).length();
            }
            window.apply(source, source, newData, offset);
            this.myIsCheckout = true;
        } else {
            SVNRAFileData source = new SVNRAFileData(this.getAdminArea().getBaseFile(this), true);
            SVNRAFileData target = new SVNRAFileData(this.getAdminArea().getTemporaryBaseFile(this), false);
            long offset = 0L;
            if (this.getAdminArea().getTemporaryBaseFile(this).exists()) {
                offset = this.getAdminArea().getTemporaryBaseFile(this).length();
            }
            window.apply(source, target, newData, offset);
        }
    }

    public int deltaApplied(boolean overwrite) throws SVNException {
        if (this.myIsCheckout) {
            this.myIsCheckout = false;
            return 16;
        }
        if (!overwrite && this.isContentsModified()) {
            return this.getRootEntry().getMerger().pretendMergeFiles(this.getAdminArea().getBaseFile(this), this.getRootEntry().getWorkingCopyFile(this), this.getAdminArea().getTemporaryBaseFile(this));
        }
        if (overwrite) {
            String date;
            File dst = this.getRootEntry().getWorkingCopyFile(this);
            if (this.myTempFile != null) {
                FSUtil.copy(this.myTempFile, dst, this.isBinary() ? null : "native", null);
                this.myTempFile.delete();
                this.myTempFile = null;
            }
            if (this.getRootEntry().isUseCommitTimes() && (date = this.getPropertyValue("svn:entry:committed-date")) != null) {
                long lm = TimeUtil.parseDate(date).getTime();
                dst.setLastModified(lm);
            }
        }
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDelta(ISVNEditor target) throws SVNException {
        if (!this.isContentsModified() && !this.isScheduledForAddition()) {
            return null;
        }
        String digest = null;
        File file = this.getRootEntry().getWorkingCopyFile(this);
        if (file.exists()) {
            target.applyTextDelta(null);
            String eolType = this.getPropertyValue("svn:eol-style");
            boolean sendAsIs = this.isBinary();
            File tmpFile = null;
            if (!sendAsIs) {
                if ("native".equals(eolType)) {
                    eolType = "LF";
                }
                tmpFile = this.getRootEntry().createTemporaryFile(this);
                Map keywords = this.computeKeywords(false);
                FSUtil.copy(file, tmpFile, eolType, keywords, null);
            }
            ISVNDeltaGenerator generator = this.isBinary() || this.isScheduledForAddition() || DebugLog.isGeneratorDisabled() || !this.getAdminArea().hasBaseFile(this) ? new SVNAllDeltaGenerator() : new SVNSequenceDeltaGenerator();
            File digestFile = this.getRootEntry().createTemporaryFile(this);
            digest = FSUtil.copy(tmpFile != null ? tmpFile : file, digestFile, null, null, FSFileEntry.createDigest());
            SVNRAFileData workFile = new SVNRAFileData(tmpFile != null ? tmpFile : file, true);
            SVNRAFileData baseFile = generator instanceof SVNSequenceDeltaGenerator ? new SVNRAFileData(this.getAdminArea().getBaseFile(this), true) : null;
            try {
                generator.generateDiffWindow(target, workFile, baseFile);
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (baseFile != null) {
                        baseFile.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    workFile.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                if (digestFile != null) {
                    digestFile.delete();
                }
                throw throwable;
            }
            try {
                if (baseFile != null) {
                    baseFile.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                workFile.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
            if (digestFile != null) {
                digestFile.delete();
            }
        }
        return digest;
    }

    public boolean isContentsModified() throws SVNException {
        long time;
        if (this.isPropertyModified("svn:eol-style")) {
            return true;
        }
        if (this.isMissing() || this.isScheduledForDeletion()) {
            return false;
        }
        File file = this.getRootEntry().getWorkingCopyFile(this);
        String timeStamp = (String)this.getEntry().get("svn:entry:text-time");
        if (timeStamp != null && (time = TimeUtil.parseDate(timeStamp).getTime()) != file.lastModified()) {
            return this.isContentsDifferent();
        }
        return false;
    }

    public ISVNEntryContent getContent() throws SVNException {
        return new FSFileEntryContent(this);
    }

    private boolean isContentsDifferent() throws SVNException {
        File file = this.getRootEntry().getWorkingCopyFile(this);
        File baseFile = this.getAdminArea().getBaseFile(this);
        if (!baseFile.exists()) {
            return false;
        }
        File tmpFile = null;
        try {
            if (!this.isBinary() && this.getPropertyValue("svn:keywords") != null) {
                tmpFile = this.getRootEntry().createTemporaryFile(this);
                Map keywords = this.computeKeywords(false);
                FSUtil.copy(file, tmpFile, null, keywords, null);
            }
            boolean keywords = !FSUtil.compareFiles(baseFile, tmpFile == null ? file : tmpFile, this.isBinary());
            return keywords;
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public boolean isCorrupted() throws SVNException {
        File baseFile = this.getAdminArea().getBaseFile(this);
        if (this.getPropertyValue("svn:entry:checksum") == null) {
            return false;
        }
        if (!baseFile.exists() && this.isScheduledForAddition()) {
            return false;
        }
        String checksum = FSUtil.getChecksum(baseFile, FSFileEntry.createDigest());
        return checksum == null || !checksum.equals(this.getPropertyValue("svn:entry:checksum"));
    }

    public void commit() throws SVNException {
        super.commit();
        File actualFile = this.getRootEntry().getWorkingCopyFile(this);
        File baseFile = this.getAdminArea().getBaseFile(this);
        String checksum = null;
        Map keywords = this.computeKeywords(true);
        if (actualFile.exists()) {
            boolean storeAsIs;
            String eolStyle = this.getPropertyValue("svn:eol-style");
            if (!this.isBinary()) {
                File tmpFile = this.getRootEntry().createTemporaryFile(this);
                FSUtil.copy(actualFile, tmpFile, eolStyle, this.computeKeywords(false), null);
                FSUtil.copy(tmpFile, actualFile, null, keywords, null);
                tmpFile.delete();
            }
            boolean bl = storeAsIs = this.isBinary() || eolStyle == null;
            if ("native".equals(eolStyle)) {
                eolStyle = "LF";
            }
            checksum = FSUtil.copy(actualFile, baseFile, storeAsIs ? null : eolStyle, this.isBinary() ? null : this.computeKeywords(false), FSFileEntry.createDigest());
            if (!this.getRootEntry().isUseCommitTimes()) {
                Date date = new Date(actualFile.lastModified());
                this.getEntry().put("svn:entry:text-time", TimeUtil.formatDate(date));
            } else {
                String date = this.getPropertyValue("svn:entry:committed-date");
                this.getEntry().put("svn:entry:text-time", date);
                actualFile.setLastModified(TimeUtil.parseDate(date).getTime());
            }
        } else {
            baseFile.delete();
            this.getEntry().remove("svn:entry:text-time");
        }
        if (checksum == null) {
            this.getEntry().remove("svn:entry:checksum");
        } else {
            this.getEntry().put("svn:entry:checksum", checksum);
        }
    }

    public void merge(boolean recursive) throws SVNException {
        if (this.isScheduledForAddition()) {
            return;
        }
        boolean isNewKeywords = this.isPropertyModified("svn:keywords");
        super.merge();
        File basePropsFile = this.getAdminArea().getBasePropertiesFile(this);
        if (!basePropsFile.exists()) {
            this.getAdminArea().saveBaseProperties(this, Collections.EMPTY_MAP);
            this.getAdminArea().saveProperties(this, Collections.EMPTY_MAP);
            long lastModified = this.getAdminArea().propertiesLastModified(this);
            if (lastModified != 0L) {
                this.getEntry().put("svn:entry:prop-time", TimeUtil.formatDate(new Date(lastModified)));
            } else {
                this.getEntry().remove("svn:entry:prop-time");
            }
        }
        File tmpBaseFile = this.getAdminArea().getTemporaryBaseFile(this);
        File actualFile = this.getRootEntry().getWorkingCopyFile(this);
        File baseFile = this.getAdminArea().getBaseFile(this);
        Map keywords = this.computeKeywords(true);
        if (!tmpBaseFile.exists() && !this.isScheduledForDeletion()) {
            if (baseFile.exists() && (!actualFile.exists() || isNewKeywords)) {
                FSUtil.copy(baseFile, actualFile, !this.isBinary() ? this.getPropertyValue("svn:eol-style") : null, this.isBinary() ? null : keywords, null);
                this.updateTextTime(actualFile);
            }
            return;
        }
        String checksum = null;
        if (this.isScheduledForDeletion()) {
            DebugLog.log("merging deleted file: " + this.getPath());
            DebugLog.log("tmpBaseFile: " + tmpBaseFile.getAbsolutePath());
            DebugLog.log("tmpBaseFile.exists(): " + tmpBaseFile.exists());
            if (tmpBaseFile.exists()) {
                checksum = FSUtil.copy(tmpBaseFile, baseFile, null, FSFileEntry.createDigest());
                DebugLog.log("deleted file merged: " + this.getPath());
            }
        } else if (!this.isContentsModified()) {
            String eolStyle = this.isBinary() ? null : this.getPropertyValue("svn:eol-style");
            checksum = FSUtil.copy(tmpBaseFile, baseFile, null, FSFileEntry.createDigest());
            FSUtil.copy(baseFile, actualFile, this.isBinary() ? null : eolStyle, this.isBinary() ? null : keywords, null);
            this.updateTextTime(actualFile);
        } else {
            int mergeResult = 2;
            File localFile = null;
            if (!this.isBinary()) {
                FSMerger merger = this.getRootEntry().getMerger();
                File remote = this.getAdminArea().getTemporaryBaseFile(this);
                File base = this.getAdminArea().getBaseFile(this);
                localFile = this.getRootEntry().createTemporaryFile(this);
                File result = this.getRootEntry().createTemporaryFile(this);
                FSUtil.copy(this.getRootEntry().getWorkingCopyFile(this), localFile, null, this.computeKeywords(false), null);
                mergeResult = merger.mergeFiles(base, localFile, remote, result, ".mine", ".r" + this.getPropertyValue("svn:entry:committed-rev"));
                localFile.delete();
                localFile = result;
            }
            if (mergeResult == 2) {
                File newRevFile = new File(this.getRootEntry().getWorkingCopyFile(this).getParentFile(), this.getName() + ".r" + this.getPropertyValue("svn:entry:committed-rev"));
                File oldRevFile = new File(this.getRootEntry().getWorkingCopyFile(this).getParentFile(), this.getName() + ".r" + this.getOldRevision());
                FSUtil.copy(this.getAdminArea().getTemporaryBaseFile(this), newRevFile, null, null, null);
                FSUtil.copy(this.getAdminArea().getBaseFile(this), oldRevFile, null, null, null);
                this.setPropertyValue("svn:entry:conflict-old", oldRevFile.getName());
                this.setPropertyValue("svn:entry:conflict-new", newRevFile.getName());
                if (!this.isBinary()) {
                    File mineFile = new File(this.getRootEntry().getWorkingCopyFile(this).getParentFile(), this.getName() + ".mine");
                    FSUtil.copy(this.getRootEntry().getWorkingCopyFile(this), mineFile, null, null, null);
                    this.setPropertyValue("svn:entry:conflict-wrk", mineFile.getName());
                }
            }
            if (localFile != null) {
                keywords = this.computeKeywords(true);
                String eolStyle = this.getPropertyValue("svn:eol-style");
                FSUtil.copy(localFile, this.getRootEntry().getWorkingCopyFile(this), eolStyle, keywords, null);
                localFile.delete();
            }
            checksum = FSUtil.copy(this.getAdminArea().getTemporaryBaseFile(this), this.getAdminArea().getBaseFile(this), null, null, FSFileEntry.createDigest());
        }
        if (this.getPropertyValue("svn:entry:checksum") == null) {
            this.setPropertyValue("svn:entry:checksum", checksum);
        } else if (checksum != null && !checksum.equals(this.getPropertyValue("svn:entry:checksum"))) {
            throw new SVNException(this.getPath() + " local checksum differs from repository.");
        }
        this.getAdminArea().deleteTemporaryBaseFile(this);
    }

    private void updateTextTime(File file) throws SVNException {
        String commitDate;
        long lastModified = file.lastModified();
        if (this.getRootEntry().isUseCommitTimes() && (commitDate = this.getPropertyValue("svn:entry:committed-date")) != null) {
            lastModified = TimeUtil.parseDate(commitDate).getTime();
            file.setLastModified(lastModified);
        }
        this.getEntry().put("svn:entry:text-time", TimeUtil.formatDate(new Date(lastModified)));
    }

    public boolean isConflict() throws SVNException {
        if (super.isConflict()) {
            return true;
        }
        return this.getPropertyValue("svn:entry:conflict-old") != null || this.getPropertyValue("svn:entry:conflict-new") != null || this.getPropertyValue("svn:entry:conflict-new") != null;
    }

    public void markResolved() throws SVNException {
        this.markResolved(false);
    }

    public void markResolved(boolean contentsOnly) throws SVNException {
        if (!contentsOnly) {
            super.markResolved();
        }
        String oldFileName = this.getPropertyValue("svn:entry:conflict-old");
        String newFileName = this.getPropertyValue("svn:entry:conflict-new");
        String wrkFileName = this.getPropertyValue("svn:entry:conflict-wrk");
        this.setPropertyValue("svn:entry:conflict-new", null);
        this.setPropertyValue("svn:entry:conflict-old", null);
        this.setPropertyValue("svn:entry:conflict-wrk", null);
        File folder = this.getRootEntry().getWorkingCopyFile(this).getParentFile();
        if (oldFileName != null) {
            new File(folder, oldFileName).delete();
        }
        if (newFileName != null) {
            new File(folder, newFileName).delete();
        }
        if (wrkFileName != null) {
            new File(folder, wrkFileName).delete();
        }
    }

    public void restoreContents() throws SVNException {
        this.restoreProperties();
        File base = this.getAdminArea().getBaseFile(this);
        File local = this.getRootEntry().getWorkingCopyFile(this);
        if (base.exists()) {
            FSUtil.copy(base, local, this.isBinary() ? null : this.getPropertyValue("svn:eol-style"), this.isBinary() ? null : this.computeKeywords(true), null);
            this.updateTextTime(local);
        } else {
            local.delete();
        }
    }

    public ISVNFileEntry asFile() {
        return this;
    }

    public ISVNDirectoryEntry asDirectory() {
        return null;
    }

    protected Map getEntry() {
        return this.myEntry;
    }

    protected boolean isBinary() throws SVNException {
        String type = this.getPropertyValue("svn:mime-type");
        return type != null && !type.startsWith("text/");
    }

    static MessageDigest createDigest() throws SVNException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SVNException(e);
        }
    }

    public Map computeKeywords(boolean expand) throws SVNException {
        String keywordsProperty = this.getPropertyValue("svn:keywords");
        if (keywordsProperty == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(keywordsProperty, " ");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("LastChangedDate".equals(token) || "Date".equals(token)) {
                String dateStr = this.getPropertyValue("svn:entry:committed-date");
                dateStr = TimeUtil.toHumanDate(dateStr);
                map.put("LastChangedDate", expand ? dateStr : null);
                map.put("Date", expand ? dateStr : null);
                continue;
            }
            if ("LastChangedRevision".equals(token) || "Revision".equals(token) || "Rev".equals(token)) {
                String revStr = this.getPropertyValue("svn:entry:committed-rev");
                map.put("LastChangedRevision", expand ? revStr : null);
                map.put("Revision", expand ? revStr : null);
                map.put("Rev", expand ? revStr : null);
                continue;
            }
            if ("LastChangedBy".equals(token) || "Author".equals(token)) {
                String author = this.getPropertyValue("svn:entry:last-author");
                author = author == null ? "" : author;
                map.put("LastChangedBy", expand ? author : null);
                map.put("Author", expand ? author : null);
                continue;
            }
            if ("HeadURL".equals(token) || "URL".equals(token)) {
                String url = this.getPropertyValue("svn:entry:url");
                map.put("HeadURL", expand ? url : null);
                map.put("URL", expand ? url : null);
                continue;
            }
            if (!"Id".equals(token)) continue;
            StringBuffer id = new StringBuffer();
            id.append(this.getName());
            id.append(' ');
            id.append(this.getPropertyValue("svn:entry:committed-rev"));
            id.append(' ');
            String dateStr = this.getPropertyValue("svn:entry:committed-date");
            dateStr = TimeUtil.toHumanDate(dateStr);
            id.append(dateStr);
            id.append(' ');
            String author = this.getPropertyValue("svn:entry:last-author");
            author = author == null ? "" : author;
            id.append(author);
            map.put("Id", expand ? id.toString() : null);
        }
        return map;
    }
}

