/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.ws.fs.FSAdminArea;
import org.tmatesoft.svn.core.internal.ws.fs.FSRootEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.TimeUtil;

public abstract class FSEntry
implements ISVNEntry {
    private String myPath;
    private String myName;
    private Map myProperties;
    private Map myWCProperties;
    private Map myBaseProperties;
    private Set myModifiedProperties;
    private FSAdminArea myAdminArea;
    private FSRootEntry myRootEntry;
    private boolean myIsManaged;
    private long myOldRevision;
    public static final String WC_PREFIX = "svn:wc:";
    public static final String ENTRY_PREFIX = "svn:entry:";
    private String myAlias;

    public FSEntry(FSAdminArea adminArea, FSRootEntry entry, String path) {
        this.setManaged(true);
        this.myAdminArea = adminArea;
        this.myPath = path;
        if (this.myPath.startsWith("/")) {
            this.myPath = this.myPath.substring(1);
        }
        this.myRootEntry = entry;
    }

    public boolean isManaged() {
        return this.myIsManaged;
    }

    protected void setManaged(boolean managed) {
        this.myIsManaged = managed;
    }

    public boolean isMissing() throws SVNException {
        File file = this.getRootEntry().getWorkingCopyFile(this);
        return !FSUtil.isFileOrSymlinkExists(file) && !this.isScheduledForDeletion();
    }

    public String getPath() {
        return this.myPath;
    }

    public String getName() {
        if (this.myName == null) {
            this.myName = PathUtil.tail(this.getPath());
        }
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
        this.myPath = PathUtil.append(PathUtil.removeTail(this.myPath), name);
        this.myPath = PathUtil.removeLeadingSlash(this.myPath);
    }

    public String getPropertyValue(String name) throws SVNException {
        if (name.startsWith(ENTRY_PREFIX)) {
            return (String)this.getEntry().get(name);
        }
        if (name.startsWith(WC_PREFIX)) {
            if (this.myWCProperties == null) {
                this.myWCProperties = this.getAdminArea().loadWCProperties(this);
            }
            return (String)this.myWCProperties.get(name);
        }
        if (this.myProperties == null) {
            this.myProperties = this.getAdminArea().loadProperties(this);
        }
        return (String)this.myProperties.get(name);
    }

    public Iterator propertyNames() throws SVNException {
        if (this.myProperties == null) {
            this.myProperties = this.getAdminArea().loadProperties(this);
        }
        HashSet names = new HashSet(this.myProperties.keySet());
        names.addAll(this.getEntry().keySet());
        return names.iterator();
    }

    public void setPropertyValue(String name, String value) throws SVNException {
        if (name.startsWith(ENTRY_PREFIX)) {
            if (value == null) {
                this.getEntry().remove(name);
            } else {
                this.getEntry().put(name, value);
            }
        } else if (name.startsWith(WC_PREFIX)) {
            if (this.myWCProperties == null) {
                this.myWCProperties = this.getAdminArea().loadWCProperties(this);
            }
            if (value != null) {
                this.myWCProperties.put(name, value);
            } else {
                this.myWCProperties.remove(name);
            }
        } else {
            if (this.myProperties == null) {
                this.myProperties = this.getAdminArea().loadProperties(this);
            }
            if (value != null) {
                value = FSEntry.normalizePropertyValue(name, value);
                this.myProperties.put(name, value);
            } else {
                this.myProperties.remove(name);
            }
        }
    }

    void initProperties() throws SVNException {
        this.myProperties = this.getAdminArea().loadProperties(this);
        this.myBaseProperties = this.getAdminArea().loadBaseProperties(this);
    }

    public boolean isScheduledForAddition() throws SVNException {
        return "add".equals(this.getEntry().get("svn:entry:schedule")) || "replace".equals(this.getEntry().get("svn:entry:schedule"));
    }

    public boolean isScheduledForDeletion() throws SVNException {
        return "delete".equals(this.getEntry().get("svn:entry:schedule")) || "replace".equals(this.getEntry().get("svn:entry:schedule"));
    }

    public boolean isModified() throws SVNException {
        return this.isScheduledForAddition() || this.isScheduledForDeletion() || this.isPropertiesModified();
    }

    public int applyChangedProperties(Map changedProperties) throws SVNException {
        if (this.isScheduledForAddition()) {
            return 10;
        }
        this.setOldRevision(SVNProperty.longValue(this.getPropertyValue("svn:entry:committed-rev")));
        if (changedProperties.isEmpty()) {
            return 0;
        }
        if (this.myBaseProperties == null) {
            this.myBaseProperties = this.getAdminArea().loadBaseProperties(this);
        }
        if (this.myProperties == null) {
            this.myProperties = this.getAdminArea().loadProperties(this);
        }
        if (this.myModifiedProperties == null) {
            this.myModifiedProperties = new HashSet();
        }
        HashMap latestProperties = new HashMap(this.myBaseProperties);
        Iterator entries = changedProperties.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String name = (String)entry.getKey();
            if (name.startsWith(ENTRY_PREFIX) || name.startsWith(WC_PREFIX)) {
                this.setPropertyValue(name, (String)entry.getValue());
                continue;
            }
            latestProperties.put(name, entry.getValue());
            this.myModifiedProperties.add(name);
        }
        this.getAdminArea().saveTemporaryProperties(this, latestProperties);
        if (this.isPropertiesModified()) {
            Iterator localEntries = this.myProperties.entrySet().iterator();
            while (localEntries.hasNext()) {
                Map.Entry localEntry = localEntries.next();
                if (this.myBaseProperties.entrySet().contains(localEntry) || !latestProperties.containsKey(localEntry.getKey())) continue;
                Object newValue = latestProperties.get(localEntry.getKey());
                Object localValue = localEntry.getValue();
                if (newValue == null && localValue == newValue || newValue != null && newValue.equals(localValue)) continue;
                return 2;
            }
            return 4;
        }
        return this.myModifiedProperties.isEmpty() ? 0 : 16;
    }

    public boolean sendChangedProperties(ISVNEditor editor) throws SVNException {
        String key;
        if (this.myBaseProperties == null) {
            this.myBaseProperties = this.getAdminArea().loadBaseProperties(this);
        }
        if (this.myProperties == null) {
            this.myProperties = this.getAdminArea().loadProperties(this);
        }
        if (this.myModifiedProperties == null) {
            this.myModifiedProperties = new HashSet();
        }
        Iterator keys = this.myProperties.keySet().iterator();
        while (keys.hasNext()) {
            key = (String)keys.next();
            Object newValue = this.myProperties.get(key);
            Object oldValue = this.myBaseProperties.get(key);
            if (oldValue != null && oldValue.equals(newValue)) continue;
            this.myModifiedProperties.add(key);
            if (this.isDirectory()) {
                editor.changeDirProperty(key, (String)newValue);
                continue;
            }
            editor.changeFileProperty(key, (String)newValue);
        }
        keys = this.myBaseProperties.keySet().iterator();
        while (keys.hasNext()) {
            key = (String)keys.next();
            if (this.myProperties.containsKey(key)) continue;
            if (this.isDirectory()) {
                editor.changeDirProperty(key, null);
            } else {
                editor.changeFileProperty(key, null);
            }
            this.myModifiedProperties.add(key);
        }
        return !this.myModifiedProperties.isEmpty();
    }

    public void save() throws SVNException {
        this.save(true);
    }

    public void save(boolean recursive) throws SVNException {
        this.getAdminArea().saveProperties(this, this.myProperties);
        this.getAdminArea().saveBaseProperties(this, this.myBaseProperties);
        this.getAdminArea().saveWCProperties(this, this.myWCProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void merge() throws SVNException {
        this.getAdminArea().saveWCProperties(this, this.myWCProperties);
        if (!this.getAdminArea().getTemporaryPropertiesFile(this).exists()) {
            return;
        }
        Map latestProperties = this.getAdminArea().loadTemporaryProperties(this);
        this.getAdminArea().saveBaseProperties(this, latestProperties);
        if (!this.isPropertiesModified()) {
            this.getAdminArea().saveProperties(this, latestProperties);
            long lastModified = this.getAdminArea().propertiesLastModified(this);
            if (lastModified != 0L) {
                this.getEntry().put("svn:entry:prop-time", TimeUtil.formatDate(new Date(lastModified)));
            } else {
                this.getEntry().remove("svn:entry:prop-time");
            }
            if (this.myProperties != null) {
                this.myProperties = latestProperties;
            }
            if (this.myBaseProperties != null) {
                this.myBaseProperties = latestProperties;
            }
        } else {
            if (this.myProperties == null) {
                this.myProperties = this.getAdminArea().loadProperties(this);
            }
            if (this.myBaseProperties == null) {
                this.myBaseProperties = this.getAdminArea().loadBaseProperties(this);
            }
            HashSet<String> conflict = new HashSet<String>();
            Iterator entries = latestProperties.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String localValue = (String)this.myProperties.get(entry.getKey());
                String newValue = (String)entry.getValue();
                if (localValue == null) {
                    this.myProperties.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (newValue == null && localValue != null || newValue != null && !newValue.equals(localValue) || localValue != null && !localValue.equals(newValue)) {
                    if (newValue != null) {
                        conflict.add("Property '" + entry.getKey() + "' locally changed to '" + this.myProperties.get(entry.getKey()) + "', but update sets it to '" + entry.getValue() + "'\n");
                        continue;
                    }
                    conflict.add("Property '" + entry.getKey() + "' locally changed to '" + this.myProperties.get(entry.getKey()) + "', but update deletes it\n");
                    continue;
                }
                this.myProperties.put(entry.getKey(), entry.getValue());
            }
            if (!conflict.isEmpty()) {
                File prej;
                block23: {
                    File parent = this.getRootEntry().getWorkingCopyFile(this);
                    if (!parent.isDirectory()) {
                        parent = parent.getParentFile();
                    }
                    prej = new File(parent, this.isDirectory() ? "dir_conflicts.prej" : this.getName() + ".prej");
                    FileOutputStream os = null;
                    try {
                        try {
                            os = new FileOutputStream(prej, true);
                            Iterator lines = conflict.iterator();
                            while (lines.hasNext()) {
                                String line = (String)lines.next();
                                ((OutputStream)os).write(line.getBytes());
                            }
                            Object var9_10 = null;
                            if (os == null) break block23;
                        }
                        catch (IOException e) {
                            throw new SVNException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (os == null) throw throwable;
                        try {
                            ((OutputStream)os).close();
                            throw throwable;
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e1) {}
                    ((OutputStream)os).close();
                }
                this.setPropertyValue("svn:entry:prop-reject-file", prej.getName());
            }
            this.getAdminArea().saveProperties(this, this.myProperties);
        }
        this.getAdminArea().deleteTemporaryProperties(this);
        this.myModifiedProperties = null;
    }

    public void commit() throws SVNException {
        if (this.myProperties == null) {
            this.myProperties = this.getAdminArea().loadProperties(this);
        }
        this.getAdminArea().saveProperties(this, this.myProperties);
        this.getAdminArea().saveBaseProperties(this, this.myProperties);
        long lastModified = this.getAdminArea().propertiesLastModified(this);
        if (lastModified != 0L) {
            this.getEntry().put("svn:entry:prop-time", TimeUtil.formatDate(new Date(lastModified)));
        } else {
            this.getEntry().remove("svn:entry:prop-time");
        }
        this.getAdminArea().saveWCProperties(this, this.myWCProperties);
    }

    public boolean isConflict() throws SVNException {
        return this.getPropertyValue("svn:entry:prop-reject-file") != null;
    }

    public void markResolved() throws SVNException {
        String fileName = this.getPropertyValue("svn:entry:prop-reject-file");
        if (fileName == null) {
            return;
        }
        File file = this.getRootEntry().getWorkingCopyFile(this);
        if (file.isDirectory()) {
            new File(file, fileName).delete();
        } else {
            new File(file.getParentFile(), fileName).delete();
        }
        this.setPropertyValue("svn:entry:prop-reject-file", null);
    }

    protected void revertProperties() throws SVNException {
        File base = this.getAdminArea().getBasePropertiesFile(this);
        File local = this.getAdminArea().getPropertiesFile(this);
        if (base.exists()) {
            FSUtil.copy(base, local, null, null, null);
            long lm = local.lastModified();
            this.setPropertyValue("svn:entry:prop-time", TimeUtil.formatDate(new Date(lm)));
        } else {
            local.delete();
        }
        if (this.myProperties != null) {
            this.myProperties = this.getAdminArea().loadProperties(this);
        }
    }

    protected void restoreProperties() throws SVNException {
        File base = this.getAdminArea().getBasePropertiesFile(this);
        File local = this.getAdminArea().getPropertiesFile(this);
        if (!local.exists() && base.exists()) {
            FSUtil.copy(base, local, null, null, null);
            long lm = local.lastModified();
            this.setPropertyValue("svn:entry:prop-time", TimeUtil.formatDate(new Date(lm)));
        }
    }

    public void dispose() throws SVNException {
        this.myModifiedProperties = null;
        this.myProperties = null;
        this.myWCProperties = null;
        this.myBaseProperties = null;
        this.myAlias = null;
    }

    protected boolean isPropertyModified(String name) {
        return this.myModifiedProperties != null && this.myModifiedProperties.contains(name);
    }

    public boolean isPropertiesModified() throws SVNException {
        String savedTimeStr;
        long savedTime;
        if (this.myProperties != null) {
            if (this.myBaseProperties == null) {
                this.myBaseProperties = this.getAdminArea().loadBaseProperties(this);
            }
            return !((Object)this.myProperties).equals(this.myBaseProperties);
        }
        long timeStamp = this.getAdminArea().propertiesLastModified(this);
        if (timeStamp != (savedTime = TimeUtil.parseDate(savedTimeStr = (String)this.getEntry().get("svn:entry:prop-time")).getTime())) {
            Map props;
            Map bProps = this.getAdminArea().loadBaseProperties(this);
            return !((Object)bProps).equals(props = this.getAdminArea().loadProperties(this));
        }
        return false;
    }

    public boolean isObstructed() {
        File wcFile = this.getRootEntry().getWorkingCopyFile(this);
        if (FSUtil.isWindows) {
            String name = null;
            try {
                name = wcFile.getCanonicalFile().getName();
            }
            catch (IOException e) {
                return false;
            }
            return !this.getName().equals(name) && this.getName().equalsIgnoreCase(name);
        }
        return FSUtil.isSymlink(wcFile);
    }

    protected FSAdminArea getAdminArea() {
        return this.myAdminArea;
    }

    protected FSRootEntry getRootEntry() {
        return this.myRootEntry;
    }

    protected void setOldRevision(long rev) {
        this.myOldRevision = rev;
    }

    protected long getOldRevision() {
        return this.myOldRevision;
    }

    private static String normalizePropertyValue(String name, String value) {
        if (value == null) {
            return null;
        }
        if (name.startsWith("svn:")) {
            value = FSEntry.convertEolsToNative(value);
        }
        if ("svn:executable".equals(name)) {
            return "*";
        }
        if ("svn:ignore".equals(name) || "svn:externals".equals(name)) {
            value = value.trim();
            value = value + System.getProperty("line.separator");
            return value;
        }
        if ("svn:eol-style".equals(name)) {
            return value.trim();
        }
        if ("svn:keywords".equals(name)) {
            return value.trim();
        }
        if ("svn:mime-type".equals(name)) {
            return value.trim();
        }
        return value;
    }

    private static String convertEolsToNative(String value) {
        StringBuffer realValue = new StringBuffer(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\n') {
                realValue.append(System.getProperty("line.separator"));
                continue;
            }
            if (ch == '\r') {
                if (i + 1 >= value.length() || value.charAt(i + 1) == '\n') continue;
                realValue.append(System.getProperty("line.separator"));
                continue;
            }
            realValue.append(ch);
        }
        return realValue.toString();
    }

    public String getAlias() {
        return this.myAlias;
    }

    public void setAlias(String alias) {
        this.myAlias = alias;
    }

    protected abstract Map getEntry() throws SVNException;
}

