/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNEntryContent;
import org.tmatesoft.svn.core.ISVNFileEntry;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.diff.SVNDiffWindowBuilder;
import org.tmatesoft.svn.core.internal.ws.fs.FSAdminArea;
import org.tmatesoft.svn.core.internal.ws.fs.FSDirEntryContent;
import org.tmatesoft.svn.core.internal.ws.fs.FSEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSFileEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSRootEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.FileTypeUtil;
import org.tmatesoft.svn.util.PathUtil;

public class FSDirEntry
extends FSEntry
implements ISVNDirectoryEntry {
    private Map myChildEntries;
    private Map myDeletedEntries;
    private Map myChildren;
    private Map myDirEntry;
    private Map myUnmanagedChildren;
    private Map myAllUnmanagedChildren;

    public FSDirEntry(FSAdminArea area, FSRootEntry root, String path, String location) {
        super(area, root, path);
        if (location != null && !this.getAdminArea().getAdminArea(this).exists()) {
            try {
                this.setPropertyValue("svn:entry:url", location);
            }
            catch (SVNException e) {
                DebugLog.error(e);
            }
        }
    }

    public ISVNEntry getChild(String name) throws SVNException {
        this.loadEntries();
        return (ISVNEntry)this.myChildren.get(name);
    }

    public void rename(String oldName, String newName) throws SVNException {
        this.loadEntries();
        Object info = this.myChildEntries.remove(oldName);
        this.myChildEntries.put(newName, info);
        Object child = this.myChildren.remove(oldName);
        this.myChildren.put(newName, child);
        ((FSEntry)child).setName(newName);
    }

    public ISVNEntry getUnmanagedChild(String name) throws SVNException {
        ISVNEntry managed = this.getChild(name);
        if (managed != null) {
            return managed;
        }
        this.loadUnmanagedChildren();
        return (ISVNEntry)this.myAllUnmanagedChildren.get(name);
    }

    public void deleteChild(String name, boolean storeInfo) throws SVNException {
        this.loadEntries();
        ISVNEntry child = (ISVNEntry)this.myChildren.remove(name);
        Map oldMap = (Map)this.myChildEntries.remove(name);
        if (child != null) {
            this.doDeleteFiles(child);
        } else {
            child = this.getUnmanagedChild(name);
            if (child != null) {
                this.doDeleteFiles(child);
            }
        }
        if (storeInfo) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("svn:entry:name", name);
            map.put("svn:entry:deleted", Boolean.TRUE.toString());
            map.put("svn:entry:kind", (String)oldMap.get("svn:entry:kind"));
            if (oldMap.containsKey("svn:entry:revision")) {
                map.put("svn:entry:revision", (String)oldMap.get("svn:entry:revision"));
            }
            if (this.myDeletedEntries == null) {
                this.myDeletedEntries = new HashMap();
            }
            this.myDeletedEntries.put(name, map);
        }
    }

    public boolean isObstructed() {
        return super.isObstructed() || this.getRootEntry().getWorkingCopyFile(this).isFile() || !this.getAdminArea().getAdminArea(this).exists();
    }

    public boolean isDirectory() {
        return true;
    }

    public Map getChildEntryMap(String name) throws SVNException {
        this.loadEntries();
        return (Map)this.myChildEntries.get(name);
    }

    public void markAsCopied(String name, SVNRepositoryLocation source, long revision) throws SVNException {
        this.loadEntries();
        boolean wasDeleted = false;
        if (this.myDeletedEntries != null && this.myDeletedEntries.containsKey(name)) {
            wasDeleted = true;
            this.myDeletedEntries.remove(name);
        }
        HashMap<String, String> entry = new HashMap<String, String>();
        entry.put("svn:entry:copyfrom-url", source.toCanonicalForm());
        entry.put("svn:entry:copyfrom-rev", Long.toString(revision));
        entry.put("svn:entry:kind", "dir");
        entry.put("svn:entry:schedule", "add");
        entry.put("svn:entry:name", name);
        entry.put("svn:entry:copied", Boolean.TRUE.toString());
        if (wasDeleted) {
            entry.put("svn:entry:deleted", Boolean.TRUE.toString());
        }
        this.myChildEntries.put(name, entry);
        this.save(false);
        this.myChildren = null;
        this.myChildEntries = null;
        ISVNEntry copiedEntry = this.getChild(name);
        copiedEntry.setPropertyValue("svn:entry:copied", "true");
        copiedEntry.setPropertyValue("svn:entry:copyfrom-url", source.toCanonicalForm());
        copiedEntry.setPropertyValue("svn:entry:copyfrom-rev", Long.toString(revision));
        copiedEntry.setPropertyValue("svn:entry:schedule", "add");
        if (wasDeleted) {
            copiedEntry.setPropertyValue("svn:entry:deleted", Boolean.TRUE.toString());
        }
        FSDirEntry.updateURL(copiedEntry, this.getPropertyValue("svn:entry:url"));
        FSDirEntry.setPropertyValueRecursively(copiedEntry, "svn:entry:copied", "true");
        copiedEntry.save();
    }

    public void markAsCopied(InputStream contents, long length, Map properties, String name, SVNRepositoryLocation source) throws SVNException {
        long revision = SVNProperty.longValue((String)properties.get("svn:entry:revision"));
        FSFileEntry file = (FSFileEntry)this.addFile(name, revision);
        file.initProperties();
        file.applyChangedProperties(properties);
        SVNDiffWindow window = SVNDiffWindowBuilder.createReplacementDiffWindow(length);
        file.applyDelta(window, contents, false);
        file.deltaApplied(false);
        file.merge(false);
        if (source != null) {
            file.setPropertyValue("svn:entry:copied", "true");
            file.setPropertyValue("svn:entry:copyfrom-url", source.toCanonicalForm());
            file.setPropertyValue("svn:entry:copyfrom-rev", Long.toString(revision));
        }
        file.setPropertyValue("svn:entry:schedule", "add");
        file.setPropertyValue("svn:entry:revision", "0");
        file.setPropertyValue("svn:entry:kind", "file");
        if (source == null) {
            this.getAdminArea().getBaseFile(file).delete();
            this.getAdminArea().getBasePropertiesFile(file).delete();
            this.getAdminArea().getWCPropertiesFile(file).delete();
            file.setPropertyValue("svn:entry:committed-rev", null);
            file.setPropertyValue("svn:entry:committed-date", null);
            file.setPropertyValue("svn:entry:last-author", null);
            file.setPropertyValue("svn:entry:prop-time", null);
            file.setPropertyValue("svn:entry:text-time", null);
            file.setPropertyValue("svn:entry:checksum", null);
        }
        if (this.myDeletedEntries != null && this.myDeletedEntries.containsKey(name)) {
            file.setPropertyValue("svn:entry:deleted", Boolean.TRUE.toString());
            this.myDeletedEntries.remove(name);
        }
        this.save(false);
    }

    public ISVNEntry copy(String asName, ISVNEntry toCopy) throws SVNException {
        File dst = this.getRootEntry().getWorkingCopyFile(this);
        this.doCopyFiles(toCopy, dst, asName);
        long revision = SVNProperty.longValue(toCopy.getPropertyValue("svn:entry:revision"));
        String url = toCopy.getPropertyValue("svn:entry:url");
        ISVNEntry added = null;
        if (toCopy.isDirectory()) {
            added = this.addDirectory(asName, revision);
            Map childEntry = (Map)this.myChildEntries.get(asName);
            childEntry.put("svn:entry:schedule", "add");
            if (!toCopy.isScheduledForAddition()) {
                childEntry.put("svn:entry:copied", SVNProperty.toString(true));
                childEntry.put("svn:entry:copyfrom-rev", SVNProperty.toString(revision));
                childEntry.put("svn:entry:copyfrom-url", url);
            }
            FSDirEntry.updateURL(added, this.getPropertyValue("svn:entry:url"));
        } else {
            added = this.addFile(asName, revision);
            added.setPropertyValue("svn:entry:committed-rev", null);
        }
        added.setPropertyValue("svn:entry:schedule", "add");
        if (!toCopy.isScheduledForAddition()) {
            added.setPropertyValue("svn:entry:copyfrom-rev", SVNProperty.toString(revision));
            added.setPropertyValue("svn:entry:copyfrom-url", url);
        }
        if (this.myDeletedEntries != null && this.myDeletedEntries.containsKey(asName)) {
            added.setPropertyValue("svn:entry:deleted", Boolean.TRUE.toString());
            this.myDeletedEntries.remove(asName);
        }
        if (!toCopy.isScheduledForAddition()) {
            FSDirEntry.setPropertyValueRecursively(added, "svn:entry:copied", SVNProperty.toString(true));
        } else {
            FSDirEntry.setPropertyValueRecursively(added, "svn:entry:revision", SVNProperty.toString(0L));
        }
        return added;
    }

    public ISVNDirectoryEntry addDirectory(String name, long revision) throws SVNException {
        if (this.getChild(name) != null) {
            return (ISVNDirectoryEntry)this.getChild(name);
        }
        this.loadEntries();
        String url = (String)this.myDirEntry.get("svn:entry:url");
        url = PathUtil.append(url, PathUtil.encode(name));
        FSDirEntry entry = new FSDirEntry(this.getAdminArea(), this.getRootEntry(), PathUtil.append(this.getPath(), name), url);
        if (revision >= 0L) {
            entry.setPropertyValue("svn:entry:committed-rev", SVNProperty.toString(revision));
        }
        this.myChildren.put(name, entry);
        HashMap<String, String> entryMap = new HashMap<String, String>();
        entryMap.put("svn:entry:name", name);
        entryMap.put("svn:entry:kind", "dir");
        this.myChildEntries.put(name, entryMap);
        File dir = this.getRootEntry().getWorkingCopyFile(entry);
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        return entry;
    }

    public ISVNFileEntry addFile(String name, long revision) throws SVNException {
        this.loadEntries();
        HashMap<String, String> entryMap = new HashMap<String, String>();
        entryMap.put("svn:entry:name", name);
        entryMap.put("svn:entry:kind", "file");
        FSFileEntry entry = new FSFileEntry(this.getAdminArea(), this.getRootEntry(), PathUtil.append(this.getPath(), name), entryMap);
        if (revision >= 0L) {
            entry.setPropertyValue("svn:entry:committed-rev", SVNProperty.toString(revision));
        }
        this.myChildren.put(name, entry);
        this.myChildEntries.put(name, entryMap);
        return entry;
    }

    public Iterator childEntries() throws SVNException {
        this.loadEntries();
        return new LinkedList(this.myChildren.values()).iterator();
    }

    public Iterator deletedEntries() throws SVNException {
        this.loadEntries();
        LinkedList<Object> result = new LinkedList<Object>();
        if (this.myDeletedEntries != null) {
            result.addAll(this.myDeletedEntries.values());
        }
        if (this.myChildEntries != null) {
            Iterator entries = this.myChildEntries.values().iterator();
            while (entries.hasNext()) {
                Map entry = (Map)entries.next();
                if (entry.get("svn:entry:deleted") == null) continue;
                result.add(entry);
            }
        }
        return result.iterator();
    }

    public void dispose() throws SVNException {
        if (this.myChildren != null) {
            Iterator children = this.childEntries();
            while (children.hasNext()) {
                ((ISVNEntry)children.next()).dispose();
            }
        }
        this.myChildEntries = null;
        this.myDeletedEntries = null;
        this.myChildren = null;
        this.myDirEntry = null;
        this.myUnmanagedChildren = null;
        this.myAllUnmanagedChildren = null;
        super.dispose();
    }

    public boolean revert(String childName) throws SVNException {
        ISVNEntry child = this.getChild(childName);
        if (child == null) {
            return false;
        }
        this.myUnmanagedChildren = null;
        this.myAllUnmanagedChildren = null;
        if (child.isMissing() && child.isDirectory()) {
            Map childProperties = (Map)this.myChildEntries.get(child.getName());
            if ("add".equals(childProperties.get("svn:entry:schedule"))) {
                boolean keepInfo = childProperties.get("svn:entry:deleted") != null;
                this.deleteChild(child.getName(), keepInfo);
                return true;
            }
            return false;
        }
        if (child.isScheduledForAddition()) {
            this.myChildEntries.remove(childName);
            this.myChildren.remove(childName);
            if (child.isDirectory()) {
                File adminArea = this.getAdminArea().getAdminArea(child);
                FSUtil.deleteAll(adminArea);
            }
        } else {
            Map entryInParent;
            this.unschedule(childName);
            ((FSEntry)child).revertProperties();
            if (!child.isDirectory()) {
                ((FSFileEntry)child).restoreContents();
            } else if (child.getPropertyValue("svn:entry:prop-time") != null && this.myChildEntries != null && (entryInParent = (Map)this.myChildEntries.get(childName)) != null) {
                entryInParent.put("svn:entry:prop-time", child.getPropertyValue("svn:entry:prop-time"));
            }
        }
        return true;
    }

    public void merge(boolean recursive) throws SVNException {
        Object entries;
        String revision = this.getPropertyValue("svn:entry:revision");
        HashSet<String> obstructedChildren = new HashSet<String>();
        if (this.myChildren != null) {
            entries = new ArrayList(this.myChildren.values());
            Iterator children = entries.iterator();
            while (children.hasNext()) {
                ISVNEntry child = (ISVNEntry)children.next();
                if (!recursive && child.isDirectory()) continue;
                boolean isCorrupted = child.getPropertyValue("svn:entry:corrupted") != null;
                child.setPropertyValue("svn:entry:corrupted", null);
                if (child.getPropertyValue("svn:entry:revision") == null) {
                    DebugLog.log("MERGING: MISSING ENTRY DELETED: " + child.getPath());
                    this.deleteChild(child.getName(), true);
                    continue;
                }
                if (child.isScheduledForAddition() || child.isScheduledForDeletion() || isCorrupted) {
                    obstructedChildren.add(child.getName());
                } else {
                    child.setPropertyValue("svn:entry:revision", revision);
                }
                child.merge(recursive);
            }
        }
        super.merge();
        entries = this.myChildEntries.values().iterator();
        while (entries.hasNext()) {
            Map entry = (Map)entries.next();
            if (obstructedChildren.contains(entry.get("svn:entry:name"))) continue;
            entry.put("svn:entry:revision", revision);
        }
        this.myDeletedEntries = null;
        this.saveEntries();
    }

    public void commit() throws SVNException {
        if (!this.getRootEntry().getWorkingCopyFile(this).exists()) {
            return;
        }
        super.commit();
        this.saveEntries();
    }

    public void save(boolean recursive) throws SVNException {
        super.save(recursive);
        if (recursive && this.myChildren != null) {
            Iterator children = this.childEntries();
            while (children.hasNext()) {
                ISVNEntry entry = (ISVNEntry)children.next();
                entry.save();
            }
        }
        this.saveEntries();
    }

    private void saveEntries() throws SVNException {
        if (this.myDirEntry != null) {
            this.getAdminArea().saveEntries(this, this.myDirEntry, this.myChildEntries, this.myDeletedEntries);
        }
    }

    private void loadEntries() throws SVNException {
        if (this.myChildren != null) {
            return;
        }
        Map childEntriesMap = this.getAdminArea().loadEntries(this);
        this.myDirEntry = (Map)childEntriesMap.remove("");
        if (this.myDirEntry == null) {
            this.myDirEntry = new HashMap();
            this.myDirEntry.put("svn:entry:name", "");
            this.myDirEntry.put("svn:entry:kind", "dir");
        }
        this.myChildren = new HashMap();
        this.myChildEntries = new HashMap();
        String baseURL = (String)this.myDirEntry.get("svn:entry:url");
        String revision = (String)this.myDirEntry.get("svn:entry:revision");
        Iterator childEntries = childEntriesMap.values().iterator();
        while (childEntries.hasNext()) {
            Map entry = (Map)childEntries.next();
            String name = (String)entry.get("svn:entry:name");
            if (entry.containsKey("svn:entry:deleted")) {
                if (this.myDeletedEntries == null) {
                    this.myDeletedEntries = new HashMap();
                }
                if (!"add".equals(entry.get("svn:entry:schedule"))) {
                    this.myDeletedEntries.put(name, entry);
                    continue;
                }
            }
            FSEntry child = null;
            String url = null;
            if (!entry.containsKey("svn:entry:url")) {
                url = PathUtil.append(baseURL, PathUtil.encode(name));
                entry.put("svn:entry:url", url);
            }
            if (!entry.containsKey("svn:entry:revision")) {
                entry.put("svn:entry:revision", revision);
            }
            child = "dir".equals(entry.get("svn:entry:kind")) ? new FSDirEntry(this.getAdminArea(), this.getRootEntry(), PathUtil.append(this.getPath(), name), url) : new FSFileEntry(this.getAdminArea(), this.getRootEntry(), PathUtil.append(this.getPath(), name), entry);
            this.myChildren.put(name, child);
            this.myChildEntries.put(name, entry);
        }
    }

    protected Map getEntry() throws SVNException {
        this.loadEntries();
        return this.myDirEntry;
    }

    protected Map getChildEntry(String name) {
        if (this.myChildEntries != null && name != null) {
            return (Map)this.myChildEntries.get(name);
        }
        return null;
    }

    public Iterator unmanagedChildEntries(boolean includeIgnored) throws SVNException {
        this.loadUnmanagedChildren();
        Collection unmanagedChildren = includeIgnored ? this.myAllUnmanagedChildren.values() : this.myUnmanagedChildren.values();
        return new ArrayList(unmanagedChildren).iterator();
    }

    private void loadUnmanagedChildren() throws SVNException {
        if (this.myAllUnmanagedChildren != null) {
            return;
        }
        this.loadEntries();
        this.myAllUnmanagedChildren = new HashMap();
        this.myUnmanagedChildren = new HashMap();
        File dir = this.getRootEntry().getWorkingCopyFile(this);
        File[] children = dir.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                FSEntry childEntry;
                File child = children[i];
                if (this.myChildren != null && (this.myChildren.containsKey(child.getName()) || ".svn".equals(child.getName()))) continue;
                if (FSUtil.isWindows) {
                    boolean obsturcted = false;
                    Iterator names = this.myChildren.keySet().iterator();
                    while (names.hasNext()) {
                        String name = (String)names.next();
                        if (!name.equalsIgnoreCase(child.getName())) continue;
                        obsturcted = true;
                        break;
                    }
                    if (obsturcted) continue;
                }
                String path = PathUtil.append(this.getPath(), child.getName());
                if (child.isDirectory()) {
                    childEntry = new FSDirEntry(this.getAdminArea(), this.getRootEntry(), path, null);
                    childEntry.getEntry().put("svn:entry:kind", "dir");
                } else {
                    HashMap<String, String> entryMap = new HashMap<String, String>();
                    entryMap.put("svn:entry:name", child.getName());
                    entryMap.put("svn:entry:kind", "file");
                    childEntry = new FSFileEntry(this.getAdminArea(), this.getRootEntry(), path, entryMap);
                }
                ((FSEntry)childEntry).setManaged(childEntry.getPropertyValue("svn:entry:url") != null);
                if (!this.isIgnored(child.getName())) {
                    this.myUnmanagedChildren.put(child.getName(), childEntry);
                }
                this.myAllUnmanagedChildren.put(child.getName(), childEntry);
            }
        }
    }

    public ISVNEntry scheduleForAddition(String name, boolean mkdir, boolean recurse) throws SVNException {
        Map deletedProperties;
        String kind;
        this.loadEntries();
        ISVNEntry child = this.getChild(name);
        File file = new File(this.getRootEntry().getWorkingCopyFile(this), name);
        if (child != null && !child.isScheduledForDeletion()) {
            throw new SVNException("working copy file " + name + " already exists in " + this.getPath());
        }
        if (child != null && (child.isDirectory() && file.isFile() || !child.isDirectory() && !file.isFile())) {
            throw new SVNException("Cannot change node kind of " + name + " within path " + this.getPath());
        }
        if (this.myDeletedEntries != null && this.myDeletedEntries.get(name) != null && (kind = (String)(deletedProperties = (Map)this.myDeletedEntries.get(name)).get("svn:entry:kind")) != null && (file.isFile() && kind.equals("dir") || !file.isFile() && kind.equals("file"))) {
            throw new SVNException("Cannot change node kind of " + name + " within path " + this.getPath());
        }
        if (mkdir && !file.exists()) {
            file.mkdirs();
        }
        if (!file.exists()) {
            throw new SVNException("file " + file.getPath() + " doesn't exists");
        }
        this.myUnmanagedChildren = null;
        this.myAllUnmanagedChildren = null;
        String path = PathUtil.append(this.getPath(), name);
        FSEntry entry = null;
        Map<String, String> entryMap = null;
        if (child == null) {
            entryMap = new HashMap<String, String>();
            entryMap.put("svn:entry:name", name);
        } else {
            entryMap = (Map)this.myChildEntries.get(name);
        }
        if (child != null) {
            entryMap.put("svn:entry:schedule", "replace");
        } else {
            entryMap.put("svn:entry:schedule", "add");
            entryMap.put("svn:entry:kind", file.isDirectory() ? "dir" : "file");
        }
        String url = (String)this.getEntry().get("svn:entry:url");
        url = PathUtil.append(url, PathUtil.encode(name));
        if (this.myDeletedEntries != null && this.myDeletedEntries.containsKey(name)) {
            this.myDeletedEntries.remove(name);
            entryMap.put("svn:entry:deleted", Boolean.TRUE.toString());
        }
        if (file.isDirectory()) {
            if (child == null) {
                entry = new FSDirEntry(this.getAdminArea(), this.getRootEntry(), path, url);
                this.myChildren.put(name, entry);
                this.myChildEntries.put(name, entryMap);
                entry.getEntry().put("svn:entry:revision", SVNProperty.toString(0L));
                entry.getEntry().put("svn:entry:schedule", "add");
            } else {
                entry = (FSEntry)child;
                entry.getEntry().put("svn:entry:schedule", "replace");
            }
            if (recurse) {
                ISVNEntry ch;
                Iterator children = ((ISVNDirectoryEntry)((Object)entry)).childEntries();
                while (children.hasNext()) {
                    ch = (ISVNEntry)children.next();
                    if (!ch.isScheduledForDeletion() || !this.getRootEntry().getWorkingCopyFile(ch).exists()) continue;
                    ((FSDirEntry)entry).scheduleForAddition(ch.getName(), false, recurse);
                }
                children = ((ISVNDirectoryEntry)((Object)entry)).unmanagedChildEntries(false);
                while (children.hasNext()) {
                    ch = (ISVNEntry)children.next();
                    ((FSDirEntry)entry).scheduleForAddition(ch.getName(), false, recurse);
                }
            }
        } else if (child == null) {
            entryMap.put("svn:entry:revision", SVNProperty.toString(0L));
            entryMap.put("svn:entry:url", url);
            entry = new FSFileEntry(this.getAdminArea(), this.getRootEntry(), path, entryMap);
            this.myChildren.put(name, entry);
            this.myChildEntries.put(name, entryMap);
        } else if (child != null) {
            File propsFile = this.getAdminArea().getPropertiesFile(child);
            FSUtil.setReadonly(propsFile, false);
            propsFile.delete();
            entry = (FSEntry)child;
        }
        try {
            if (!entry.isDirectory() && !FileTypeUtil.isTextFile(this.getRootEntry().getWorkingCopyFile(entry))) {
                entry.setPropertyValue("svn:mime-type", "application/octet-stream");
            }
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
        return entry;
    }

    public ISVNEntry scheduleForDeletion(String name) throws SVNException {
        return this.scheduleForDeletion(name, false);
    }

    public ISVNEntry scheduleForDeletion(String name, boolean moved) throws SVNException {
        DebugLog.log("DELETING: " + name + " from " + this.getPath());
        ISVNEntry entry = this.getChild(name);
        if (entry == null) {
            if (moved) {
                DebugLog.log("DELETING UNMANAGED CHILD: " + name + " from " + this.getPath());
                this.deleteChild(name, false);
            }
            return entry;
        }
        if (entry.isScheduledForDeletion()) {
            return entry;
        }
        if (entry.isScheduledForAddition()) {
            if (moved) {
                boolean storeInfo;
                boolean bl = storeInfo = entry.getPropertyValue("svn:entry:deleted") != null;
                if (!storeInfo && entry.isDirectory()) {
                    storeInfo = ((Map)this.myChildEntries.get(name)).get("svn:entry:deleted") != null;
                }
                this.deleteChild(name, storeInfo);
            } else {
                this.myChildEntries.remove(name);
                this.myChildren.remove(name);
            }
            return entry;
        }
        ((FSEntry)entry).getEntry().put("svn:entry:schedule", "delete");
        if (entry.isDirectory()) {
            ISVNEntry child;
            Map entryMap = (Map)this.myChildEntries.get(name);
            if (entryMap != null) {
                entryMap.put("svn:entry:schedule", "delete");
            }
            Iterator children = ((ISVNDirectoryEntry)entry).childEntries();
            while (children.hasNext()) {
                child = (ISVNEntry)children.next();
                ((ISVNDirectoryEntry)entry).scheduleForDeletion(child.getName(), moved);
            }
            children = ((ISVNDirectoryEntry)entry).unmanagedChildEntries(true);
            while (children.hasNext()) {
                child = (ISVNEntry)children.next();
                ((ISVNDirectoryEntry)entry).scheduleForDeletion(child.getName(), moved);
            }
        } else {
            File file = this.getRootEntry().getWorkingCopyFile(entry);
            file.delete();
        }
        return entry;
    }

    public void unschedule(String name) throws SVNException {
        ISVNEntry child = this.getChild(name);
        if (child == null) {
            return;
        }
        if (child.isDirectory()) {
            Map entryMap = (Map)this.myChildEntries.get(name);
            if (entryMap != null) {
                FSDirEntry.unschedule(entryMap);
            }
            if (child.getPropertyValue("svn:entry:deleted") == null && entryMap.get("svn:entry:deleted") != null) {
                entryMap.remove("svn:entry:deleted");
            }
        }
        FSDirEntry.unschedule(((FSEntry)child).getEntry());
    }

    private static void unschedule(Map entryMap) {
        entryMap.remove("svn:entry:schedule");
        entryMap.remove("svn:entry:copied");
        entryMap.remove("svn:entry:copyfrom-url");
        entryMap.remove("svn:entry:copyfrom-rev");
    }

    public ISVNFileEntry asFile() {
        return null;
    }

    public ISVNDirectoryEntry asDirectory() {
        return this;
    }

    public boolean isManaged(String name) throws SVNException {
        this.loadEntries();
        return this.myChildEntries.containsKey(name);
    }

    public boolean isIgnored(String name) throws SVNException {
        String token;
        String ignored = this.getRootEntry().getGlobalIgnore();
        StringTokenizer tokens = new StringTokenizer(ignored, " \t\n\r");
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.length() == 0 || !FSDirEntry.ignoreMatches(token, name)) continue;
            return true;
        }
        ignored = this.getPropertyValue("svn:ignore");
        if (ignored != null) {
            tokens = new StringTokenizer(ignored, "\n\r");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (token.length() == 0 || !FSDirEntry.ignoreMatches(token, name)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean ignoreMatches(String token, String name) {
        token = token.replaceAll("\\.", "\\\\.");
        token = token.replaceAll("\\*", ".*");
        token = token.replaceAll("\\?", ".");
        return Pattern.matches(token, name);
    }

    private void doCopyFiles(ISVNEntry copy, File dst, String asName) throws SVNException {
        File src = this.getRootEntry().getWorkingCopyFile(copy);
        try {
            if (copy.isDirectory()) {
                File dir = new File(dst, asName);
                dir.mkdirs();
                Iterator children = copy.asDirectory().childEntries();
                while (children.hasNext()) {
                    ISVNEntry child = (ISVNEntry)children.next();
                    this.doCopyFiles(child, dir, child.getName());
                }
                this.getAdminArea().copyArea(dir, copy, asName);
            } else {
                FSUtil.copyAll(src, dst, asName, null);
                this.getAdminArea().copyArea(dst, copy, asName);
            }
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
    }

    private void doDeleteFiles(ISVNEntry entry) throws SVNException {
        if (entry.isDirectory()) {
            Iterator children = entry.asDirectory().childEntries();
            while (children.hasNext()) {
                ISVNEntry child = (ISVNEntry)children.next();
                this.doDeleteFiles(child);
            }
        }
        boolean keepWC = !entry.isDirectory() && entry.asFile().isContentsModified();
        this.getAdminArea().deleteArea(entry);
        if (keepWC) {
            return;
        }
        File file = this.getRootEntry().getWorkingCopyFile(entry);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public static void setPropertyValueRecursively(ISVNEntry root, String name, String value) throws SVNException {
        root.setPropertyValue(name, value);
        if (root.isDirectory()) {
            Iterator children = root.asDirectory().childEntries();
            while (children.hasNext()) {
                ISVNEntry child = (ISVNEntry)children.next();
                if ("svn:entry:copied".equals(name) && child instanceof FSDirEntry) {
                    if (value != null) {
                        ((Map)((FSDirEntry)root).myChildEntries.get(child.getName())).put(name, value);
                    } else {
                        ((Map)((FSDirEntry)root).myChildEntries.get(child.getName())).remove(name);
                    }
                }
                FSDirEntry.setPropertyValueRecursively(child, name, value);
            }
        }
    }

    public static void updateURL(ISVNEntry target, String parentURL) throws SVNException {
        parentURL = PathUtil.append(parentURL, PathUtil.encode(target.getName()));
        target.setPropertyValue("svn:entry:url", parentURL);
        DebugLog.log("url set: " + parentURL);
        if (target.isDirectory()) {
            Iterator children = target.asDirectory().childEntries();
            while (children.hasNext()) {
                ISVNEntry child = (ISVNEntry)children.next();
                FSDirEntry.updateURL(child, parentURL);
            }
        }
    }

    public ISVNEntryContent getContent() throws SVNException {
        return new FSDirEntryContent(this);
    }
}

