/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSEntryHandler;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

public class FSAdminArea {
    private File myRoot;

    public FSAdminArea(File root) {
        this.myRoot = root;
    }

    protected File getAdminArea(File dir) {
        return new File(dir, ".svn");
    }

    protected File getAdminArea(ISVNEntry entry) {
        File adminDir = entry.isDirectory() ? new File(this.myRoot, entry.getPath() + "/.svn") : new File(this.myRoot, PathUtil.removeTail(entry.getPath()) + "/.svn");
        return adminDir;
    }

    protected File initAdminArea(ISVNEntry entry) {
        File adminDir = this.getAdminArea(entry);
        if (!adminDir.exists()) {
            adminDir.mkdirs();
            FSUtil.setHidden(adminDir, true);
        }
        return adminDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map loadEntries(ISVNDirectoryEntry entry) throws SVNException {
        Map map;
        File entriesFile = new File(this.getAdminArea(entry), "entries");
        if (!entriesFile.exists()) {
            return new HashMap();
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(entriesFile), "UTF-8"));
                map = FSEntryHandler.parse(reader);
                Object var6_6 = null;
                if (reader == null) return map;
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return map;
        }
        reader.close();
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveEntries(ISVNDirectoryEntry entry, Map dirEntry, Map entries, Map deletedEntries) throws SVNException {
        File adminArea = this.initAdminArea(entry);
        Writer writer = null;
        File entriesFile = new File(adminArea, "entries");
        FSUtil.setReadonly(entriesFile, false);
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(entriesFile), "UTF-8"));
                if (deletedEntries == null) {
                    deletedEntries = Collections.EMPTY_MAP;
                }
                FSEntryHandler.save(writer, dirEntry, entries.values(), deletedEntries.values());
                this.writeDefaultFiles(adminArea);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SVNException(e);
            }
            Object var10_8 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e1) {}
        writer.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDefaultFiles(File adminDir) throws IOException {
        File empty;
        File readme;
        File format = new File(adminDir, "format");
        OutputStream os = null;
        if (!format.exists()) {
            try {
                os = new FileOutputStream(format);
                os.write(new byte[]{52, 10});
            }
            finally {
                os.close();
            }
        }
        if (!(readme = new File(adminDir, "README.txt")).exists()) {
            try {
                os = new FileOutputStream(readme);
                String eol = System.getProperty("line.separator");
                eol = eol == null ? "\n" : eol;
                os.write(("This is a Subversion working copy administrative directory." + eol + "Visit http://subversion.tigris.org/ for more information." + eol).getBytes());
            }
            finally {
                os.close();
            }
        }
        if (!(empty = new File(adminDir, "empty-file")).exists()) {
            empty.createNewFile();
        }
        File[] tmp = new File[]{new File(adminDir, "tmp" + File.separatorChar + "props"), new File(adminDir, "tmp" + File.separatorChar + "prop-base"), new File(adminDir, "tmp" + File.separatorChar + "text-base"), new File(adminDir, "tmp" + File.separatorChar + "wcprops"), new File(adminDir, "props"), new File(adminDir, "prop-base"), new File(adminDir, "text-base"), new File(adminDir, "wcprops")};
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].exists()) continue;
            tmp[i].mkdirs();
        }
    }

    public void saveBaseProperties(ISVNEntry entry, Map properties) throws SVNException {
        this.initAdminArea(entry);
        if (properties == null || entry == null || entry.isDirectory() && properties.isEmpty()) {
            return;
        }
        this.saveProperties(this.getBasePropertiesFile(entry), properties);
    }

    public void saveWCProperties(ISVNEntry entry, Map properties) throws SVNException {
        this.initAdminArea(entry);
        if (properties == null || entry == null || entry.isDirectory() && properties.isEmpty()) {
            return;
        }
        this.saveProperties(this.getWCPropertiesFile(entry), properties);
    }

    public void saveProperties(ISVNEntry entry, Map properties) throws SVNException {
        this.initAdminArea(entry);
        if (properties == null || entry == null || entry.isDirectory() && properties.isEmpty()) {
            return;
        }
        this.saveProperties(this.getPropertiesFile(entry), properties);
    }

    public void saveTemporaryProperties(ISVNEntry entry, Map properties) throws SVNException {
        this.initAdminArea(entry);
        if (properties == null || entry == null) {
            return;
        }
        this.saveProperties(this.getTemporaryPropertiesFile(entry), properties, true);
    }

    public Map loadProperties(ISVNEntry entry) throws SVNException {
        if (entry == null) {
            return null;
        }
        return this.loadProperties(this.getPropertiesFile(entry));
    }

    public Map loadBaseProperties(ISVNEntry entry) throws SVNException {
        if (entry == null) {
            return null;
        }
        return this.loadProperties(this.getBasePropertiesFile(entry));
    }

    public Map loadWCProperties(ISVNEntry entry) throws SVNException {
        if (entry == null) {
            return null;
        }
        return this.loadProperties(this.getWCPropertiesFile(entry));
    }

    public Map loadTemporaryProperties(ISVNEntry entry) throws SVNException {
        if (entry == null) {
            return null;
        }
        return this.loadProperties(this.getTemporaryPropertiesFile(entry));
    }

    public void deleteTemporaryProperties(ISVNEntry entry) {
        if (entry == null) {
            return;
        }
        this.getTemporaryPropertiesFile(entry).delete();
    }

    public long propertiesLastModified(ISVNEntry entry) {
        return this.getPropertiesFile(entry).lastModified();
    }

    protected File getBasePropertiesFile(ISVNEntry entry) {
        if (entry.isDirectory()) {
            return new File(this.getAdminArea(entry), "dir-prop-base");
        }
        return new File(this.getAdminArea(entry), "prop-base/" + entry.getName() + ".svn-base");
    }

    protected File getWCPropertiesFile(ISVNEntry entry) {
        if (entry.isDirectory()) {
            return new File(this.getAdminArea(entry), "dir-wcprops");
        }
        return new File(this.getAdminArea(entry), "wcprops/" + entry.getName() + ".svn-work");
    }

    protected File getPropertiesFile(ISVNEntry entry) {
        if (entry.isDirectory()) {
            return new File(this.getAdminArea(entry), "dir-props");
        }
        return new File(this.getAdminArea(entry), "props/" + entry.getName() + ".svn-work");
    }

    protected File getTemporaryPropertiesFile(ISVNEntry entry) {
        if (entry.isDirectory()) {
            return new File(this.getAdminArea(entry), "tmp/dir-props");
        }
        return new File(this.getAdminArea(entry), "tmp/props/" + entry.getName() + ".svn-work");
    }

    protected void saveProperties(File file, Map properties) throws SVNException {
        this.saveProperties(file, properties, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveProperties(File file, Map properties, boolean saveNull) throws SVNException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedWriter writer = null;
        StringBuffer buffer = new StringBuffer();
        FSUtil.setReadonly(file, false);
        try {
            try {
                writer = new BufferedWriter(new FileWriter(file));
                if (properties == null) {
                    properties = Collections.EMPTY_MAP;
                }
                Iterator values = properties.entrySet().iterator();
                while (values.hasNext()) {
                    Map.Entry entry = values.next();
                    if (!saveNull && entry.getValue() == null) continue;
                    buffer.append("K ");
                    buffer.append(entry.getKey().toString().length());
                    buffer.append("\n");
                    buffer.append(entry.getKey().toString());
                    if (entry.getValue() != null) {
                        buffer.append("\nV ");
                        buffer.append(entry.getValue().toString().length());
                        buffer.append("\n");
                        buffer.append(entry.getValue().toString());
                    }
                    buffer.append("\n");
                    writer.write(buffer.toString());
                    buffer.delete(0, buffer.length());
                }
                writer.write("END\n");
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
            Object var9_9 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        writer.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map loadProperties(File file) throws SVNException {
        if (file == null) return new HashMap();
        if (!file.exists()) {
            return new HashMap();
        }
        BufferedReader reader = null;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                String name = null;
                String value = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("K")) {
                        if (name != null) {
                            result.put(name, value);
                            name = null;
                            value = null;
                        }
                        name = reader.readLine();
                        continue;
                    }
                    if (line.startsWith("V")) {
                        int count = Integer.parseInt(line.substring(1).trim());
                        char[] chars = new char[count];
                        reader.read(chars);
                        value = new String(chars);
                        continue;
                    }
                    if (!"END".equals(line)) continue;
                    if (name != null) {
                        result.put(name, value);
                        name = null;
                        value = null;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
            Object var10_10 = null;
            if (reader == null) return result;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e1) {}
        reader.close();
        return result;
    }

    public void deleteArea(ISVNEntry entry) {
        File adminDir = this.getAdminArea(entry);
        if (entry.isDirectory()) {
            FSUtil.deleteAll(adminDir);
        } else {
            File[] adminFiles = new File[]{new File(adminDir, "prop-base/" + entry.getName() + ".svn-base"), new File(adminDir, "text-base/" + entry.getName() + ".svn-base"), new File(adminDir, "props/" + entry.getName() + ".svn-work"), new File(adminDir, "wcprops/" + entry.getName() + ".svn-work")};
            for (int i = 0; i < adminFiles.length; ++i) {
                if (adminFiles[i].delete()) continue;
                DebugLog.log("can't delete file " + adminFiles[i].getAbsolutePath());
            }
        }
    }

    public void copyArea(File dst, ISVNEntry src, String asName) throws SVNException {
        File dstAdminArea = this.getAdminArea(dst);
        File srcAdminArea = this.getAdminArea(src);
        try {
            if (!src.isDirectory()) {
                File baseFile = new File(srcAdminArea, "text-base/" + src.getName() + ".svn-base");
                File propsBaseFile = new File(srcAdminArea, "prop-base/" + src.getName() + ".svn-base");
                File propsFile = new File(srcAdminArea, "props/" + src.getName() + ".svn-work");
                FSUtil.copyAll(baseFile, new File(dstAdminArea, "text-base"), asName + ".svn-base", null);
                FSUtil.copyAll(propsBaseFile, new File(dstAdminArea, "prop-base"), asName + ".svn-base", null);
                FSUtil.copyAll(propsFile, new File(dstAdminArea, "props"), asName + ".svn-work", null);
            } else {
                dstAdminArea.mkdirs();
                FSUtil.setHidden(dstAdminArea, true);
                File propsFile = new File(srcAdminArea, "dir-props");
                File propsBaseFile = new File(srcAdminArea, "dir-prop-base");
                File entriesFile = new File(srcAdminArea, "entries");
                if (propsFile.exists()) {
                    FSUtil.copyAll(propsFile, dstAdminArea, "dir-props", null);
                }
                if (propsBaseFile.exists()) {
                    FSUtil.copyAll(propsBaseFile, dstAdminArea, "dir-prop-base", null);
                }
                FSUtil.copyAll(entriesFile, dstAdminArea, "entries", null);
                this.writeDefaultFiles(dstAdminArea);
            }
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
    }

    public void deleteTemporaryBaseFile(ISVNEntry entry) {
        File adminArea = this.initAdminArea(entry);
        File file = new File(adminArea, "tmp/text-base/" + entry.getName() + ".svn-base");
        file.delete();
    }

    public File getTemporaryBaseFile(ISVNEntry entry) {
        File adminArea = this.initAdminArea(entry);
        return new File(adminArea, "tmp/text-base/" + entry.getName() + ".svn-base");
    }

    public File getBaseFile(ISVNEntry entry) {
        File adminArea = this.initAdminArea(entry);
        return new File(adminArea, "text-base/" + entry.getName() + ".svn-base");
    }

    public boolean hasBaseFile(ISVNEntry entry) {
        return new File(this.getAdminArea(entry), "text-base/" + entry.getName() + ".svn-base").exists();
    }
}

